/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rds;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.TizenProjectType;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.rds.RdsDeltaDetector;
import org.tizen.common.rds.RdsDeltaListFile;
import org.tizen.common.rds.RdsMessages;
import org.tizen.common.rds.RdsResourceThreshold;
import org.tizen.common.sdb.command.SdbCommand;
import org.tizen.common.sdb.command.message.PkgcmdErrorType;
import org.tizen.common.sdb.command.receiver.PkgCmdReceiver;
import org.tizen.common.ui.page.properties.PackageConfigUtil;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.EFSUtil;
import org.tizen.common.util.ISdbCommandHelper;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.sdblib.util.ArrayUtil;
import org.tizen.sdblib.util.IOUtil;

public abstract class RdsDeployer
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(RdsDeployer.class);
    private static final String RDS_MARKER = "org.tizen.common.launch.rdsMarker";
    private static final String ZIP_EXTENSION = ".zip";
    private static final int RDS_OPERATION_COUNT_THRESHOLD = 50;
    private static final long RDS_OPERATION_SIZE_THRESHOLD = 0x1E00000L;
    private static final long RDS_LARGE_RESOURCE = 0x200000L;
    private static final String EMPTY_STRING = "";
    protected static final String BINARY_EXTENSION = ".exe";
    public static final String RDS_SEPARATOR = "/";
    protected static final String RDS_EMPTY = ".";
    protected static final String FILE_NAME_MANIFEST = "manifest.xml";
    protected static final String FILE_NAME_MULTI_MANIFEST = "manifest_multi.xml";
    protected static final String FILE_SIGNATURE_FILTER = "signature";
    protected IProgressMonitor monitor;
    protected ITizenConsoleManager console;
    protected String pkgType;
    protected String strAppInstallPath;
    protected IProject project;
    protected IDevice device;
    protected RdsDeltaDetector deltaDetector;
    protected ISdbCommandHelper tizenCommand;
    protected List<DeltaResourceInfo> ignoreList = new ArrayList<DeltaResourceInfo>();
    protected List<DeltaResourceInfo> interestList = new ArrayList<DeltaResourceInfo>();
    private SyncService syncService;
    private List<DeltaResourceInfo> deltaInfoList = null;
    private String strDeltaInfoFile = "";
    private boolean isMultiApp = false;
    private TizenProjectType projectType = TizenProjectType.TIZEN_WEB_APPLICATION;
    private static final String WEB_APP_BUILD_RESULT_PATH = "/.build/Result Resource Layer";

    protected abstract void printInfo(String var1);

    protected abstract String getAppInstallPath();

    protected abstract String getPkgId();

    protected abstract boolean sign(List<DeltaResourceInfo> var1) throws CoreException, IOException, IllegalStateException;

    protected abstract void mergeApplicationXML() throws Exception;

    public RdsDeployer(IProject project, IDevice device, ISdbCommandHelper tizenCommand, ITizenConsoleManager console, String pkgType, IProgressMonitor monitor) {
        List<IProject> referencedProjects;
        this.project = project;
        this.device = device;
        this.tizenCommand = tizenCommand;
        this.monitor = monitor;
        this.console = console;
        this.pkgType = pkgType;
        this.strAppInstallPath = this.getAppInstallPath();
        this.deltaDetector = new RdsDeltaDetector(device, project, this.strAppInstallPath);
        ITizenProject tizenProject = ProjectUtil.getTizenProject(project);
        if (tizenProject != null) {
            this.projectType = tizenProject.getTizenProjectType();
        }
        if ((referencedProjects = ProjectUtil.getReferencedProjects(project)) != null && referencedProjects.size() > 0) {
            this.isMultiApp = true;
        }
    }

    protected boolean preDeploy() throws CoreException {
        this.project.deleteMarkers(RDS_MARKER, true, 2);
        if (PackageConfigUtil.isBlackListDirty(this.project)) {
            return false;
        }
        if (!this.hasOldResourceInfo()) {
            this.logger.debug(RdsDeployer.makeRdsLog(RdsMessages.CANNOT_FIND_RDS_INFO));
            return false;
        }
        return true;
    }

    protected void configureRM(List<DeltaResourceInfo> deltaInfoList) {
    }

    public boolean deploy() throws CoreException {
        if (!this.preDeploy()) {
            return false;
        }
        List<DeltaResourceInfo> deltaInfoList = this.getInterestDelta();
        if (deltaInfoList == null) {
            return false;
        }
        if (deltaInfoList.isEmpty()) {
            return true;
        }
        this.configureRM(deltaInfoList);
        if (this.isMultiApp() && this.checkFileDuplication(deltaInfoList)) {
            return false;
        }
        if (this.isMultiApp() && this.isChangedManifest(deltaInfoList)) {
            try {
                this.mergeApplicationXML();
                deltaInfoList = this.projectType != TizenProjectType.TIZEN_WEB_APPLICATION && this.projectType != TizenProjectType.TIZEN_WEB_UIFW_APPLICATION && this.projectType != TizenProjectType.TIZEN_WEB_UIBUILDER_APPLICATION ? this.rearrangeManifestDelta(deltaInfoList, true) : this.rearrangeManifestDelta(deltaInfoList, false);
            }
            catch (Exception exception) {
                this.removeMergedManifest();
                return false;
            }
        }
        try {
            if (!this.sign(deltaInfoList)) {
                this.printInfo("Failed to sign for RDS");
                return false;
            }
        }
        catch (Exception e) {
            this.removeMergedManifest();
            this.printInfo("Failed to sign for RDS");
            this.logger.error("Failed to sign for RDS", (Throwable)e);
            return false;
        }
        this.cleanDeltaInfo();
        deltaInfoList = this.getInterestDelta();
        if (deltaInfoList == null) {
            return false;
        }
        if (deltaInfoList.isEmpty()) {
            return true;
        }
        if (this.isMultiApp() && this.isChangedManifest(deltaInfoList)) {
            deltaInfoList = this.projectType != TizenProjectType.TIZEN_WEB_APPLICATION && this.projectType != TizenProjectType.TIZEN_WEB_UIFW_APPLICATION && this.projectType != TizenProjectType.TIZEN_WEB_UIBUILDER_APPLICATION ? this.rearrangeManifestDelta(deltaInfoList, true) : this.rearrangeManifestDelta(deltaInfoList, false);
        }
        try {
            RdsResourceThreshold rdsOperation = this.checkDeltaResources(deltaInfoList);
            if (rdsOperation.getTotalCount() > 50 || rdsOperation.getTotalSize() > 0x1E00000L) {
                return false;
            }
            try {
                DeltaResourceInfo rdsDeltaInfo = this.makeRdsDeltaListFile(deltaInfoList);
                List<DeltaResourceInfo> rearrangedDeltaInfoList = this.makeZipAndRearrangeDeltaResources(deltaInfoList);
                this.partialZipInstall(rearrangedDeltaInfoList, rdsDeltaInfo);
            }
            catch (CoreException e) {
                this.logger.error(RdsMessages.CANNOT_PARTIALLY_INSTALL, (Throwable)e);
                this.printInfo(RdsDeployer.makeRdsLog(RdsMessages.CANNOT_PARTIALLY_INSTALL));
                this.reportWarning((IResource)this.project, e.getMessage(), false);
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        finally {
            this.removeZipFile();
            this.removeMergedManifest();
            this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        return true;
    }

    protected void reportWarning(IResource resource, String msg, boolean persistent) {
        try {
            IMarker m = resource.createMarker(RDS_MARKER);
            m.setAttribute("message", (Object)msg);
            m.setAttribute("priority", 2);
            m.setAttribute("severity", 1);
            m.setAttribute("transient", !persistent);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected List<DeltaResourceInfo> getInterestDelta() {
        List<DeltaResourceInfo> deltaInfoList = null;
        try {
            this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            deltaInfoList = this.getDelta();
            if (deltaInfoList == null) {
                this.newCoreException(RdsMessages.CANNOT_FIND_DELTA, null);
            }
            deltaInfoList = this.getInterestDelta(deltaInfoList);
        }
        catch (CoreException coreException) {
            this.printInfo(RdsDeployer.makeRdsLog(RdsMessages.CANNOT_FIND_DELTA));
            return null;
        }
        return deltaInfoList;
    }

    public void setInterestList(List<DeltaResourceInfo> list) {
        this.interestList = list;
    }

    public void appendInterestList(DeltaResourceInfo delta) {
        this.interestList.add(delta);
    }

    public void appendInterestList(List<DeltaResourceInfo> deltaList) {
        if (this.interestList != null) {
            int size = this.interestList.size();
            this.interestList.addAll(size, deltaList);
        }
    }

    public void setIgnoreList(List<DeltaResourceInfo> list) {
        this.ignoreList = list;
    }

    public void appendIgnoreList(List<DeltaResourceInfo> deltaList) {
        if (this.ignoreList != null) {
            int size = this.ignoreList.size();
            this.ignoreList.addAll(size, deltaList);
        }
    }

    protected String getRemotePathOfDelta(DeltaResourceInfo interest, String strProjectPath, DeltaResourceInfo delta) throws CoreException {
        String strRemotePath = EMPTY_STRING;
        String prefix = EMPTY_STRING;
        if (interest.getRemotePath() == null) {
            prefix = strProjectPath;
            strRemotePath = interest.convertToRemotePath(delta.getFullPath(), prefix, EMPTY_STRING);
        } else {
            File file = new File(delta.getFullPath());
            String interestRemotePath = EMPTY_STRING;
            String interestFullPath = EMPTY_STRING;
            if (this.isDirectory(interest.getFullPath())) {
                if (file.exists()) {
                    interestFullPath = interest.getFullPath();
                    interestRemotePath = interest.getRemotePath();
                } else {
                    interestFullPath = interest.getFullPath().substring(0, interest.getFullPath().length() - 1);
                    interestRemotePath = interest.getRemotePath().substring(0, interest.getRemotePath().length() - 1);
                }
            } else {
                interestFullPath = interest.getFullPath();
                interestRemotePath = interest.getRemotePath();
            }
            String rootProjectName = this.project.getName();
            String currentProjectName = delta.getProjectName();
            String deltaFullPath = delta.getFullPath();
            if (!rootProjectName.equals(currentProjectName) && !deltaFullPath.contains(BINARY_EXTENSION)) {
                strProjectPath = strProjectPath.replace(currentProjectName, rootProjectName);
                deltaFullPath = deltaFullPath.replace(currentProjectName, rootProjectName);
            }
            prefix = String.valueOf(strProjectPath) + interestFullPath;
            if (deltaFullPath.contains(FILE_NAME_MULTI_MANIFEST)) {
                deltaFullPath = deltaFullPath.replace(FILE_NAME_MULTI_MANIFEST, FILE_NAME_MANIFEST);
            }
            strRemotePath = interest.convertToRemotePath(deltaFullPath, prefix, interestRemotePath);
        }
        if (strRemotePath == null) {
            this.logger.error(String.format("Cannot make remotePath (host: %s, prefix: %s)", delta.getFullPath(), prefix));
            this.newCoreException(RdsDeployer.makeRdsLog(RdsMessages.CANNOT_FIND_DELTA), null);
        }
        if (2 == delta.getResourceType() && !"delete".equals(delta.getType()) && !strRemotePath.endsWith(RDS_SEPARATOR)) {
            strRemotePath = String.valueOf(strRemotePath) + RDS_SEPARATOR;
        }
        return strRemotePath.replaceFirst(RDS_SEPARATOR, EMPTY_STRING);
    }

    private String convertToRemotePath(String hostPath, String prefix, String replacement) {
        String result = null;
        if (hostPath.startsWith(prefix)) {
            result = String.valueOf(replacement) + hostPath.substring(prefix.length(), hostPath.length());
        }
        return result;
    }

    protected DeltaResourceInfo containsNode(DeltaResourceInfo node, List<DeltaResourceInfo> nodeList, String prefix) {
        File file = new File(node.getFullPath());
        for (DeltaResourceInfo tempNode : nodeList) {
            if (this.isDirectory(tempNode.getFullPath())) {
                if (!(file.exists() ? node.getFullPath().startsWith(String.valueOf(prefix) + tempNode.getFullPath()) : (String.valueOf(node.getFullPath()) + RDS_SEPARATOR).startsWith(String.valueOf(prefix) + tempNode.getFullPath()))) continue;
                return tempNode;
            }
            String interestFullPath = tempNode.getFullPath();
            String fullPath = node.getFullPath();
            if (this.isMultiApp && interestFullPath.contains(FILE_NAME_MANIFEST) && fullPath.contains(FILE_NAME_MULTI_MANIFEST)) {
                return tempNode;
            }
            if (tempNode.getFullPath().contains("*")) {
                String tempNodePathStr = String.valueOf(prefix) + tempNode.getFullPath();
                String nodePathStr = fullPath;
                int length = nodePathStr.length();
                int index = 0;
                int i = 0;
                while (i < length) {
                    char nodeChar = nodePathStr.charAt(i);
                    if (tempNodePathStr.length() < i + index + 1) break;
                    char tempNodeChar = tempNodePathStr.charAt(i + index);
                    if (tempNodeChar != nodeChar) {
                        if (tempNodeChar != '*') break;
                        if (tempNodePathStr.length() == i + index + 1) {
                            --index;
                        } else if (nodeChar != tempNodePathStr.charAt(i + index + 1)) {
                            --index;
                        } else if (nodeChar == tempNodePathStr.charAt(i + index + 1)) {
                            ++index;
                        }
                    }
                    ++i;
                }
                if (i == length && tempNodePathStr.length() == i + index) {
                    return tempNode;
                }
                if (i != length || tempNodePathStr.length() != i + index + 1 || tempNodePathStr.charAt(i + index) != '*') continue;
                return tempNode;
            }
            if (!fullPath.equals(String.valueOf(prefix) + tempNode.getFullPath())) continue;
            return tempNode;
        }
        return null;
    }

    protected boolean isDirectory(String path) {
        return path.endsWith(RDS_SEPARATOR);
    }

    private void partialZipInstall(List<DeltaResourceInfo> rearrangedDeltaInfoList, DeltaResourceInfo rdsDeltaInfo) throws CoreException {
        String command;
        block10: {
            command = null;
            try {
                try {
                    UserLogger.start("common.launch", ".rds.filepush");
                    for (DeltaResourceInfo node : rearrangedDeltaInfoList) {
                        String strRemoteAbsolutePath = String.valueOf(this.strAppInstallPath) + RDS_SEPARATOR + node.getRemotePath();
                        command = RdsDeployer.makeRdsLog(NLS.bind((String)RdsMessages.RDS_PUSH_LOG, (Object)node.getFullPath(), (Object)strRemoteAbsolutePath));
                        SyncResult result = this.getSyncService().push(node.getFullPath(), this.device.getFileEntry(strRemoteAbsolutePath).getParent());
                        if (!result.isOk()) {
                            throw new IOException(command);
                        }
                        this.tizenCommand.runCommand(String.format("unzip -o \"%s\" -d \"%s\"; echo cmd_ret:$?;", strRemoteAbsolutePath, this.strAppInstallPath), true, "cmd_ret:0");
                        this.printInfo(command);
                    }
                }
                catch (Exception e) {
                    this.newCoreException(RdsDeployer.makeRdsLog(RdsMessages.RDS_PUSH_ERROR), e);
                    UserLogger.end("common.launch", ".rds.filepush");
                    this.removeZipFile();
                    this.removeMergedManifest();
                    this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    break block10;
                }
            }
            catch (Throwable throwable) {
                UserLogger.end("common.launch", ".rds.filepush");
                this.removeZipFile();
                this.removeMergedManifest();
                this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                throw throwable;
            }
            UserLogger.end("common.launch", ".rds.filepush");
            this.removeZipFile();
            this.removeMergedManifest();
            this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        String strProjectPath = this.project.getLocation().toString();
        File file = new File(String.valueOf(strProjectPath) + RDS_SEPARATOR + ".rds_delta");
        if (file.exists()) {
            try {
                this.pushFile(file.getCanonicalPath(), this.strAppInstallPath);
                command = RdsDeployer.makeRdsLog(NLS.bind((String)RdsMessages.RDS_PUSH_LOG, (Object)file.getCanonicalPath(), (Object)(String.valueOf(this.strAppInstallPath) + RDS_SEPARATOR + file.getName())));
                this.printInfo(command);
            }
            catch (Exception e) {
                this.newCoreException(RdsDeployer.makeRdsLog(RdsMessages.RDS_PUSH_ERROR), e);
            }
            this.postInstall();
        }
    }

    public List<DeltaResourceInfo> getInterestDelta(List<DeltaResourceInfo> deltaInfoList) throws CoreException {
        ArrayList<DeltaResourceInfo> delta = new ArrayList<DeltaResourceInfo>();
        DeltaResourceInfo interestNode = null;
        String strRemotePath = EMPTY_STRING;
        for (DeltaResourceInfo node : deltaInfoList) {
            String strProjectPath = this.project.getLocation().toString();
            String nodeProjectName = node.getProjectName();
            if (nodeProjectName != null && !this.project.getName().equals(nodeProjectName)) {
                strProjectPath = strProjectPath.replace(this.project.getName(), nodeProjectName);
            }
            interestNode = null;
            if (this.containsNode(node, this.ignoreList, strProjectPath) != null || (interestNode = this.containsNode(node, this.interestList, strProjectPath)) == null) continue;
            strRemotePath = this.getRemotePathOfDelta(interestNode, strProjectPath, node);
            node.setRemotePath(strRemotePath);
            delta.add(node);
            this.getInterestDelta(node.getChildren());
        }
        return delta;
    }

    public void cleanDeltaInfo() {
        this.deltaInfoList = null;
        this.strDeltaInfoFile = null;
    }

    public List<DeltaResourceInfo> getDelta() {
        if (this.deltaInfoList == null) {
            this.deltaInfoList = this.deltaDetector.getDelta();
            this.strDeltaInfoFile = this.deltaDetector.makeDeltaFile();
        }
        return this.deltaInfoList;
    }

    public String getDeltaInfoFile() {
        this.getDelta();
        return this.strDeltaInfoFile;
    }

    protected void postInstall() throws CoreException {
        SdbCommand sdbCommand = new SdbCommand(this.device, this.console, new PkgCmdReceiver(this.console));
        int timeout = 20000;
        try {
            String installCommand = String.format(TizenPlatformConstants.PKG_TOOL_REINSTALL_COMMAND, this.pkgType.toLowerCase(), this.getPkgId());
            sdbCommand.runCommand(installCommand, new PkgcmdErrorType(), timeout);
            sdbCommand.runCommand(String.format(TizenPlatformConstants.REMOVE_FILE_COMMAND, this.strAppInstallPath));
        }
        catch (TimeoutException e) {
            this.newCoreException(RdsDeployer.makeRdsLog(NLS.bind((String)LaunchMessages.SDB_TIMEOUT_EXCEPTION, (Object)timeout)), e);
        }
        catch (Exception e) {
            this.newCoreException(RdsDeployer.makeRdsLog(RdsMessages.CANNOT_INSTALL), e);
        }
    }

    protected boolean hasOldResourceInfo() {
        boolean readOldTree = this.deltaDetector.readOldTree();
        return readOldTree;
    }

    protected boolean isMultiApp() {
        return this.isMultiApp;
    }

    public void pushResInfoFile() {
        String appInstallPath = this.getAppInstallPath();
        this.strDeltaInfoFile = this.deltaDetector.makeDeltaFile();
        String strRemotePath = String.valueOf(appInstallPath) + "/info/";
        try {
            this.pushFile(this.strDeltaInfoFile, strRemotePath);
        }
        catch (Exception e) {
            this.logger.error(RdsDeployer.makeRdsLog(RdsMessages.RDS_RES_INFO_PUSH_ERROR), (Throwable)e);
        }
    }

    public void removeResInfoFile() {
        String appInstallPath = this.getAppInstallPath();
        String strRemotePath = String.valueOf(appInstallPath) + "/info/" + ".sdk_delta.info";
        try {
            SdbCommand sdbCommand = new SdbCommand(this.device);
            String command = String.format(TizenPlatformConstants.REMOVE_FILE_COMMAND, strRemotePath);
            sdbCommand.runCommand(command);
        }
        catch (Exception e) {
            this.logger.error(RdsDeployer.makeRdsLog(String.valueOf(RdsMessages.RDS_DELETE_ERROR) + " - " + strRemotePath), (Throwable)e);
        }
    }

    public static String makeRdsLog(String log) {
        return String.valueOf(RdsMessages.RDS_MODE_PREFIX) + " " + log;
    }

    private void pushFile(String source, String dest) throws Exception {
        SyncResult result = this.getSyncService().push(source, this.device.getFileEntry(dest));
        if (!result.isOk()) {
            throw new Exception(result.getMessage());
        }
    }

    protected void newCoreException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.tizen.common", message, exception);
        throw new CoreException((IStatus)status);
    }

    protected SyncService getSyncService() throws Exception {
        if (this.syncService == null) {
            this.syncService = this.device.getSyncService();
        }
        return this.syncService;
    }

    @Override
    public void close() throws IOException {
        if (this.syncService != null) {
            this.syncService.close();
        }
    }

    private RdsResourceThreshold checkDeltaResources(List<DeltaResourceInfo> deltaInfoList) {
        RdsResourceThreshold rdsOperation = new RdsResourceThreshold();
        int removeResourceCount = 0;
        long totalSize = 0L;
        long sumOfLargeResourceSize = 0L;
        for (DeltaResourceInfo deltaInfo : deltaInfoList) {
            String resourcePath = deltaInfo.getFullPath();
            String type = deltaInfo.getType();
            File currentResource = new File(resourcePath);
            long currentResourceSize = currentResource.length();
            if ("modify".equals(type) || "add".equals(type)) {
                if (currentResourceSize > 0x200000L) {
                    rdsOperation.getLargeResources().add(deltaInfo);
                    sumOfLargeResourceSize += currentResourceSize;
                }
                if (!currentResource.isFile()) continue;
                totalSize += currentResourceSize;
                continue;
            }
            ++removeResourceCount;
        }
        int totalCount = deltaInfoList.size() - removeResourceCount;
        rdsOperation.setTotalCount(totalCount);
        rdsOperation.setTotalSize(totalSize);
        rdsOperation.setSumOfLargeResourceSize(sumOfLargeResourceSize);
        int largeResourceCount = rdsOperation.getLargeResources().size();
        rdsOperation.setLargeResourceCount(largeResourceCount);
        return rdsOperation;
    }

    private void removeZipFile() {
        FilenameFilter filter;
        ITizenProject tizenProject = ProjectUtil.getTizenProject(this.project);
        final String appId = tizenProject.getAppId();
        String zipFilePath = this.project.getLocation().toString();
        File zipFile = new File(zipFilePath);
        Object[] listFiles = zipFile.listFiles(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean isMatched = name.toLowerCase().contains(appId.toLowerCase()) && name.toLowerCase().contains(".z");
                return isMatched;
            }
        });
        if (!ArrayUtil.isEmpty((Object[])listFiles)) {
            Object[] objectArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                Object deleteFile = objectArray[n2];
                ((File)deleteFile).delete();
                ++n2;
            }
        }
    }

    private void removeMergedManifest() {
        String mergedManifestPath = null;
        mergedManifestPath = this.projectType != TizenProjectType.TIZEN_WEB_APPLICATION && this.projectType != TizenProjectType.TIZEN_WEB_UIFW_APPLICATION && this.projectType != TizenProjectType.TIZEN_WEB_UIBUILDER_APPLICATION ? String.valueOf(this.getRootPrjPath()) + RDS_SEPARATOR + FILE_NAME_MULTI_MANIFEST : String.valueOf(this.getRootPrjPath()) + RDS_SEPARATOR + FILE_NAME_MANIFEST;
        File mergedManifestFile = new File(mergedManifestPath);
        if (mergedManifestFile.exists()) {
            mergedManifestFile.delete();
        }
    }

    private List<DeltaResourceInfo> makeZipAndRearrangeDeltaResources(List<DeltaResourceInfo> deltaInfoList) throws IOException {
        ArrayList<DeltaResourceInfo> rearrangedDeltaInfoList = new ArrayList<DeltaResourceInfo>();
        ITizenProject tizenProject = ProjectUtil.getTizenProject(this.project);
        String appId = tizenProject.getAppId();
        String zipFilePath = String.valueOf(this.project.getLocation().toString()) + File.separator + appId + ZIP_EXTENSION;
        File zipFile = new File(zipFilePath);
        byte[] buf = new byte[4096];
        FileOutputStream fos = null;
        ZipArchiveOutputStream zaos = null;
        FileInputStream in = null;
        try {
            fos = new FileOutputStream(zipFile);
            zaos = new ZipArchiveOutputStream((OutputStream)fos);
            boolean isExistEmptyEntry = false;
            for (DeltaResourceInfo deltaInfo : deltaInfoList) {
                String currentResourcePath = deltaInfo.getFullPath();
                File currentResource = new File(currentResourcePath);
                if (currentResource.isDirectory()) {
                    zaos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(deltaInfo.getRemotePath()));
                    continue;
                }
                if ("delete".equals(deltaInfo.getType())) {
                    if (isExistEmptyEntry) continue;
                    zaos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(RDS_EMPTY));
                    isExistEmptyEntry = true;
                    continue;
                }
                String remotePath = deltaInfo.getRemotePath();
                if (currentResourcePath.contains(FILE_NAME_MULTI_MANIFEST)) {
                    remotePath = remotePath.replace(FILE_NAME_MULTI_MANIFEST, FILE_NAME_MANIFEST);
                }
                try {
                    int len;
                    IResource deltaRes = deltaInfo.getResource();
                    if (deltaRes != null && deltaRes.isLinked()) {
                        currentResource = deltaRes.getLocation().toFile();
                    }
                    in = new FileInputStream(currentResource);
                    ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(deltaInfo.getRemotePath());
                    if (OSChecker.isLinux()) {
                        zipArchiveEntry.setUnixMode(EFSUtil.getPermissions(currentResource.getAbsolutePath()));
                    }
                    zaos.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                    while ((len = in.read(buf)) > 0) {
                        zaos.write(buf, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose(in);
                    throw throwable;
                }
                IOUtil.tryClose((Closeable)in);
            }
        }
        catch (Throwable throwable) {
            if (zaos != null) {
                zaos.closeArchiveEntry();
                org.tizen.common.util.IOUtil.tryClose(zaos);
            }
            throw throwable;
        }
        if (zaos != null) {
            zaos.closeArchiveEntry();
            org.tizen.common.util.IOUtil.tryClose(zaos);
        }
        DeltaResourceInfo zipDeltaInfo = new DeltaResourceInfo(appId, zipFilePath, zipFile.getName(), "add", 1);
        rearrangedDeltaInfoList.add(zipDeltaInfo);
        return rearrangedDeltaInfoList;
    }

    private DeltaResourceInfo makeRdsDeltaListFile(List<DeltaResourceInfo> deltaInfoList) throws CoreException {
        RdsDeltaListFile deltaListFile = new RdsDeltaListFile();
        String rootProjectPath = this.project.getLocation().toString();
        String comareProjectPath = null;
        for (DeltaResourceInfo node : deltaInfoList) {
            DeltaResourceInfo interestNode;
            String projectName = node.getProjectName();
            if (projectName != null) {
                int length;
                String[] split = rootProjectPath.split(RDS_SEPARATOR);
                String rootProjectName = split[(length = split.length) - 1];
                comareProjectPath = !rootProjectName.equals(projectName) ? rootProjectPath.replace(rootProjectName, projectName) : rootProjectPath;
            }
            if (this.containsNode(node, this.ignoreList, comareProjectPath) != null || (interestNode = this.containsNode(node, this.interestList, comareProjectPath)) == null) continue;
            String strRemotePath = this.getRemotePathOfDelta(interestNode, comareProjectPath, node);
            String type = node.getType();
            if ("modify".equals(type)) {
                deltaListFile.addModifyDelta(strRemotePath);
                continue;
            }
            if ("add".equals(type)) {
                deltaListFile.addAddDelta(strRemotePath);
                continue;
            }
            if (!"delete".equals(type)) continue;
            deltaListFile.addDeleteDelta(strRemotePath);
        }
        File file = deltaListFile.makeFile(rootProjectPath);
        if (file == null) {
            this.newCoreException(RdsDeployer.makeRdsLog(RdsMessages.CANNOT_FIND_RDS_INFO), null);
        } else if (!file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (!created) {
                    this.newCoreException(RdsDeployer.makeRdsLog(RdsMessages.CANNOT_FIND_RDS_INFO), null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        DeltaResourceInfo rdsDeltaInfo = new DeltaResourceInfo(file.getName(), file.getAbsolutePath(), file.getName(), "add", 1);
        return rdsDeltaInfo;
    }

    protected boolean isChangedManifest(List<DeltaResourceInfo> deltaList) {
        boolean isChanged = false;
        for (DeltaResourceInfo delta : deltaList) {
            String fullPath = delta.getFullPath();
            if (fullPath == null || !fullPath.contains(FILE_NAME_MANIFEST)) continue;
            isChanged = true;
            break;
        }
        return isChanged;
    }

    protected String getRootPrjPath() {
        return this.project.getLocation().toString();
    }

    protected String[] getRefPrjPaths() {
        List<IProject> referencedProjects = ProjectUtil.getReferencedProjects(this.project);
        int referencedProjectCount = referencedProjects.size();
        if (referencedProjects != null && referencedProjectCount > 0) {
            String[] refPrjPaths = new String[referencedProjectCount];
            int i = 0;
            while (i < referencedProjectCount) {
                IProject project = referencedProjects.get(i);
                refPrjPaths[i] = project.getLocation().toFile().getAbsolutePath();
                ++i;
            }
            return refPrjPaths;
        }
        return new String[0];
    }

    private List<DeltaResourceInfo> rearrangeManifestDelta(List<DeltaResourceInfo> deltaInfoList, boolean isNative) {
        ArrayList<DeltaResourceInfo> rearrangeManifestDelta = new ArrayList<DeltaResourceInfo>();
        boolean isManifestRearranged = false;
        String rootProjectName = this.project.getName();
        String multiManifestPath = null;
        multiManifestPath = isNative ? String.valueOf(this.getRootPrjPath()) + RDS_SEPARATOR + FILE_NAME_MULTI_MANIFEST : String.valueOf(this.getRootPrjPath()) + RDS_SEPARATOR + FILE_NAME_MANIFEST;
        for (DeltaResourceInfo deltaInfo : deltaInfoList) {
            String fullPath = deltaInfo.getFullPath();
            if (fullPath == null) continue;
            if (fullPath.contains(FILE_NAME_MANIFEST)) {
                if (isManifestRearranged) continue;
                deltaInfo.setFullPath(multiManifestPath);
                deltaInfo.setProjectName(rootProjectName);
                rearrangeManifestDelta.add(deltaInfo);
                isManifestRearranged = true;
                continue;
            }
            if (fullPath.contains(FILE_NAME_MULTI_MANIFEST)) continue;
            rearrangeManifestDelta.add(deltaInfo);
        }
        return rearrangeManifestDelta;
    }

    private boolean checkFileDuplication(List<DeltaResourceInfo> deltaInfoList) {
        boolean isDuplicated = false;
        String rootProjectName = this.project.getName();
        String rootProjectPath = this.project.getLocation().toString();
        for (DeltaResourceInfo delta : deltaInfoList) {
            File file;
            File deltaFile;
            String deltaFullPath;
            String comparePath = null;
            String type = delta.getType();
            if (type.equals("delete") || (deltaFullPath = delta.getFullPath()).contains(FILE_NAME_MANIFEST) || !(deltaFile = new File(deltaFullPath)).exists() || deltaFile.isDirectory()) continue;
            String deltaProjectName = delta.getProjectName();
            int deltaProjectRootIndex = deltaFullPath.indexOf(String.valueOf(deltaProjectName) + RDS_SEPARATOR);
            deltaFullPath = deltaFullPath.substring(deltaProjectRootIndex + deltaProjectName.length());
            List<IProject> projects = this.deltaDetector.getProjects();
            if (!rootProjectName.equals(deltaProjectName) && (file = new File(comparePath = String.valueOf(rootProjectPath) + deltaFullPath)).exists()) {
                isDuplicated = true;
                break;
            }
            for (IProject project : projects) {
                File file2;
                String projectName = project.getName();
                if (deltaProjectName.equals(projectName) || !(file2 = new File(comparePath = String.valueOf(project.getLocation().toString()) + deltaFullPath)).exists()) continue;
                isDuplicated = true;
                return isDuplicated;
            }
        }
        return isDuplicated;
    }

    public boolean checkValidDelta(DeltaResourceInfo delta) {
        boolean isValidDelta = false;
        String comparePathOfDelta = this.getComparePath(delta.getFullPath(), delta.getProjectName());
        List<IProject> projects = this.deltaDetector.getProjects();
        int i = 0;
        while (i < projects.size()) {
            IProject findDeltaProject = projects.get(i);
            if (!findDeltaProject.equals((Object)this.project)) {
                List<DeltaResourceInfo> deltaListOfProject = this.deltaDetector.getDelta(findDeltaProject);
                int j = 0;
                while (j < deltaListOfProject.size()) {
                    DeltaResourceInfo compareDelta = deltaListOfProject.get(j);
                    String comparePath = this.getComparePath(compareDelta.getFullPath(), compareDelta.getProjectName());
                    if (comparePathOfDelta.equals(comparePath)) {
                        isValidDelta = true;
                        return isValidDelta;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return isValidDelta;
    }

    public String getComparePath(String fullPath, String projectName) {
        String[] split;
        int indexOf;
        String comparePath = null;
        if (fullPath.contains(WEB_APP_BUILD_RESULT_PATH)) {
            fullPath = fullPath.replace(WEB_APP_BUILD_RESULT_PATH, EMPTY_STRING);
        }
        if ((comparePath = fullPath.substring((indexOf = fullPath.indexOf(projectName)) + projectName.length())).contains(BINARY_EXTENSION) && (split = comparePath.split(RDS_SEPARATOR)) != null && split.length > 0) {
            comparePath = split[split.length - 1];
        }
        return comparePath;
    }

    public boolean isSignatureFile(DeltaResourceInfo delta) {
        File signatureFile;
        boolean isSignature = false;
        if (delta.getFullPath().contains(FILE_SIGNATURE_FILTER) && (signatureFile = new File(delta.getFullPath())).exists() && signatureFile.isFile()) {
            isSignature = true;
        }
        return isSignature;
    }
}

