/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildfileMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.core.application.tproject.TprojectHandler;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonBuildTargetManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.build.model.SBIModel;

public class CommonConfigurationManager {
    private static Logger logger = LoggerFactory.getLogger(CommonConfigurationManager.class);
    private static String APICheckerOptions = "";
    private static String APICheckerMiscOptions = "";
    private static String OutStream = "";
    private static String miscToolOptions = "";
    static final String SLP_PROJECT_INFO_STORAGE_MODULE_ID = "com.samsung.tizen.nativeapp.projectInfo";
    public static final String SBI_BASE_C_COMPILER_TOOL_ID = "org.tizen.nativeide.tool.sbi.gnu.c.compiler.base";
    public static final String SBI_BASE_CPP_COMPILER_TOOL_ID = "org.tizen.nativeide.tool.sbi.gnu.cpp.compiler.base";
    public static final String SBI_ASSEMBLER_TOOL_ID = "org.tizen.nativeapp.tool.sbi.gnu.assembler.base";
    public static final String SBI_C_TARGET_OPTION_ID = "sbi.gnu.c.compiler.option";
    public static final String SBI_CPP_TARGET_OPTION_ID = "sbi.gnu.cpp.compiler.option";
    public static final String GNU_C_INCLUDE_PATH_OPTION_ID = "gnu.c.compiler.option.include.paths";
    public static final String GNU_CPP_INCLUDE_PATH_OPTION_ID = "gnu.cpp.compiler.option.include.paths";
    public static final String GNU_C_DEF_SYMBOLS_OPTION_ID = "gnu.c.compiler.option.preprocessor.def.symbols";
    public static final String GNU_CPP_DEF_SYMBOLS_OPTION_ID = "gnu.cpp.compiler.option.preprocessor.def";
    public static final String GNU_C_OTHER_ID = "gnu.c.compiler.option.misc.other";
    public static final String GNU_CPP_OTHER_ID = "gnu.cpp.compiler.option.other.other";
    public static final String SBI_C_LINKER_TOOL_ID = "org.tizen.nativeide.tool.sbi.gnu.c.linker.base";
    public static final String SBI_CPP_LINKER_TOOL_ID = "org.tizen.nativeide.tool.sbi.gnu.cpp.linker.base";
    public static final String SBI_ARCHIVER_TOOL_ID = "org.tizen.nativeide.tool.sbi.gnu.archiver.base";
    public static final String GNU_C_LIBRARIES_OPTION_ID = "gnu.c.link.option.libs";
    public static final String GNU_CPP_LIBRARIES_OPTION_ID = "gnu.cpp.link.option.libs";
    public static final String GNU_C_USEROBJS_OPTION_ID = "gnu.c.link.option.userobjs";
    public static final String GNU_CPP_USEROBJS_OPTION_ID = "gnu.cpp.link.option.userobjs";
    public static final String GNU_C_LINKPATH_OPTION_ID = "gnu.c.link.option.paths";
    public static final String GNU_CPP_LINKPATH_OPTION_ID = "gnu.cpp.link.option.paths";
    public static final String GNU_C_LINKOTHER_OPTION_ID = "gnu.c.link.option.other";
    public static final String GNU_CPP_LINKOTHER_OPTION_ID = "gnu.cpp.link.option.other";
    public static final String GNU_C_LINK_OPTION_ID = "gnu.c.link.option.flags";
    public static final String GNU_CPP_LINK_OPTION_ID = "gnu.cpp.link.option.flags";
    public static final String GNU_CPP_DIALECT_OPTION_ID = "gnu.cpp.compiler.option.dialect.std";
    public static final String GNU_DIALECT_CPP11_OPTION = "gnu.cpp.compiler.dialect.c++11";
    public static final String SBI_DEVICE_CONFIG_SUFFIX = "Tizen-Device";
    public static final String SBI_EMULATOR_CONFIG_SUFFIX = "Tizen-Emulator";
    public static final String SBI_RELEASE_CONFIG_SUFFIX = "Release";
    public static final String SBI_DEBUG_CONFIG_SUFFIX = "Debug";
    public static final String SBI_EDC_COMPILER_TOOL_ID = "org.tizen.nativecore.tool.sbi.edc.compiler";
    public static final String SBI_EDC_COMPILER_ID_OPTION_ID = "sbi.gnu.edc.compiler.option.misc.id";
    public static final String SBI_EDC_COMPILER_ENVENTOR_ID_OPTION_ID = "sbi.gnu.edc.compiler.option.misc.id.enventor";
    public static final String SBI_EDC_COMPILER_FD_OPTION_ID = "sbi.gnu.edc.compiler.option.misc.fd";
    public static final String SBI_EDC_COMPILER_ENVENTOR_FD_OPTION_ID = "sbi.gnu.edc.compiler.option.misc.fd.enventor";
    public static final String SBI_EDC_COMPILER_SD_OPTION_ID = "sbi.gnu.edc.compiler.option.misc.sd";
    public static final String SBI_EDC_COMPILER_ENVENTOR_SD_OPTION_ID = "sbi.gnu.edc.compiler.option.misc.sd.enventor";
    public static final String SBI_CPP_DEV_PACKAGE_OPTION_LFALGS_ID = "sbi.gnu.cpp.linker.option.frameworks_lflags.core";
    public static final String SBI_C_DEV_PACKAGE_OPTION_CFLAGS_ID = "sbi.gnu.c.compiler.option.frameworks_cflags.core";
    public static final String SBI_CPP_DEV_PACKAGE_OPTION_CFLAGS_ID = "sbi.gnu.cpp.compiler.option.frameworks_cflags.core";
    public static final String SBI_C_DEV_PACKAGE_OPTION_INCLUDE_ID = "sbi.gnu.c.compiler.option.frameworks_inc.core";
    public static final String[] ARCHGROUP_X86 = new String[]{"x86", "86", "i386", "ia32", "i586", "i686", "LLVM-Bitcode/X86"};
    public static final String[] ARCHGROUP_ARM = new String[]{"arm", "armv7-a", "armel", "armv7l", "LLVM-Bitcode/ARM"};
    public static final String[] ARCHGROUP_X86_64 = new String[]{"x86_64"};
    public static final String[] ARCHGROUP_ARM_64 = new String[]{"aarch64"};
    public static final String DEFAULT_BUILD_TARGET_MGR_KEY = "default.buildtarget.mgr";
    private static Map<String, CommonBuildTargetManager> buildTargetMap = new HashMap<String, CommonBuildTargetManager>();

    static {
        buildTargetMap.put(DEFAULT_BUILD_TARGET_MGR_KEY, new CommonBuildTargetManager());
    }

    public static void registerBuildTargetManager(String[] projectType, CommonBuildTargetManager mgr) {
        String[] stringArray = projectType;
        int n = projectType.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            buildTargetMap.put(type, mgr);
            ++n2;
        }
    }

    public static void initializeBuildTargetName(IProject project, boolean save) {
        try {
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            IConfiguration defaultConfig = info.getDefaultConfiguration();
            SmartBuildInterface sbi = SmartBuildInterface.getInstance(project);
            IConfiguration[] iConfigurationArray = defaultConfig.getManagedProject().getConfigurations();
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                String targetID = CommonConfigurationManager.getDefaultBuildTargetName(config);
                if (!sbi.checkTargetID(targetID)) {
                    sbi.writeTargetCfgFile(targetID);
                }
                CommonConfigurationManager.setBuildTargetName(config, targetID);
                CommonConfigurationManager.setToolCommand(config);
                ++n2;
            }
            if (save) {
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            }
        }
        catch (SBIException e) {
            logger.error("Failed to initialize build target", (Throwable)e);
            e.showErrorDialog();
        }
    }

    public static String getProjectType(IConfiguration config) {
        IProjectType configProjectType = null;
        if (config.getProjectType() != null) {
            configProjectType = config.getProjectType();
        } else if (config.getParent() != null) {
            configProjectType = config.getParent().getProjectType();
        }
        if (configProjectType == null) {
            return null;
        }
        IBuildPropertyValue bpv = configProjectType.getBuildArtefactType();
        if (bpv == null) {
            return null;
        }
        return bpv.getId();
    }

    public static String getPlatformName(IConfiguration config) {
        IProject project = (IProject)config.getOwner();
        String name = "";
        TprojectHandler handler = new TprojectHandler(project);
        TizenProjectDescription desc = handler.unmarshal();
        if (desc != null) {
            name = desc.getPlatformName();
        }
        return name;
    }

    public static IConfiguration getDefaultConfiguration(IProject project) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            return null;
        }
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        return defaultConfig;
    }

    public static List<String> getToolchainList(String platformId, String buildArtefectType) throws SBIException {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        List<String> toolchainList = CommonConfigurationManager.getToolchainList(platformId);
        if (toolchainList == null) {
            return null;
        }
        ArrayList<String> availableToolchain = new ArrayList<String>();
        for (String toolchain : toolchainList) {
            String artefectType = sbi.getToolchainPropertyValue(toolchain, "PROJECT_TYPE");
            if (artefectType == null || !artefectType.equals(buildArtefectType)) continue;
            availableToolchain.add(toolchain);
        }
        return availableToolchain;
    }

    public static List<String> getToolchainList(String platformId) throws SBIException {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        List<String> rootstrapList = sbi.getRootstrapList();
        String selectedRootstrap = "";
        for (String rootstrap : rootstrapList) {
            if (!rootstrap.equals(platformId)) continue;
            selectedRootstrap = rootstrap;
        }
        if (selectedRootstrap.isEmpty()) {
            return null;
        }
        String[] candidateArchs = null;
        String arch = sbi.getArchitectureFromRootstrapID(selectedRootstrap);
        String toolchainType = sbi.getSupportToolchainTypeFromRootstrapID(selectedRootstrap);
        if (CommonConfigurationManager.isX86Arch(arch)) {
            candidateArchs = ARCHGROUP_X86;
        } else if (CommonConfigurationManager.isArmArch(arch)) {
            candidateArchs = ARCHGROUP_ARM;
        } else {
            return null;
        }
        ArrayList<String> availableToolchain = new ArrayList<String>();
        List<String> toolchainList = sbi.getToolchainList();
        for (String toolchain : toolchainList) {
            String toolchainArch = sbi.getArchitectureFromToolchainID(toolchain);
            String type = sbi.getToolchainTypeFromToolchainID(toolchain);
            if (toolchainArch == null || type == null || !CommonConfigurationManager.containValue(candidateArchs, toolchainArch) || !type.equals(toolchainType)) continue;
            availableToolchain.add(toolchain);
        }
        return availableToolchain;
    }

    public static String getLatestRootstrapId(String toolchainName) {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        List<String> rootstrapList = null;
        ArrayList<String> availableRootstrap = new ArrayList<String>();
        try {
            rootstrapList = sbi.getRootstrapList();
            for (String rootStrap : rootstrapList) {
                String arch = sbi.getArchitectureFromToolchainID(toolchainName);
                String toolchainType = sbi.getToolchainTypeFromToolchainID(toolchainName);
                if (!sbi.doesRootstrapSupportToolchainType(rootStrap, toolchainType) || !CommonConfigurationManager.containValue(new String[]{arch}, sbi.getArchitectureFromRootstrapID(rootStrap))) continue;
                availableRootstrap.add(rootStrap);
            }
        }
        catch (SBIException e) {
            logger.error("Failed to get rootstrapID list", (Throwable)e);
            return "";
        }
        if (availableRootstrap.isEmpty()) {
            return "";
        }
        Collections.sort(availableRootstrap);
        return (String)availableRootstrap.get(availableRootstrap.size() - 1);
    }

    public static boolean equalsConfig(IProject srcProj, IProject dstProj) {
        IConfiguration srcConf = CommonConfigurationManager.getDefaultConfiguration(srcProj);
        IConfiguration dstConf = CommonConfigurationManager.getDefaultConfiguration(dstProj);
        if (srcConf == null || dstConf == null) {
            return true;
        }
        return srcConf.getName().equals(dstConf.getName());
    }

    public static boolean equalsArch(IProject srcProj, IProject dstProj) {
        IConfiguration srcConf = CommonConfigurationManager.getDefaultConfiguration(srcProj);
        IConfiguration dstConf = CommonConfigurationManager.getDefaultConfiguration(dstProj);
        if (srcConf == null || dstConf == null) {
            return true;
        }
        return CommonConfigurationManager.equalsArch(srcConf, dstConf);
    }

    public static boolean equalsArch(IConfiguration srcConf, IConfiguration dstConf) {
        String srcArch = CommonConfigurationManager.getArchitectureFromConfiguration(srcConf);
        String dstArch = CommonConfigurationManager.getArchitectureFromConfiguration(dstConf);
        if (srcArch == null || dstArch == null) {
            return false;
        }
        return srcArch.equals(dstArch);
    }

    public static boolean equalsArch(IProject srcProj, IProject dstProj, String configName) {
        IConfiguration srcConf = CommonConfigurationManager.getConfigurationByName(srcProj, configName);
        IConfiguration dstConf = CommonConfigurationManager.getConfigurationByName(dstProj, configName);
        return CommonConfigurationManager.equalsArch(srcConf, dstConf);
    }

    public static IConfiguration getConfigurationByName(IProject project, String configName) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            return null;
        }
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        IConfiguration[] iConfigurationArray = defaultConfig.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (config.getName().equals(configName)) {
                return config;
            }
            ++n2;
        }
        return null;
    }

    public static IConfiguration getConfigurationById(IProject project, String confId) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        IConfiguration[] iConfigurationArray = defaultConfig.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            String id = config.getBaseId();
            if (id.equals(confId)) {
                return config;
            }
            ++n2;
        }
        return null;
    }

    public static String getConfigurationNameById(IProject project, String confId) {
        IConfiguration config = CommonConfigurationManager.getConfigurationById(project, confId);
        if (config != null) {
            return config.getName();
        }
        return "";
    }

    public static void setRebuildStateToTool(IConfiguration config, String toolId, boolean enable) {
        ITool compilerTool = config.getToolsBySuperClassId(toolId)[0];
        compilerTool.setRebuildState(enable);
    }

    public static String verifyTarget(IConfiguration config, String target) {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String tc = sbi.getToolchainIDFromTargetID(target);
        String rs = sbi.getRootstrapIDFromTargetID(target);
        try {
            if (SBIModel.checkToolchainById(tc) && SBIModel.checkRootstrapById(rs)) {
                if (!sbi.checkTargetID(target)) {
                    sbi.writeTargetCfgFile(target);
                }
            } else {
                target = CommonConfigurationManager.getDefaultBuildTargetName(config);
                if (!sbi.checkTargetID(target)) {
                    sbi.writeTargetCfgFile(target);
                }
                CommonConfigurationManager.setBuildTargetName(config, target);
            }
        }
        catch (SBIException e) {
            logger.error("Failed to verify build target", (Throwable)e);
            return target;
        }
        return target;
    }

    public static void verifyTarget(IConfiguration config) {
        String target = CommonConfigurationManager.getBuildTargetName(config);
        if (target == null) {
            return;
        }
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String tc = sbi.getToolchainIDFromTargetID(target);
        String rs = sbi.getRootstrapIDFromTargetID(target);
        try {
            if (SBIModel.checkToolchainById(tc) && SBIModel.checkRootstrapById(rs)) {
                if (!sbi.checkTargetID(target)) {
                    sbi.writeTargetCfgFile(target);
                }
                return;
            }
            String defaultTarget = CommonConfigurationManager.getDefaultBuildTargetName(config);
            if (!sbi.checkTargetID(defaultTarget)) {
                sbi.writeTargetCfgFile(defaultTarget);
            }
            CommonConfigurationManager.setBuildTargetName(config, defaultTarget);
        }
        catch (SBIException e) {
            logger.error("Failed to verify build target", (Throwable)e);
        }
    }

    public static void setToolCommand(IConfiguration config) {
        String c_compiler_id = SBI_BASE_C_COMPILER_TOOL_ID;
        String cpp_compiler_id = SBI_BASE_CPP_COMPILER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        String assembler_id = SBI_ASSEMBLER_TOOL_ID;
        String archiver_id = SBI_ARCHIVER_TOOL_ID;
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String target = CommonConfigurationManager.getBuildTargetName(config);
        if (target == null) {
            return;
        }
        try {
            String archiverPath;
            String assemblerPath;
            String cppCompilerPath;
            ITool compilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
            ITool cxxcompilerTool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
            ITool linkerTool = config.getToolsBySuperClassId(cpp_linker_id)[0];
            ITool assemblerTool = config.getToolsBySuperClassId(assembler_id)[0];
            ITool archiverTool = config.getToolsBySuperClassId(archiver_id)[0];
            String cCompilerPath = sbi.getCCompilerPath(target);
            if (cCompilerPath != null) {
                ManagedBuildManager.setToolCommand((IConfiguration)config, (ITool)compilerTool, (String)new Path(sbi.getCCompilerPath(target)).lastSegment());
            }
            if ((cppCompilerPath = sbi.getCXXCompilerPath(target)) != null) {
                ManagedBuildManager.setToolCommand((IConfiguration)config, (ITool)cxxcompilerTool, (String)new Path(sbi.getCXXCompilerPath(target)).lastSegment());
                ManagedBuildManager.setToolCommand((IConfiguration)config, (ITool)linkerTool, (String)new Path(sbi.getCXXCompilerPath(target)).lastSegment());
            }
            if ((assemblerPath = sbi.getAssemblerPath(target)) != null) {
                ManagedBuildManager.setToolCommand((IConfiguration)config, (ITool)assemblerTool, (String)new Path(sbi.getAssemblerPath(target)).lastSegment());
            }
            if ((archiverPath = sbi.getArchiverPath(target)) != null) {
                ManagedBuildManager.setToolCommand((IConfiguration)config, (ITool)archiverTool, (String)new Path(archiverPath).lastSegment());
            }
        }
        catch (SBIException e) {
            logger.error("Failed to set tool command", (Throwable)e);
            e.showErrorDialog();
        }
    }

    protected static boolean isCPPProject(IConfiguration config) {
        try {
            IProject project = (IProject)config.getOwner();
            if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                return true;
            }
        }
        catch (CoreException e) {
            logger.error("Failed to check cpp project", (Throwable)e);
        }
        return false;
    }

    public static String getArchitecture(IConfiguration config) {
        if (config == null) {
            return null;
        }
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String targetID = CommonConfigurationManager.getBuildTargetName(config);
        if (targetID == null) {
            return null;
        }
        try {
            return sbi.getRootstrapArchitecture(targetID);
        }
        catch (SBIException e) {
            logger.error("Failed to get rootstrap architecture", (Throwable)e);
            e.showErrorDialog();
            return ARCHGROUP_ARM[0];
        }
    }

    public static void setFrameworkCflags(IConfiguration config, ITool tool, List<String> optionList) {
        String tool_id = tool.getBaseId();
        String option_id = null;
        if (tool_id.contains(SBI_BASE_C_COMPILER_TOOL_ID)) {
            option_id = SBI_C_DEV_PACKAGE_OPTION_CFLAGS_ID;
        } else if (tool_id.contains(SBI_BASE_CPP_COMPILER_TOOL_ID)) {
            option_id = SBI_CPP_DEV_PACKAGE_OPTION_CFLAGS_ID;
        } else {
            return;
        }
        CommonConfigurationManager.setFrameworkFlags(config, tool_id, option_id, optionList);
    }

    public static void setFrameworkCflags(IConfiguration config, List<String> optionList) {
        CommonConfigurationManager.setFrameworkFlags(config, SBI_BASE_C_COMPILER_TOOL_ID, SBI_C_DEV_PACKAGE_OPTION_CFLAGS_ID, optionList);
    }

    public static List<String> getFrameworkCflags(IConfiguration config) {
        String[] flags = CommonConfigurationManager.getFrameworkFlags(config, SBI_BASE_C_COMPILER_TOOL_ID, SBI_C_DEV_PACKAGE_OPTION_CFLAGS_ID);
        ArrayList<String> cFlagList = new ArrayList<String>();
        Collections.addAll(cFlagList, flags);
        return cFlagList;
    }

    public static List<String> getFrameworkCPPflags(IConfiguration config) {
        String[] flags = CommonConfigurationManager.getFrameworkFlags(config, SBI_BASE_CPP_COMPILER_TOOL_ID, SBI_CPP_DEV_PACKAGE_OPTION_CFLAGS_ID);
        ArrayList<String> cppFlagList = new ArrayList<String>();
        Collections.addAll(cppFlagList, flags);
        return cppFlagList;
    }

    private static String[] getFrameworkFlags(IConfiguration config, String tool_id, String flag_id) {
        ITool c_compilerTool = config.getToolsBySuperClassId(tool_id)[0];
        IOption frameworkPathOptions = c_compilerTool.getOptionBySuperClassId(flag_id);
        try {
            return frameworkPathOptions.getStringListValue();
        }
        catch (BuildException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    public static void setFrameworkLflags(IConfiguration config, List<String> optionList) {
        CommonConfigurationManager.setFrameworkFlags(config, SBI_CPP_LINKER_TOOL_ID, SBI_CPP_DEV_PACKAGE_OPTION_LFALGS_ID, optionList);
    }

    public static void setFrameworkFlags(IConfiguration config, String tool_id, String option_id, List<String> optionList) {
        ITool cpp_linkerTool = config.getToolsBySuperClassId(tool_id)[0];
        IOption frameworkPathOptions = cpp_linkerTool.getOptionBySuperClassId(option_id);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cpp_linkerTool, (IOption)frameworkPathOptions, (String[])optionList.toArray(new String[0]));
    }

    public static void appendFrameworkLflags(IConfiguration config, List<String> flags) {
        List<String> lflags = CommonConfigurationManager.getFrameworkLflags(config);
        for (String flag : flags) {
            if (lflags.contains(flag)) continue;
            lflags.add(flag);
        }
        CommonConfigurationManager.setFrameworkLflags(config, lflags);
    }

    public static void appendFrameworkLflag(IConfiguration config, String flag) {
        List<String> lflags = CommonConfigurationManager.getFrameworkLflags(config);
        if (!lflags.contains(flag)) {
            lflags.add(flag);
        }
        CommonConfigurationManager.setFrameworkLflags(config, lflags);
    }

    public static List<String> getFrameworkLflags(IConfiguration config) {
        String[] flags = CommonConfigurationManager.getFrameworkFlags(config, SBI_CPP_LINKER_TOOL_ID, SBI_CPP_DEV_PACKAGE_OPTION_LFALGS_ID);
        ArrayList<String> lFlagList = new ArrayList<String>();
        Collections.addAll(lFlagList, flags);
        return lFlagList;
    }

    public static void appendFrameworkCflags(IConfiguration config, List<String> flags) {
        List<String> cflags = CommonConfigurationManager.getFrameworkCflags(config);
        for (String flag : flags) {
            if (cflags.contains(flag)) continue;
            cflags.add(flag);
        }
        CommonConfigurationManager.setFrameworkCflags(config, cflags);
    }

    public static void appendFrameworkCflag(IConfiguration config, String flag) {
        List<String> cflags = CommonConfigurationManager.getFrameworkCflags(config);
        if (!cflags.contains(flag)) {
            cflags.add(flag);
        }
        CommonConfigurationManager.setFrameworkCflags(config, cflags);
    }

    public static void appendFrameworkCPPflags(IConfiguration config, List<String> flags) {
        List<String> cppflags = CommonConfigurationManager.getFrameworkCPPflags(config);
        for (String flag : flags) {
            if (cppflags.contains(flag)) continue;
            cppflags.add(flag);
        }
        CommonConfigurationManager.setFrameworkCPPflags(config, cppflags);
    }

    public static void appendFrameworkCPPflag(IConfiguration config, String flag) {
        List<String> cppflags = CommonConfigurationManager.getFrameworkCPPflags(config);
        if (!cppflags.contains(flag)) {
            cppflags.add(flag);
        }
        CommonConfigurationManager.setFrameworkCPPflags(config, cppflags);
    }

    public static void setFrameworkCPPflags(IConfiguration config, List<String> optionList) {
        CommonConfigurationManager.setFrameworkFlags(config, SBI_BASE_CPP_COMPILER_TOOL_ID, SBI_CPP_DEV_PACKAGE_OPTION_CFLAGS_ID, optionList);
    }

    public static void setFrameworkLflags(IConfiguration config, ITool tool, List<String> optionList) {
        String tool_id = tool.getBaseId();
        String option_id = "";
        if (!tool_id.contains(SBI_BASE_CPP_COMPILER_TOOL_ID)) {
            return;
        }
        tool_id = SBI_CPP_LINKER_TOOL_ID;
        option_id = SBI_CPP_DEV_PACKAGE_OPTION_LFALGS_ID;
        CommonConfigurationManager.setFrameworkFlags(config, tool_id, option_id, optionList);
    }

    public static void removeFrameworkLflags(IConfiguration config, List<String> flags) {
        List<String> lflags = CommonConfigurationManager.getFrameworkLflags(config);
        lflags.removeAll(flags);
        CommonConfigurationManager.setFrameworkLflags(config, lflags);
    }

    public static void removeFrameworkLflag(IConfiguration config, String flag) {
        List<String> lflags = CommonConfigurationManager.getFrameworkLflags(config);
        lflags.remove(flag);
        CommonConfigurationManager.setFrameworkLflags(config, lflags);
    }

    public static void removeFrameworkCflags(IConfiguration config, List<String> flags) {
        List<String> cflags = CommonConfigurationManager.getFrameworkCflags(config);
        cflags.removeAll(flags);
        CommonConfigurationManager.setFrameworkCflags(config, cflags);
    }

    public static void removeFrameworkCflag(IConfiguration config, String flag) {
        List<String> cflags = CommonConfigurationManager.getFrameworkCflags(config);
        cflags.remove(flag);
        CommonConfigurationManager.setFrameworkCflags(config, cflags);
    }

    public static void removeFrameworkCPPflags(IConfiguration config, List<String> flags) {
        List<String> cppflags = CommonConfigurationManager.getFrameworkCPPflags(config);
        cppflags.removeAll(flags);
        CommonConfigurationManager.setFrameworkCPPflags(config, cppflags);
    }

    public static void removeFrameworkCPPflag(IConfiguration config, String flag) {
        List<String> cppflags = CommonConfigurationManager.getFrameworkCPPflags(config);
        cppflags.remove(flag);
        CommonConfigurationManager.setFrameworkCPPflags(config, cppflags);
    }

    public static List<String> makeLibraryOptions(Collection<IProject> referencedProjects) {
        if (referencedProjects == null || referencedProjects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> optionList = new ArrayList<String>();
        for (IProject referencedProject : referencedProjects) {
            optionList.add(CommonConfigurationManager.makeLibraryOption(referencedProject));
        }
        return optionList;
    }

    public static String makeLibraryOption(IProject referencedProject) {
        if (referencedProject == null) {
            return "";
        }
        StringBuffer option = new StringBuffer();
        option.append("-l");
        option.append("\"");
        option.append(ProjectUtil.getArtefactName(referencedProject));
        option.append("\"");
        return option.toString();
    }

    public static List<String> makeLinkOptions(Collection<IProject> referencedProjects) {
        if (referencedProjects == null || referencedProjects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> optionList = new ArrayList<String>();
        for (IProject referencedProject : referencedProjects) {
            optionList.add(CommonConfigurationManager.makeLinkOption(referencedProject));
        }
        return optionList;
    }

    public static String makeLinkOption(IProject referencedProject) {
        if (referencedProject == null) {
            return "";
        }
        IConfiguration defaultConfig = ProjectUtil.getDefaultConfiguration(referencedProject);
        StringBuffer option = new StringBuffer();
        option.append("-L");
        option.append("\"");
        option.append(referencedProject.getLocation().append(defaultConfig.getName()));
        option.append("\"");
        return option.toString();
    }

    public static List<String> makeIncludeOptions(Collection<IProject> referencedProjects) {
        if (referencedProjects == null || referencedProjects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> optionList = new ArrayList<String>();
        for (IProject referencedProject : referencedProjects) {
            optionList.add(CommonConfigurationManager.makeIncludeOption(referencedProject));
        }
        return optionList;
    }

    public static String makeIncludeOption(IProject referencedProject) {
        if (referencedProject == null) {
            return "";
        }
        StringBuffer option = new StringBuffer();
        option.append("-I");
        option.append("\"");
        option.append(referencedProject.getLocation().append("inc"));
        option.append("\"");
        return option.toString();
    }

    public static void addReferencedProjectOptions(IProject project, Set<IProject> referencedProjectSet) {
        IConfiguration config = ProjectUtil.getDefaultConfiguration(project);
        CommonConfigurationManager.appendFrameworkLflags(config, CommonConfigurationManager.makeLinkOptions(referencedProjectSet));
        CommonConfigurationManager.appendFrameworkLflags(config, CommonConfigurationManager.makeLibraryOptions(referencedProjectSet));
        CommonConfigurationManager.appendFrameworkCflags(config, CommonConfigurationManager.makeIncludeOptions(referencedProjectSet));
        CommonConfigurationManager.appendFrameworkCPPflags(config, CommonConfigurationManager.makeIncludeOptions(referencedProjectSet));
    }

    public static void removeReferencedProjectOptions(IProject project, Set<IProject> referencedProjectSet) {
        IConfiguration config = ProjectUtil.getDefaultConfiguration(project);
        CommonConfigurationManager.removeFrameworkLflags(config, CommonConfigurationManager.makeLinkOptions(referencedProjectSet));
        CommonConfigurationManager.removeFrameworkLflags(config, CommonConfigurationManager.makeLibraryOptions(referencedProjectSet));
        CommonConfigurationManager.removeFrameworkCflags(config, CommonConfigurationManager.makeIncludeOptions(referencedProjectSet));
        CommonConfigurationManager.removeFrameworkCPPflags(config, CommonConfigurationManager.makeIncludeOptions(referencedProjectSet));
    }

    public static IProject[] getRefLibProjects(IProject project) {
        TizenProjectDescription desc = org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)project);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> refProjects = new ArrayList<IProject>();
        if (desc == null) {
            return refProjects.toArray(new IProject[refProjects.size()]);
        }
        Map map = desc.getReferencedLibraryProjectMap();
        if (map == null) {
            return refProjects.toArray(new IProject[refProjects.size()]);
        }
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject pjt = iProjectArray[n2];
            if (map.containsKey(pjt.getName())) {
                refProjects.add(pjt);
            }
            ++n2;
        }
        return refProjects.toArray(new IProject[refProjects.size()]);
    }

    public static void appendLibraryToLinker(IConfiguration config, String libraryName) {
        String linkerOption;
        String linkerId;
        if (config == null || libraryName == null) {
            return;
        }
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        if (CommonConfigurationManager.isCPPProject(config)) {
            linkerId = cpp_linker_id;
            linkerOption = GNU_CPP_LIBRARIES_OPTION_ID;
        } else {
            linkerId = c_linker_id;
            linkerOption = GNU_C_LIBRARIES_OPTION_ID;
        }
        if (config.getToolsBySuperClassId(linkerId).length == 0) {
            return;
        }
        ITool linkerTool = config.getToolsBySuperClassId(linkerId)[0];
        IOption librariesOption = linkerTool.getOptionBySuperClassId(linkerOption);
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            String[] libraries;
            String[] stringArray = libraries = librariesOption.getLibraries();
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                String lib = stringArray[n2];
                tmpList.add(lib);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get library list", (Throwable)e);
            e.printStackTrace();
        }
        if (!tmpList.contains(libraryName)) {
            tmpList.add(libraryName);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)linkerTool, (IOption)librariesOption, (String[])tmpList.toArray(new String[0]));
        }
    }

    public static void removeLibraryToLinker(IConfiguration config, String libraryName) {
        String linkerOption;
        String linkerId;
        if (config == null || libraryName == null) {
            return;
        }
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        if (CommonConfigurationManager.isCPPProject(config)) {
            linkerId = cpp_linker_id;
            linkerOption = GNU_CPP_LIBRARIES_OPTION_ID;
        } else {
            linkerId = c_linker_id;
            linkerOption = GNU_C_LIBRARIES_OPTION_ID;
        }
        if (config.getToolsBySuperClassId(linkerId).length == 0) {
            return;
        }
        ITool linkerTool = config.getToolsBySuperClassId(linkerId)[0];
        IOption librariesOption = linkerTool.getOptionBySuperClassId(linkerOption);
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            String[] libraries;
            String[] stringArray = libraries = librariesOption.getLibraries();
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                String lib = stringArray[n2];
                if (!lib.equals(libraryName)) {
                    tmpList.add(lib);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get library list", (Throwable)e);
        }
        if (!tmpList.contains(libraryName)) {
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)linkerTool, (IOption)librariesOption, (String[])tmpList.toArray(new String[0]));
        }
    }

    public static void removeLinkPathsToLinker(IConfiguration config, String path) {
        String pathOption;
        String linkerId;
        if (config == null || path == null) {
            return;
        }
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        if (CommonConfigurationManager.isCPPProject(config)) {
            linkerId = cpp_linker_id;
            pathOption = GNU_CPP_LINKPATH_OPTION_ID;
        } else {
            linkerId = c_linker_id;
            pathOption = GNU_C_LINKPATH_OPTION_ID;
        }
        ITool linkerTool = config.getToolsBySuperClassId(linkerId)[0];
        IOption linkPathOption = linkerTool.getOptionBySuperClassId(pathOption);
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            String[] flags;
            String[] stringArray = flags = linkPathOption.getBasicStringListValue();
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                if (!obj.equals(path)) {
                    tmpList.add(obj);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get link path", (Throwable)e);
        }
        if (!tmpList.contains(path)) {
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)linkerTool, (IOption)linkPathOption, (String[])tmpList.toArray(new String[0]));
        }
    }

    public static void appendOtherObjectToLinker(IConfiguration config, String objPath) {
        String objOption;
        String linkerId;
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        if (CommonConfigurationManager.isCPPProject(config)) {
            linkerId = cpp_linker_id;
            objOption = GNU_CPP_USEROBJS_OPTION_ID;
        } else {
            linkerId = c_linker_id;
            objOption = GNU_C_USEROBJS_OPTION_ID;
        }
        ITool linkerTool = config.getToolsBySuperClassId(linkerId)[0];
        IOption userObjOption = linkerTool.getOptionBySuperClassId(objOption);
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            String[] userObjFlags;
            String[] stringArray = userObjFlags = userObjOption.getBasicStringListValue();
            int n = userObjFlags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                tmpList.add(obj);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get user object list", (Throwable)e);
        }
        if (!tmpList.contains(objPath)) {
            tmpList.add(objPath);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)linkerTool, (IOption)userObjOption, (String[])tmpList.toArray(new String[0]));
        }
    }

    public static void appendLinkPathsToLinker(IConfiguration config, String path) {
        String pathOption;
        String linkerId;
        if (config == null || path == null) {
            return;
        }
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        if (CommonConfigurationManager.isCPPProject(config)) {
            linkerId = cpp_linker_id;
            pathOption = GNU_CPP_LINKPATH_OPTION_ID;
        } else {
            linkerId = c_linker_id;
            pathOption = GNU_C_LINKPATH_OPTION_ID;
        }
        ITool linkerTool = config.getToolsBySuperClassId(linkerId)[0];
        IOption linkPathOption = linkerTool.getOptionBySuperClassId(pathOption);
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            String[] flags;
            String[] stringArray = flags = linkPathOption.getBasicStringListValue();
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                tmpList.add(obj);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get link path", (Throwable)e);
        }
        if (!tmpList.contains(path)) {
            tmpList.add(path);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)linkerTool, (IOption)linkPathOption, (String[])tmpList.toArray(new String[0]));
        }
    }

    public static void replaceLinkPathsToLinker(IConfiguration config, String target, String replacement) {
        String pathOption;
        String linkerId;
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        if (CommonConfigurationManager.isCPPProject(config)) {
            linkerId = cpp_linker_id;
            pathOption = GNU_CPP_LINKPATH_OPTION_ID;
        } else {
            linkerId = c_linker_id;
            pathOption = GNU_C_LINKPATH_OPTION_ID;
        }
        if (config.getToolsBySuperClassId(linkerId).length == 0) {
            return;
        }
        ITool linkerTool = config.getToolsBySuperClassId(linkerId)[0];
        IOption linkPathOption = linkerTool.getOptionBySuperClassId(pathOption);
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            String[] flags;
            String[] stringArray = flags = linkPathOption.getBasicStringListValue();
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                if (!obj.equals(target)) {
                    tmpList.add(obj);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get link path", (Throwable)e);
        }
        if (!tmpList.contains(replacement)) {
            tmpList.add(replacement);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)linkerTool, (IOption)linkPathOption, (String[])tmpList.toArray(new String[0]));
        }
    }

    public static void appendLinkOtherFlagsToLinker(IConfiguration config, String flag) {
        String flagOption;
        String linkerId;
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        if (CommonConfigurationManager.isCPPProject(config)) {
            linkerId = cpp_linker_id;
            flagOption = GNU_CPP_LINKOTHER_OPTION_ID;
        } else {
            linkerId = c_linker_id;
            flagOption = GNU_C_LINKOTHER_OPTION_ID;
        }
        ITool linkerTool = config.getToolsBySuperClassId(linkerId)[0];
        IOption otherFlagOption = linkerTool.getOptionBySuperClassId(flagOption);
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            String[] flags;
            String[] stringArray = flags = otherFlagOption.getBasicStringListValue();
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                tmpList.add(obj);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get link other flags", (Throwable)e);
        }
        if (!tmpList.contains(flag)) {
            tmpList.add(flag);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)linkerTool, (IOption)otherFlagOption, (String[])tmpList.toArray(new String[0]));
        }
    }

    public static void removeOtherObjectFromLinker(IConfiguration config, String objPath) {
        String objOption;
        String linkerId;
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        if (CommonConfigurationManager.isCPPProject(config)) {
            linkerId = cpp_linker_id;
            objOption = GNU_CPP_USEROBJS_OPTION_ID;
        } else {
            linkerId = c_linker_id;
            objOption = GNU_C_USEROBJS_OPTION_ID;
        }
        ITool linkerTool = config.getToolsBySuperClassId(linkerId)[0];
        IOption userObjOption = linkerTool.getOptionBySuperClassId(objOption);
        ArrayList<String> tmpList = new ArrayList<String>();
        try {
            String[] userObjFlags;
            String[] stringArray = userObjFlags = userObjOption.getBasicStringListValue();
            int n = userObjFlags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                tmpList.add(obj);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get user object list", (Throwable)e);
        }
        if (tmpList.contains(objPath)) {
            tmpList.remove(objPath);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)linkerTool, (IOption)userObjOption, (String[])tmpList.toArray(new String[0]));
        }
    }

    public static void appendIncludePathToCCompiler(IConfiguration config, String path) {
        String c_compiler_id = SBI_BASE_C_COMPILER_TOOL_ID;
        ITool[] cCompilerTools = config.getToolsBySuperClassId(c_compiler_id);
        if (cCompilerTools.length == 0) {
            return;
        }
        ITool cCompilerTool = cCompilerTools[0];
        IOption cIncludePathOption = cCompilerTool.getOptionBySuperClassId(GNU_C_INCLUDE_PATH_OPTION_ID);
        if (cIncludePathOption == null) {
            return;
        }
        ArrayList<String> cIncludePathList = new ArrayList<String>();
        try {
            String[] flags;
            String[] stringArray = flags = cIncludePathOption.getBasicStringListValue();
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                cIncludePathList.add(obj);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get c include path list", (Throwable)e);
        }
        if (!cIncludePathList.contains(path)) {
            cIncludePathList.add(path);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cCompilerTool, (IOption)cIncludePathOption, (String[])cIncludePathList.toArray(new String[0]));
        }
    }

    public static void appendIncludePathToCppCompiler(IConfiguration config, String path) {
        String cpp_compiler_id = SBI_BASE_CPP_COMPILER_TOOL_ID;
        ITool[] cppCompilerTools = config.getToolsBySuperClassId(cpp_compiler_id);
        if (cppCompilerTools.length == 0) {
            return;
        }
        ITool cppCompilerTool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        IOption cppIncludePathOption = cppCompilerTool.getOptionBySuperClassId(GNU_CPP_INCLUDE_PATH_OPTION_ID);
        if (cppIncludePathOption == null) {
            return;
        }
        ArrayList<String> cppIncludePathList = new ArrayList<String>();
        try {
            String[] flags;
            String[] stringArray = flags = cppIncludePathOption.getBasicStringListValue();
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                cppIncludePathList.add(obj);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get cpp include path list", (Throwable)e);
        }
        if (!cppIncludePathList.contains(path)) {
            cppIncludePathList.add(path);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cppCompilerTool, (IOption)cppIncludePathOption, (String[])cppIncludePathList.toArray(new String[0]));
        }
    }

    public static void appendIncludePathToCompiler(IConfiguration config, String path) {
        CommonConfigurationManager.appendIncludePathToCCompiler(config, path);
        CommonConfigurationManager.appendIncludePathToCppCompiler(config, path);
    }

    public static List<String> getIncludePathOptions(IConfiguration config) {
        String c_compiler_id = SBI_BASE_C_COMPILER_TOOL_ID;
        String cpp_compiler_id = SBI_BASE_CPP_COMPILER_TOOL_ID;
        ArrayList<String> result = new ArrayList<String>();
        try {
            String path;
            ITool tool = config.getToolsBySuperClassId(c_compiler_id)[0];
            IOption option = tool.getOptionBySuperClassId(GNU_C_INCLUDE_PATH_OPTION_ID);
            String[] stringArray = option.getIncludePaths();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                result.add(path);
                ++n2;
            }
            tool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
            option = tool.getOptionBySuperClassId(GNU_CPP_INCLUDE_PATH_OPTION_ID);
            stringArray = option.getIncludePaths();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                if (!result.contains(path)) {
                    result.add(path);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get include path list", (Throwable)e);
        }
        return result;
    }

    public static void appendPreprocessorSymbolToCCompiler(IConfiguration config, String symbol) {
        String c_compiler_id = SBI_BASE_C_COMPILER_TOOL_ID;
        if (config.getToolsBySuperClassId(c_compiler_id).length == 0) {
            return;
        }
        ITool cCompilerTool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption cSymbolOption = cCompilerTool.getOptionBySuperClassId(GNU_C_DEF_SYMBOLS_OPTION_ID);
        ArrayList<String> cSymbolList = new ArrayList<String>();
        try {
            String[] flags;
            String[] stringArray = flags = cSymbolOption.getBasicStringListValue();
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                cSymbolList.add(obj);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get c symbol list", (Throwable)e);
        }
        if (!cSymbolList.contains(symbol)) {
            cSymbolList.add(symbol);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cCompilerTool, (IOption)cSymbolOption, (String[])cSymbolList.toArray(new String[0]));
        }
    }

    public static void appendPreprocessorSymbolToCppCompiler(IConfiguration config, String symbol) {
        String cpp_compiler_id = SBI_BASE_CPP_COMPILER_TOOL_ID;
        if (config.getToolsBySuperClassId(cpp_compiler_id).length == 0) {
            return;
        }
        ITool cppCompilerTool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        IOption cppSymbolOption = cppCompilerTool.getOptionBySuperClassId(GNU_CPP_DEF_SYMBOLS_OPTION_ID);
        ArrayList<String> cppSymbolList = new ArrayList<String>();
        try {
            String[] flags;
            String[] stringArray = flags = cppSymbolOption.getBasicStringListValue();
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String obj = stringArray[n2];
                cppSymbolList.add(obj);
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get cpp symbol list", (Throwable)e);
        }
        if (!cppSymbolList.contains(symbol)) {
            cppSymbolList.add(symbol);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)cppCompilerTool, (IOption)cppSymbolOption, (String[])cppSymbolList.toArray(new String[0]));
        }
    }

    public static void appendPreprocessorSymbolToCompiler(IConfiguration config, String symbol) {
        CommonConfigurationManager.appendPreprocessorSymbolToCCompiler(config, symbol);
        CommonConfigurationManager.appendPreprocessorSymbolToCppCompiler(config, symbol);
    }

    public static void setIncludePathOptions(IConfiguration config, List<String> srcList) {
        String c_compiler_id = SBI_BASE_C_COMPILER_TOOL_ID;
        String cpp_compiler_id = SBI_BASE_CPP_COMPILER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_C_INCLUDE_PATH_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])srcList.toArray(new String[0]));
        tool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        option = tool.getOptionBySuperClassId(GNU_CPP_INCLUDE_PATH_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])srcList.toArray(new String[0]));
    }

    public static List<String> getLibrarySearchPathOptions(IConfiguration config) {
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        ArrayList<String> result = new ArrayList<String>();
        try {
            String path;
            ITool tool = config.getToolsBySuperClassId(c_linker_id)[0];
            IOption option = tool.getOptionBySuperClassId(GNU_C_LINKPATH_OPTION_ID);
            String[] stringArray = option.getBasicStringListValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                result.add(path);
                ++n2;
            }
            tool = config.getToolsBySuperClassId(cpp_linker_id)[0];
            option = tool.getOptionBySuperClassId(GNU_CPP_LINKPATH_OPTION_ID);
            stringArray = option.getBasicStringListValue();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                if (!result.contains(path)) {
                    result.add(path);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get link path list", (Throwable)e);
        }
        return result;
    }

    public static void setLibrarySearchPathOptions(IConfiguration config, List<String> srcList) {
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(c_linker_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_C_LINKPATH_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])srcList.toArray(new String[0]));
        tool = config.getToolsBySuperClassId(cpp_linker_id)[0];
        option = tool.getOptionBySuperClassId(GNU_CPP_LINKPATH_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])srcList.toArray(new String[0]));
    }

    public static List<String> getLibraryLinkOptions(IConfiguration config) {
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        ArrayList<String> result = new ArrayList<String>();
        try {
            String path;
            ITool tool = config.getToolsBySuperClassId(c_linker_id)[0];
            IOption option = tool.getOptionBySuperClassId(GNU_C_LIBRARIES_OPTION_ID);
            String[] stringArray = option.getLibraries();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                result.add(path);
                ++n2;
            }
            tool = config.getToolsBySuperClassId(cpp_linker_id)[0];
            option = tool.getOptionBySuperClassId(GNU_CPP_LIBRARIES_OPTION_ID);
            stringArray = option.getLibraries();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                if (!result.contains(path)) {
                    result.add(path);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get link library list", (Throwable)e);
        }
        return result;
    }

    public static void setLibraryLinkOptions(IConfiguration config, List<String> srcList) {
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(c_linker_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_C_LIBRARIES_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])srcList.toArray(new String[0]));
        tool = config.getToolsBySuperClassId(cpp_linker_id)[0];
        option = tool.getOptionBySuperClassId(GNU_CPP_LIBRARIES_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])srcList.toArray(new String[0]));
    }

    public static List<String> getObjectLinkOptions(IConfiguration config) {
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        ArrayList<String> result = new ArrayList<String>();
        try {
            String path;
            ITool tool = config.getToolsBySuperClassId(c_linker_id)[0];
            IOption option = tool.getOptionBySuperClassId(GNU_C_USEROBJS_OPTION_ID);
            String[] stringArray = option.getBasicStringListValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                result.add(path);
                ++n2;
            }
            tool = config.getToolsBySuperClassId(cpp_linker_id)[0];
            option = tool.getOptionBySuperClassId(GNU_CPP_USEROBJS_OPTION_ID);
            stringArray = option.getBasicStringListValue();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                if (!result.contains(path)) {
                    result.add(path);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get user object list", (Throwable)e);
        }
        return result;
    }

    public static void setObjectLinkOptions(IConfiguration config, List<String> srcList) {
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(c_linker_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_C_USEROBJS_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])srcList.toArray(new String[0]));
        tool = config.getToolsBySuperClassId(cpp_linker_id)[0];
        option = tool.getOptionBySuperClassId(GNU_CPP_USEROBJS_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])srcList.toArray(new String[0]));
    }

    public static List<String> getOtherLinkOptions(IConfiguration config) {
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        ArrayList<String> result = new ArrayList<String>();
        try {
            String path;
            ITool tool = config.getToolsBySuperClassId(c_linker_id)[0];
            IOption option = tool.getOptionBySuperClassId(GNU_C_LINKOTHER_OPTION_ID);
            String[] stringArray = option.getBasicStringListValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                result.add(path);
                ++n2;
            }
            tool = config.getToolsBySuperClassId(cpp_linker_id)[0];
            option = tool.getOptionBySuperClassId(GNU_CPP_LINKOTHER_OPTION_ID);
            stringArray = option.getBasicStringListValue();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                if (!result.contains(path)) {
                    result.add(path);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get link path list", (Throwable)e);
        }
        return result;
    }

    public static void setOtherLinkOptions(IConfiguration config, List<String> srcList) {
        String c_linker_id = SBI_C_LINKER_TOOL_ID;
        String cpp_linker_id = SBI_CPP_LINKER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(c_linker_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_C_LINKOTHER_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])srcList.toArray(new String[0]));
        tool = config.getToolsBySuperClassId(cpp_linker_id)[0];
        option = tool.getOptionBySuperClassId(GNU_CPP_LINKOTHER_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])srcList.toArray(new String[0]));
    }

    public static void setCLinkerMiscOptions(IConfiguration config, String op) {
        String c_compiler_id = SBI_C_LINKER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_C_LINK_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String)op);
    }

    public static void setCXXLinkerMiscOptions(IConfiguration config, String op) {
        String cpp_compiler_id = SBI_CPP_LINKER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_CPP_LINK_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String)op);
    }

    public static void setCCompilerOtherOptions(IConfiguration config, String op) {
        String c_compiler_id = SBI_BASE_C_COMPILER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_C_OTHER_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String)op);
    }

    public static void setCXXCompilerOtherOptions(IConfiguration config, String op) {
        String cpp_compiler_id = SBI_BASE_CPP_COMPILER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_CPP_OTHER_ID);
        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String)op);
    }

    public static String getCLinkerOptions(IConfiguration config) {
        String c_compiler_id = SBI_C_LINKER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_C_LINK_OPTION_ID);
        String result = "";
        try {
            result = option.getStringValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get c link option", (Throwable)e);
        }
        return result;
    }

    public static String getCXXLinkerOptions(IConfiguration config) {
        String cpp_compiler_id = SBI_CPP_LINKER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_CPP_LINK_OPTION_ID);
        String result = "";
        try {
            result = option.getStringValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get cpp link option", (Throwable)e);
        }
        return result;
    }

    public static String getCComplierOtherOptions(IConfiguration config) {
        String c_compiler_id = SBI_BASE_C_COMPILER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(c_compiler_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_C_OTHER_ID);
        String result = "";
        try {
            result = option.getStringValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get c other option", (Throwable)e);
        }
        return result;
    }

    public static String getCXXComplierOtherOptions(IConfiguration config) {
        String cpp_compiler_id = SBI_BASE_CPP_COMPILER_TOOL_ID;
        ITool tool = config.getToolsBySuperClassId(cpp_compiler_id)[0];
        IOption option = tool.getOptionBySuperClassId(GNU_CPP_OTHER_ID);
        String result = "";
        try {
            result = option.getStringValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get cpp other option", (Throwable)e);
        }
        return result;
    }

    public static void setProjectVersion(IProject project, String version, boolean save) {
        try {
            ICProjectDescription desc = CoreModel.getDefault().getProjectDescription(project);
            if (desc == null) {
                return;
            }
            ICStorageElement storageElm = desc.getStorage(SLP_PROJECT_INFO_STORAGE_MODULE_ID, true);
            storageElm.setAttribute("version", version);
            CoreModel.getDefault().setProjectDescription(project, desc, true, (IProgressMonitor)new NullProgressMonitor());
            if (save) {
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            }
        }
        catch (CoreException e) {
            logger.error("Failed to set project description", (Throwable)e);
        }
    }

    public static String getProjectVersion(IProject project) {
        try {
            ICProjectDescription desc = CoreModel.getDefault().getProjectDescription(project);
            if (desc != null) {
                ICStorageElement storageElm = desc.getStorage(SLP_PROJECT_INFO_STORAGE_MODULE_ID, true);
                String version = storageElm.getAttribute("version");
                return version;
            }
            logger.error("Failed to get ProjectDescription: " + project.getName());
        }
        catch (CoreException e) {
            logger.error("Failed to get project storage", (Throwable)e);
        }
        return null;
    }

    public static boolean isEmulatorConfiguration(IConfiguration config) {
        return config.getName().contains(SBI_EMULATOR_CONFIG_SUFFIX);
    }

    public static boolean isDeviceConfiguration(IConfiguration config) {
        return config.getName().contains(SBI_DEVICE_CONFIG_SUFFIX);
    }

    public static boolean isReleaseMode(IConfiguration config) {
        return config.getName().equals(SBI_RELEASE_CONFIG_SUFFIX);
    }

    public static boolean isDebugMode(IConfiguration config) {
        return config.getName().equals(SBI_DEBUG_CONFIG_SUFFIX);
    }

    public static boolean containValue(String[] strs, String value) {
        if (strs == null || value == null) {
            return false;
        }
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str == null) {
                return false;
            }
            if (str.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean checkArch(String arch, String[] archGroup) {
        String[] stringArray = archGroup;
        int n = archGroup.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a.equals(arch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isEmulatorArch(String arch) {
        return CommonConfigurationManager.checkArch(arch, ARCHGROUP_X86);
    }

    public static boolean isX86Arch(String arch) {
        return CommonConfigurationManager.checkArch(arch, ARCHGROUP_X86);
    }

    public static boolean isX86_64Arch(String arch) {
        return CommonConfigurationManager.checkArch(arch, ARCHGROUP_X86_64);
    }

    public static boolean isDeviceArch(String arch) {
        return CommonConfigurationManager.checkArch(arch, ARCHGROUP_ARM);
    }

    public static boolean isArmArch(String arch) {
        return CommonConfigurationManager.checkArch(arch, ARCHGROUP_ARM);
    }

    public static boolean isArm64Arch(String arch) {
        return CommonConfigurationManager.checkArch(arch, ARCHGROUP_ARM_64);
    }

    public static boolean isSameArchType(String arch1, String arch2) {
        if (CommonConfigurationManager.isX86Arch(arch1)) {
            return CommonConfigurationManager.isX86Arch(arch2);
        }
        if (CommonConfigurationManager.isX86_64Arch(arch1)) {
            return CommonConfigurationManager.isX86_64Arch(arch2);
        }
        if (CommonConfigurationManager.isArmArch(arch1)) {
            return CommonConfigurationManager.isArmArch(arch2);
        }
        if (CommonConfigurationManager.isArm64Arch(arch1)) {
            return CommonConfigurationManager.isArm64Arch(arch2);
        }
        return false;
    }

    public static String getArchitectureFromConfiguration(IConfiguration config) {
        if (config == null) {
            return "";
        }
        String architecture = null;
        try {
            String targetID = CommonConfigurationManager.getBuildTargetName(config);
            if (targetID == null) {
                targetID = CommonConfigurationManager.getDefaultBuildTargetName(config);
            }
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            String rootID = sbi.getRootstrapIDFromTargetID(targetID);
            architecture = sbi.getArchitectureFromRootstrapID(rootID);
        }
        catch (SBIException e) {
            logger.error("Failed to get default build target", (Throwable)e);
        }
        return architecture;
    }

    public static void setLinkerRebuildState(IConfiguration config, Boolean isReBuild) {
        ITool tool = config.getToolsBySuperClassId(SBI_CPP_LINKER_TOOL_ID)[0];
        tool.setRebuildState(isReBuild.booleanValue());
        tool = config.getToolsBySuperClassId(SBI_C_LINKER_TOOL_ID)[0];
        tool.setRebuildState(isReBuild.booleanValue());
    }

    public static String getCompilerToolchainBinPath(IConfiguration config) {
        String path;
        block4: {
            try {
                SmartBuildInterface sbi;
                String targetID = CommonConfigurationManager.getBuildTargetName(config);
                if (targetID == null) {
                    targetID = CommonConfigurationManager.getDefaultBuildTargetName(config);
                }
                if ((path = (sbi = SmartBuildInterface.getInstance()).getCCompilerPath(targetID)) != null) break block4;
                return "";
            }
            catch (SBIException e) {
                logger.error("Failed to get toolchain bin path", (Throwable)e);
                return "/usr/bin";
            }
        }
        return new Path(path).removeLastSegments(1).toPortableString();
    }

    public static String getCompilerToolchainBinPath(IProject project) {
        String path;
        block4: {
            try {
                SmartBuildInterface sbi;
                IConfiguration config = ProjectUtil.getDefaultConfiguration(project);
                String targetID = CommonConfigurationManager.getBuildTargetName(config);
                if (targetID == null) {
                    targetID = CommonConfigurationManager.getDefaultBuildTargetName(config);
                }
                if ((path = (sbi = SmartBuildInterface.getInstance()).getCCompilerPath(targetID)) != null) break block4;
                return "";
            }
            catch (SBIException e) {
                logger.error("Failed to get toolchain bin path", (Throwable)e);
                return "/usr/bin";
            }
        }
        return new Path(path).removeLastSegments(1).toPortableString();
    }

    public static void setDialectLanguage(IProject project, IConfiguration config, String id) {
        ITool[] tools = config.getToolsBySuperClassId(SBI_BASE_CPP_COMPILER_TOOL_ID);
        IOption option = null;
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            try {
                option = tool.getOptionBySuperClassId(GNU_CPP_DIALECT_OPTION_ID);
                ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String)id);
            }
            catch (Exception e) {
                logger.error("Failed to set dialect language option" + project, (Throwable)e);
            }
            ++n2;
        }
    }

    public static void setDefaultDialectLanguage(IProject project, IConfiguration config, String id, boolean isSave) {
        ITool[] tools = config.getToolsBySuperClassId(SBI_BASE_CPP_COMPILER_TOOL_ID);
        IOption option = null;
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            try {
                option = tool.getOptionBySuperClassId(GNU_CPP_DIALECT_OPTION_ID);
                option.setDefaultValue((Object)id);
            }
            catch (Exception e) {
                logger.error("Failed to set dialect language option" + project, (Throwable)e);
            }
            ++n2;
        }
        if (isSave) {
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
    }

    public static String getReferencedProjectPath(IProject project, String referencedProjectName) {
        if (referencedProjectName == null || referencedProjectName.isEmpty()) {
            return null;
        }
        ITizenProject tProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)project);
        if (tProject == null) {
            return null;
        }
        TizenProjectDescription desc = tProject.getDescription();
        if (desc == null) {
            return null;
        }
        String path = (String)desc.getReferencedLibraryProjectMap().get(referencedProjectName);
        if (path == null || path.isEmpty()) {
            return "lib";
        }
        return path;
    }

    public static void changeProject(IProject project, String profileVersion) {
        if (project == null) {
            return;
        }
        if (profileVersion == null || profileVersion.isEmpty()) {
            return;
        }
        String[] profileVersionInfos = profileVersion.split(" ");
        if (profileVersionInfos.length < 2) {
            return;
        }
        CommonConfigurationManager.changeProject(project, profileVersionInfos[0].toLowerCase(), profileVersionInfos[1]);
    }

    public static void changeProject(IProject project, String profile, String version) {
        CommonConfigurationManager.changeTProject(project, profile, version);
        CommonConfigurationManager.changeTManifest(project, profile, version);
    }

    public static void changeTManifest(IProject project, String profile, String version) {
        IXMLStore xmlStore = ProjectUtil.getXmlStore(project);
        if (xmlStore == null) {
            return;
        }
        xmlStore.setApiVersion(version);
        String profileName = xmlStore.getProfileName();
        if (profileName != null) {
            xmlStore.setProfileName(profile.toLowerCase());
        }
        xmlStore.setProject(project);
        xmlStore.storeXml();
    }

    public static void changeTProject(IProject project, String profileVersion) {
        if (project == null) {
            return;
        }
        if (profileVersion == null || profileVersion.isEmpty()) {
            return;
        }
        String[] profileVersionInfos = profileVersion.split(" ");
        if (profileVersionInfos.length < 2) {
            return;
        }
        CommonConfigurationManager.changeTProject(project, profileVersionInfos[0].toLowerCase(), profileVersionInfos[1]);
    }

    public static void changeTProject(IProject project, String profile, String version) {
        ITizenProject tProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)project);
        TizenProjectDescription desc = tProject.getDescription();
        String platformName = CommonConfigurationManager.getPlatformName(profile, version);
        desc.setPlatformName(platformName);
        TprojectHandler handler = new TprojectHandler(project);
        handler.marshal(desc);
    }

    public static String getPlatformName(String profile, String version) {
        if (profile == null || profile.isEmpty() || version == null || version.isEmpty()) {
            throw new IllegalArgumentException(String.format("profile = %s,  version = %s", profile, version));
        }
        return String.valueOf(profile) + "-" + version;
    }

    public static ArrayList<String> getValueOfIDOptionFromEDCCompiler(IConfiguration config) {
        ArrayList<String> valueList = new ArrayList<String>();
        IOption options = CommonConfigurationManager.getEdcCompilerOption(config, SBI_EDC_COMPILER_ID_OPTION_ID);
        if (options != null) {
            try {
                String[] stringArray = options.getStringListValue();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    valueList.add(value.trim());
                    ++n2;
                }
            }
            catch (BuildException e) {
                logger.error("Failed to get edc id option", (Throwable)e);
            }
        }
        return valueList;
    }

    public static String getEdcCompilerImageDirectoryPath(IConfiguration config) {
        return CommonConfigurationManager.getEdcCompilerOptionValue(CommonConfigurationManager.getEdcCompilerOption(config, SBI_EDC_COMPILER_ID_OPTION_ID));
    }

    public static String getEdcCompilerSoundDirectoryPath(IConfiguration config) {
        return CommonConfigurationManager.getEdcCompilerOptionValue(CommonConfigurationManager.getEdcCompilerOption(config, SBI_EDC_COMPILER_SD_OPTION_ID));
    }

    public static String getEdcCompilerFontDirectoryPath(IConfiguration config) {
        return CommonConfigurationManager.getEdcCompilerOptionValue(CommonConfigurationManager.getEdcCompilerOption(config, SBI_EDC_COMPILER_FD_OPTION_ID));
    }

    public static String[] getEdcImageDirs(IConfiguration config) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        IOption options = edcCompilerTool == null ? null : edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_ID_OPTION_ID);
        return CommonConfigurationManager.resolveToStringList(edcCompilerTool, options);
    }

    public static String[] getEdcImageDirs(IConfiguration config, IPath path) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config, path);
        IOption options = edcCompilerTool == null ? null : edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_ID_OPTION_ID);
        return CommonConfigurationManager.resolveToStringList(edcCompilerTool, options);
    }

    public static String[] getEdcSoundDirs(IConfiguration config) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        IOption options = edcCompilerTool == null ? null : edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_SD_OPTION_ID);
        return CommonConfigurationManager.resolveToStringList(edcCompilerTool, options);
    }

    public static String[] getEdcSoundDirs(IConfiguration config, IPath path) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config, path);
        IOption options = edcCompilerTool == null ? null : edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_SD_OPTION_ID);
        return CommonConfigurationManager.resolveToStringList(edcCompilerTool, options);
    }

    public static String[] getEdcFontDirs(IConfiguration config) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        IOption options = edcCompilerTool == null ? null : edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_FD_OPTION_ID);
        return CommonConfigurationManager.resolveToStringList(edcCompilerTool, options);
    }

    public static String[] getEdcFontDirs(IConfiguration config, IPath path) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config, path);
        IOption options = edcCompilerTool == null ? null : edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_FD_OPTION_ID);
        return CommonConfigurationManager.resolveToStringList(edcCompilerTool, options);
    }

    public static String getEdcCompilerImageDirFullPath(IConfiguration config) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        IOption options = edcCompilerTool == null ? null : edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_ID_OPTION_ID);
        return CommonConfigurationManager.resolveToString(edcCompilerTool, options);
    }

    public static String getEdcCompilerSoundDirFullPath(IConfiguration config) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        IOption options = edcCompilerTool == null ? null : edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_SD_OPTION_ID);
        return CommonConfigurationManager.resolveToString(edcCompilerTool, options);
    }

    public static String getEdcCompilerFontDirFullPath(IConfiguration config) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        IOption options = edcCompilerTool == null ? null : edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_FD_OPTION_ID);
        return CommonConfigurationManager.resolveToString(edcCompilerTool, options);
    }

    public static String resolveToString(ITool tool, IOption option) {
        String retValue = "";
        if (tool == null || option == null) {
            return retValue;
        }
        try {
            String val = option.getStringValue();
            BuildMacroProvider provider = BuildMacroProvider.getDefault();
            BuildfileMacroSubstitutor macro = new BuildfileMacroSubstitutor(null, new String(), " ");
            IMacroContextInfo info = provider.getMacroContextInfo(1, (Object)new FileContextData(null, null, option, (IBuildObject)tool));
            macro.setMacroContextInfo((IVariableContextInfo)info);
            retValue = CdtVariableResolver.resolveToString((String)val, (IVariableSubstitutor)macro);
        }
        catch (Exception e) {
            logger.error("Failed to resolve build option to String", (Throwable)e);
            return "";
        }
        return retValue;
    }

    public static String[] resolveToStringList(ITool tool, IOption option) {
        String[] retValue = new String[]{};
        if (tool == null || option == null) {
            return retValue;
        }
        try {
            String[] val = option.getStringListValue();
            BuildMacroProvider provider = BuildMacroProvider.getDefault();
            BuildfileMacroSubstitutor macro = new BuildfileMacroSubstitutor(null, new String(), " ");
            IMacroContextInfo info = provider.getMacroContextInfo(1, (Object)new FileContextData(null, null, option, (IBuildObject)tool));
            macro.setMacroContextInfo((IVariableContextInfo)info);
            retValue = CdtVariableResolver.resolveStringListValues((String[])val, (IVariableSubstitutor)macro, (boolean)false);
        }
        catch (Exception e) {
            logger.error("Failed to resolve build option to String", (Throwable)e);
            return new String[0];
        }
        return retValue;
    }

    private static String getEdcCompilerOptionValue(IOption options) {
        if (options == null) {
            return null;
        }
        String optionValue = null;
        try {
            optionValue = options.getStringValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler option", (Throwable)e);
            return null;
        }
        if (optionValue != null) {
            return optionValue.trim();
        }
        return optionValue;
    }

    public static void removeValueOfIDOptionToEDCCompiler(IConfiguration config, IResourceInfo info, String value) {
        String edcCompilerIDOptionId = SBI_EDC_COMPILER_ID_OPTION_ID;
        ITool edcCompilerTool = null;
        ITool[] iToolArray = info.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (tool.getBaseId().equals(SBI_EDC_COMPILER_TOOL_ID)) {
                edcCompilerTool = tool;
                break;
            }
            ++n2;
        }
        if (edcCompilerTool == null) {
            return;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(edcCompilerIDOptionId);
        String[] optionValue = null;
        try {
            optionValue = options.getStringListValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler id option", (Throwable)e);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] stringArray = optionValue;
        int n3 = optionValue.length;
        int n4 = 0;
        while (n4 < n3) {
            String v = stringArray[n4];
            if (!v.trim().equals(value.trim())) {
                valueList.add(v);
            }
            ++n4;
        }
        String[] newOptionValue = valueList.toArray(new String[valueList.size()]);
        try {
            info.setOption((IHoldsOptions)edcCompilerTool, options, newOptionValue);
        }
        catch (BuildException e) {
            logger.error("Failed to set edc compiler id option", (Throwable)e);
            return;
        }
    }

    public static void setValueOfIDOptionToEDCCompiler(IConfiguration config, IResourceInfo info, String value) {
        String edcCompilerIDOptionId = SBI_EDC_COMPILER_ID_OPTION_ID;
        ITool edcCompilerTool = null;
        ITool[] iToolArray = info.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (tool.getBaseId().equals(SBI_EDC_COMPILER_TOOL_ID)) {
                edcCompilerTool = tool;
                break;
            }
            ++n2;
        }
        if (edcCompilerTool == null) {
            return;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(edcCompilerIDOptionId);
        String[] optionValue = null;
        try {
            optionValue = options.getStringListValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler id option", (Throwable)e);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] stringArray = optionValue;
        int n3 = optionValue.length;
        int n4 = 0;
        while (n4 < n3) {
            String v = stringArray[n4];
            valueList.add(v);
            ++n4;
        }
        if (value.charAt(0) == ' ') {
            valueList.add(value);
        } else {
            valueList.add(" " + value);
        }
        String[] newOptionValue = valueList.toArray(new String[valueList.size()]);
        try {
            info.setOption((IHoldsOptions)edcCompilerTool, options, newOptionValue);
        }
        catch (BuildException e) {
            logger.error("Failed to set edc compiler id option", (Throwable)e);
            return;
        }
    }

    public static void setValueOfIDOptionToEDCCompiler(IConfiguration config, String value) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        if (edcCompilerTool == null) {
            logger.error("Failed to get edc compiler tool");
            return;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_ID_OPTION_ID);
        String[] optionValue = null;
        try {
            optionValue = options.getStringListValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler id option", (Throwable)e);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] stringArray = optionValue;
        int n = optionValue.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            valueList.add(v);
            ++n2;
        }
        if (value.charAt(0) == ' ') {
            valueList.add(value);
        } else {
            valueList.add(" " + value);
        }
        String[] newOptionValue = valueList.toArray(new String[valueList.size()]);
        try {
            options.setValue(newOptionValue);
        }
        catch (BuildException e) {
            logger.error("Failed to set edc compiler id option", (Throwable)e);
            return;
        }
    }

    public static ArrayList<String> getValueOfFDOptionFromEDCCompiler(IConfiguration config) {
        String edcCompilerFDOptionId = SBI_EDC_COMPILER_FD_OPTION_ID;
        ArrayList<String> valueList = new ArrayList<String>();
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        if (edcCompilerTool == null) {
            logger.error("Failed to get edc compiler tool");
            return valueList;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(edcCompilerFDOptionId);
        try {
            String[] stringArray = options.getStringListValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                valueList.add(value.trim());
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler fd option", (Throwable)e);
        }
        return valueList;
    }

    public static void removeValueOfFDOptionToEDCCompiler(IConfiguration config, IResourceInfo info, String value) {
        String edcCompilerFDOptionId = SBI_EDC_COMPILER_FD_OPTION_ID;
        ITool edcCompilerTool = null;
        ITool[] iToolArray = info.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (tool.getBaseId().equals(SBI_EDC_COMPILER_TOOL_ID)) {
                edcCompilerTool = tool;
                break;
            }
            ++n2;
        }
        if (edcCompilerTool == null) {
            return;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(edcCompilerFDOptionId);
        String[] optionValue = null;
        try {
            optionValue = options.getStringListValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler fd option", (Throwable)e);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] stringArray = optionValue;
        int n3 = optionValue.length;
        int n4 = 0;
        while (n4 < n3) {
            String v = stringArray[n4];
            if (!v.trim().equals(value.trim())) {
                valueList.add(v);
            }
            ++n4;
        }
        String[] newOptionValue = valueList.toArray(new String[valueList.size()]);
        try {
            info.setOption((IHoldsOptions)edcCompilerTool, options, newOptionValue);
        }
        catch (BuildException e) {
            logger.error("Failed to set edc compiler fd option", (Throwable)e);
            return;
        }
    }

    public static void setValueOfFDOptionToEDCCompiler(IConfiguration config, IResourceInfo info, String value) {
        String edcCompilerFDOptionId = SBI_EDC_COMPILER_FD_OPTION_ID;
        ITool edcCompilerTool = null;
        ITool[] iToolArray = info.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (tool.getBaseId().equals(SBI_EDC_COMPILER_TOOL_ID)) {
                edcCompilerTool = tool;
                break;
            }
            ++n2;
        }
        if (edcCompilerTool == null) {
            return;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(edcCompilerFDOptionId);
        String[] optionValue = null;
        try {
            optionValue = options.getStringListValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler fd option", (Throwable)e);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] stringArray = optionValue;
        int n3 = optionValue.length;
        int n4 = 0;
        while (n4 < n3) {
            String v = stringArray[n4];
            valueList.add(v);
            ++n4;
        }
        if (value.charAt(0) == ' ') {
            valueList.add(value);
        } else {
            valueList.add(" " + value);
        }
        String[] newOptionValue = valueList.toArray(new String[valueList.size()]);
        try {
            info.setOption((IHoldsOptions)edcCompilerTool, options, newOptionValue);
        }
        catch (BuildException e) {
            logger.error("Failed to set edc compiler fd option", (Throwable)e);
            return;
        }
    }

    public static void setValueOfFDOptionToEDCCompiler(IConfiguration config, String value) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        if (edcCompilerTool == null) {
            logger.error("Failed to get edc compiler tool");
            return;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_FD_OPTION_ID);
        String[] optionValue = null;
        try {
            optionValue = options.getStringListValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler fd option", (Throwable)e);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] stringArray = optionValue;
        int n = optionValue.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            valueList.add(v);
            ++n2;
        }
        if (value.charAt(0) == ' ') {
            valueList.add(value);
        } else {
            valueList.add(" " + value);
        }
        String[] newOptionValue = valueList.toArray(new String[valueList.size()]);
        try {
            options.setValue(newOptionValue);
        }
        catch (BuildException e) {
            logger.error("Failed to set edc compiler fd option", (Throwable)e);
            return;
        }
    }

    public static ArrayList<String> getValueOfSDOptionFromEDCCompiler(IConfiguration config) {
        ArrayList<String> valueList = new ArrayList<String>();
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        if (edcCompilerTool == null) {
            logger.error("Failed to get edc compiler tool");
            return valueList;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_SD_OPTION_ID);
        try {
            String[] stringArray = options.getStringListValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                valueList.add(value.trim());
                ++n2;
            }
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler sd option", (Throwable)e);
        }
        return valueList;
    }

    public static void removeValueOfSDOptionToEDCCompiler(IConfiguration config, IResourceInfo info, String value) {
        String edcCompilerSDOptionId = SBI_EDC_COMPILER_SD_OPTION_ID;
        ITool edcCompilerTool = null;
        ITool[] iToolArray = info.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (tool.getBaseId().equals(SBI_EDC_COMPILER_TOOL_ID)) {
                edcCompilerTool = tool;
                break;
            }
            ++n2;
        }
        if (edcCompilerTool == null) {
            return;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(edcCompilerSDOptionId);
        String[] optionValue = null;
        try {
            optionValue = options.getStringListValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler sd option", (Throwable)e);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] stringArray = optionValue;
        int n3 = optionValue.length;
        int n4 = 0;
        while (n4 < n3) {
            String v = stringArray[n4];
            if (!v.trim().equals(value.trim())) {
                valueList.add(v);
            }
            ++n4;
        }
        String[] newOptionValue = valueList.toArray(new String[valueList.size()]);
        try {
            info.setOption((IHoldsOptions)edcCompilerTool, options, newOptionValue);
        }
        catch (BuildException e) {
            logger.error("Failed to set edc compiler sd option", (Throwable)e);
            return;
        }
    }

    public static void setValueOfSDOptionToEDCCompiler(IConfiguration config, IResourceInfo info, String value) {
        String edcCompilerSDOptionId = SBI_EDC_COMPILER_SD_OPTION_ID;
        ITool edcCompilerTool = null;
        ITool[] iToolArray = info.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (tool.getBaseId().equals(SBI_EDC_COMPILER_TOOL_ID)) {
                edcCompilerTool = tool;
                break;
            }
            ++n2;
        }
        if (edcCompilerTool == null) {
            return;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(edcCompilerSDOptionId);
        String[] optionValue = null;
        try {
            optionValue = options.getStringListValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler sd option", (Throwable)e);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] stringArray = optionValue;
        int n3 = optionValue.length;
        int n4 = 0;
        while (n4 < n3) {
            String v = stringArray[n4];
            valueList.add(v);
            ++n4;
        }
        if (value.charAt(0) == ' ') {
            valueList.add(value);
        } else {
            valueList.add(" " + value);
        }
        String[] newOptionValue = valueList.toArray(new String[valueList.size()]);
        try {
            info.setOption((IHoldsOptions)edcCompilerTool, options, newOptionValue);
        }
        catch (BuildException e) {
            logger.error("Failed to set edc compiler sd option", (Throwable)e);
            return;
        }
    }

    public static void setValueOfSDOptionToEDCCompiler(IConfiguration config, String value) {
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        if (edcCompilerTool == null) {
            logger.error("Failed to get edc compiler tool");
            return;
        }
        IOption options = edcCompilerTool.getOptionBySuperClassId(SBI_EDC_COMPILER_SD_OPTION_ID);
        String[] optionValue = null;
        try {
            optionValue = options.getStringListValue();
        }
        catch (BuildException e) {
            logger.error("Failed to get edc compiler sd option", (Throwable)e);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] stringArray = optionValue;
        int n = optionValue.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            valueList.add(v);
            ++n2;
        }
        if (value.charAt(0) == ' ') {
            valueList.add(value);
        } else {
            valueList.add(" " + value);
        }
        String[] newOptionValue = valueList.toArray(new String[valueList.size()]);
        try {
            options.setValue(newOptionValue);
        }
        catch (BuildException e) {
            logger.error("Failed to set edc compiler sd option", (Throwable)e);
            return;
        }
    }

    public static ITool getEdcCompilerTool(IConfiguration config, IPath path) {
        IResourceInfo rcInfo = config.getResourceInfo(path, false);
        ITool tool = null;
        if (rcInfo instanceof IFileInfo) {
            IFileInfo fi = (IFileInfo)rcInfo;
            ITool[] tools = fi.getToolsToInvoke();
            if (tools != null && tools.length > 0) {
                tool = tools[0];
            }
        } else {
            IFolderInfo foInfo = (IFolderInfo)rcInfo;
            tool = foInfo.getToolFromInputExtension(path.getFileExtension());
        }
        return tool;
    }

    public static ITool getEdcCompilerTool(IConfiguration config) {
        String edcCompiler = SBI_EDC_COMPILER_TOOL_ID;
        return CommonConfigurationManager.getToolFromToolId(config, edcCompiler);
    }

    protected static ITool getToolFromToolId(IConfiguration config, String toolId) {
        if (config == null || toolId == null || toolId.isEmpty()) {
            return null;
        }
        return config.getToolsBySuperClassId(toolId)[0];
    }

    public static String getAPICheckerOptions() {
        return APICheckerOptions;
    }

    public static void setAPICheckerOptions(String newOptions) {
        APICheckerOptions = newOptions;
    }

    public static String getAPICheckerMiscOptions() {
        return APICheckerMiscOptions;
    }

    public static void setAPICheckerMiscOptions(String newOptions) {
        APICheckerMiscOptions = newOptions;
    }

    public static String getOutputStream() {
        return OutStream;
    }

    public static void setOutputStream(String Stream2) {
        OutStream = Stream2;
    }

    public static String getMiscToolOptions() {
        return miscToolOptions;
    }

    public static void setMiscToolOptions(String newOptions) {
        miscToolOptions = newOptions;
    }

    public static CommonBuildTargetManager getBuildTargetManager(String projectType) {
        CommonBuildTargetManager mgr = null;
        if (projectType != null) {
            mgr = buildTargetMap.get(projectType);
        }
        if (mgr == null) {
            mgr = buildTargetMap.get(DEFAULT_BUILD_TARGET_MGR_KEY);
        }
        return mgr;
    }

    public static void setBuildTargetName(IConfiguration config, String targetName) {
        CommonBuildTargetManager mgr = CommonConfigurationManager.getBuildTargetManager(null);
        mgr.setBuildTargetName(config, targetName);
    }

    public static String getBuildTargetName(IConfiguration config) {
        CommonBuildTargetManager mgr = CommonConfigurationManager.getBuildTargetManager(null);
        return mgr.getBuildTargetName(config);
    }

    public static void setBuildTargetName(IConfiguration config, IOption option, String targetName) {
        CommonBuildTargetManager mgr = CommonConfigurationManager.getBuildTargetManager(null);
        mgr.setBuildTargetName(config, option, targetName);
    }

    public static String getDefaultBuildTargetName(IConfiguration config) throws SBIException {
        String projectType = CommonConfigurationManager.getProjectType(config);
        CommonBuildTargetManager mgr = CommonConfigurationManager.getBuildTargetManager(projectType);
        return mgr.getDefaultBuildTargetName(config, projectType);
    }

    public static String getDefaultBuildTargetNameFromArchGroup(IConfiguration config, String arch) throws SBIException {
        String projectType = CommonConfigurationManager.getProjectType(config);
        CommonBuildTargetManager mgr = CommonConfigurationManager.getBuildTargetManager(projectType);
        return mgr.getDefaultBuildTargetNameFromArchGroup(config, arch, projectType);
    }

    public static String getRootstrapPath(IConfiguration config) {
        String path;
        block4: {
            try {
                SmartBuildInterface sbi;
                String targetID = CommonConfigurationManager.getBuildTargetName(config);
                if (targetID == null) {
                    targetID = CommonConfigurationManager.getDefaultBuildTargetName(config);
                }
                if ((path = (sbi = SmartBuildInterface.getInstance()).getRootstrapPath(targetID)) != null) break block4;
                return "";
            }
            catch (SBIException e) {
                logger.error("Failed to get rootstrap path", (Throwable)e);
                return "/";
            }
        }
        return path;
    }

    public static IOption getEdcCompilerOption(IConfiguration config, String optionId) {
        IOption options = null;
        ITool edcCompilerTool = CommonConfigurationManager.getEdcCompilerTool(config);
        if (edcCompilerTool != null) {
            options = edcCompilerTool.getOptionBySuperClassId(optionId);
        }
        return options;
    }
}

