/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.sa.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.tizen.common.ui.page.properties.model.ICheckerElement;
import org.tizen.common.ui.page.properties.model.RootChecker;
import org.tizen.nativecommon.ui.sa.pages.CheckboxTreeEditor;
import org.tizen.nativecommon.ui.sa.pages.CheckersProfileManager;

public class CheckersTreeEditor
extends CheckboxTreeEditor {
    private CheckersProfileManager profileManager;
    CheckerCheckStateProvider checkStateProvider;

    public CheckersProfileManager getProfileManager() {
        return this.profileManager;
    }

    public String getPreferenceName() {
        return this.profileManager.toolChainName;
    }

    @Override
    protected Object modelFromString(String s) {
        ICheckerElement root = this.profileManager.baseProfile;
        String[] checkedCheckers = s.split(",");
        ArrayList<String> checkersList = new ArrayList<String>();
        String[] stringArray = checkedCheckers;
        int n = checkedCheckers.length;
        int n2 = 0;
        while (n2 < n) {
            String checker = stringArray[n2];
            checkersList.add(checker);
            ++n2;
        }
        Object o = this.updateProfile(root, checkersList);
        return o;
    }

    private Object updateProfile(ICheckerElement node, List<String> checkersList) {
        if (node instanceof RootChecker) {
            RootChecker rootModule = (RootChecker)node;
            for (ICheckerElement child : rootModule.getChildren()) {
                this.updateProfile(child, checkersList);
            }
            return node;
        }
        if (node instanceof ICheckerElement) {
            ICheckerElement module = node;
            if (module.getChildren().isEmpty()) {
                String encoding = module.getEncoding();
                if (checkersList.contains(encoding)) {
                    this.setCheckedState(module, true);
                } else {
                    this.setCheckedState(module, false);
                }
            } else {
                String encoding = module.getEncoding();
                if (checkersList.contains(encoding)) {
                    this.setCheckedState(module, true);
                } else {
                    for (ICheckerElement child : module.getChildren()) {
                        this.updateProfile(child, checkersList);
                    }
                }
            }
        }
        return node;
    }

    void setCheckedState(ICheckerElement element, boolean state) {
        if (element instanceof ICheckerElement) {
            ICheckerElement module = element;
            if (module.getChildren().isEmpty()) {
                module.setChecked(state);
            } else {
                List<ICheckerElement> children = module.getChildren();
                for (ICheckerElement child : children) {
                    this.setCheckedState(child, state);
                }
            }
        }
    }

    protected String modelToString(Object model) {
        String modelString = "";
        if (model instanceof ICheckerElement) {
            ICheckerElement module = (ICheckerElement)model;
            if (module.getChildren().isEmpty()) {
                if (module.isChecked()) {
                    modelString = String.valueOf(modelString) + "," + module.getEncoding();
                }
            } else if (this.checkStateProvider.isChecked(model) && !this.checkStateProvider.isGrayed(model)) {
                modelString = String.valueOf(modelString) + "," + module.getEncoding();
            } else {
                for (ICheckerElement element : module.getChildren()) {
                    modelString = String.valueOf(modelString) + "," + this.modelToString(element);
                }
            }
        }
        return modelString;
    }

    @Override
    public String modelToSanatizedString(Object model) {
        String modelString = this.modelToString(model);
        String sanatizedString = modelString.replaceAll("(,)+", ",");
        if (sanatizedString.startsWith(",", 0)) {
            sanatizedString = sanatizedString.substring(1);
        }
        if (sanatizedString.endsWith(",")) {
            sanatizedString = sanatizedString.substring(0, sanatizedString.length() - 1);
        }
        return sanatizedString;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        if (element instanceof ICheckerElement) {
            ICheckerElement module = (ICheckerElement)element;
            if (module.getChildren().isEmpty()) {
                module.setChecked(event.getChecked());
            } else {
                List<ICheckerElement> children = module.getChildren();
                for (ICheckerElement ce : children) {
                    this.checkStateChanged(new CheckStateChangedEvent((ICheckable)this.getTreeViewer(), (Object)ce, event.getChecked()));
                }
            }
        }
        this.getTreeViewer().refresh();
        this.refreshValidState();
    }

    public CheckersTreeEditor(Composite parent, CheckersProfileManager profileManager) {
        super(profileManager.toolChainName, "", parent);
        this.profileManager = profileManager;
        this.setEmptySelectionAllowed(false);
        this.getTreeViewer().getTree().setHeaderVisible(true);
        this.checkStateProvider = new CheckerCheckStateProvider();
        this.getTreeViewer().setContentProvider((IContentProvider)new CheckersContentProvider());
        this.getTreeViewer().setCheckStateProvider((ICheckStateProvider)this.checkStateProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer(), (int)1);
        TreeViewerColumn column1 = new TreeViewerColumn((TreeViewer)this.getTreeViewer(), 0);
        column1.getColumn().setWidth(300);
        column1.getColumn().setText("Checkers");
        column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String text = "";
                if (element instanceof ICheckerElement) {
                    text = ((ICheckerElement)element).getName();
                }
                return text;
            }

            public boolean useNativeToolTip(Object object) {
                return true;
            }

            public String getToolTipText(Object element) {
                String tooltip = "";
                if (element instanceof ICheckerElement) {
                    tooltip = ((ICheckerElement)element).getDescription();
                }
                return tooltip;
            }
        });
        if (profileManager.baseProfile != null) {
            this.getTreeViewer().setInput((Object)profileManager.baseProfile);
        }
    }

    static class CheckerCheckStateProvider
    implements ICheckStateProvider {
        CheckerCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            if (element instanceof RootChecker) {
                return false;
            }
            if (element instanceof ICheckerElement) {
                ICheckerElement p = (ICheckerElement)element;
                if (p.getChildren().isEmpty()) {
                    return p.isChecked();
                }
                List<ICheckerElement> children = p.getChildren();
                for (ICheckerElement child : children) {
                    if (!this.isChecked(child)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isGrayed(Object element) {
            if (element instanceof RootChecker) {
                return false;
            }
            if (element instanceof ICheckerElement) {
                ICheckerElement module = (ICheckerElement)element;
                if (module.getChildren().isEmpty()) {
                    return false;
                }
                List<ICheckerElement> children = module.getChildren();
                boolean all_checked = true;
                boolean all_unchecked = true;
                for (ICheckerElement child : children) {
                    if (child instanceof ICheckerElement) {
                        ICheckerElement childModule = child;
                        if (this.isChecked(childModule) && !this.isGrayed(childModule)) {
                            all_unchecked = false;
                        }
                        if (!this.isChecked(childModule)) {
                            all_checked = false;
                        }
                        if (!this.isChecked(childModule) || !this.isGrayed(childModule)) continue;
                        all_unchecked = false;
                        all_checked = false;
                        continue;
                    }
                    if (!(child instanceof ICheckerElement)) continue;
                    if (this.isChecked(child)) {
                        all_unchecked = false;
                        continue;
                    }
                    all_checked = false;
                }
                return !all_checked && !all_unchecked;
            }
            return false;
        }
    }

    static class CheckersContentProvider
    implements IContentProvider,
    ITreeContentProvider {
        CheckersContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ICheckerElement) {
                return ((ICheckerElement)parentElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object childElement) {
            return null;
        }

        public boolean hasChildren(Object parentElement) {
            return this.getChildren(parentElement).length > 0;
        }
    }
}

