/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MIProcessAdapter;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.util.XMLUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class TizenMIProcessAdapter
extends MIProcessAdapter {
    private final Logger logger = LoggerFactory.getLogger(TizenMIProcessAdapter.class);
    private static final int ONE_SECOND = 1000;
    private static final String PROJECT_FILE = ".project";
    private static final String ATTR_PROJECT_NAME = "name";
    private Process gdbProcess;
    InputStream gdbInputStream;

    public TizenMIProcessAdapter(String[] args, int launchTimeout, IProgressMonitor monitor) throws IOException {
        super(args, launchTimeout, monitor);
    }

    public TizenMIProcessAdapter(String[] args, IProgressMonitor monitor) throws IOException {
        super(args, monitor);
    }

    public boolean canInterrupt(MIInferior inferior) {
        return true;
    }

    public void interrupt(MIInferior inferior) {
        block7: {
            if (this.gdbProcess instanceof Spawner) {
                super.interrupt(inferior);
            } else {
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.gdbProcess.getOutputStream()));
                int c = 3;
                try {
                    try {
                        bw.write(c);
                        bw.newLine();
                        bw.flush();
                        inferior.setSuspended();
                    }
                    catch (IOException e) {
                        this.logger.error("Unknown error occurred", (Throwable)e);
                        IOUtil.tryClose((Object[])new Object[]{bw});
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{bw});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{bw});
            }
        }
    }

    public InputStream getInputStream() {
        return this.gdbInputStream;
    }

    private IPath getProjectPath(String[] args) {
        String projectPathString = null;
        if (args != null) {
            String[] pathTokens;
            int i = 0;
            while (i < args.length) {
                if (args[i].contains("--cd")) {
                    projectPathString = args[i];
                    break;
                }
                ++i;
            }
            if (projectPathString != null && (pathTokens = projectPathString.split("=")) != null) {
                projectPathString = pathTokens[pathTokens.length - 1];
                Path projectPath = new Path(projectPathString);
                return projectPath;
            }
        }
        return null;
    }

    protected Process getGDBProcess(String[] args, int launchTimeout, IProgressMonitor monitor) throws IOException {
        IProject project = this.getProjectFromProject(args);
        if (project == null) {
            String message = "Failed to get a project";
            throw new IOException(message);
        }
        CommonProjectDependentBuilder builder = ProjectTypeManager.getProjectBuilderInstance(project);
        if (builder == null) {
            this.logger.error("Failed to get project builder: " + project);
            return null;
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        this.gdbProcess = builder.debug(newArgs);
        if (this.gdbProcess == null) {
            String message = "Failed to get a gdb process";
            throw new IOException(message);
        }
        Thread syncStartup = new Thread("GDB Start"){

            @Override
            public void run() {
                try {
                    PushbackInputStream pb = new PushbackInputStream(TizenMIProcessAdapter.this.gdbProcess.getInputStream());
                    TizenMIProcessAdapter.this.gdbInputStream = pb;
                    pb.unread(pb.read());
                }
                catch (Exception e) {
                    TizenMIProcessAdapter.this.logger.error("Unknown error occurred", (Throwable)e);
                }
            }
        };
        syncStartup.start();
        int timepass = 0;
        if (launchTimeout <= 0) {
            launchTimeout = Integer.MAX_VALUE;
        }
        timepass = 0;
        while (timepass < launchTimeout) {
            if (!syncStartup.isAlive() || monitor.isCanceled()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            timepass += 1000;
        }
        try {
            syncStartup.interrupt();
            syncStartup.join(1000L);
        }
        catch (InterruptedException interruptedException) {}
        if (monitor.isCanceled()) {
            this.gdbProcess.destroy();
            throw new OperationCanceledException();
        }
        if (timepass >= launchTimeout) {
            this.gdbProcess.destroy();
            String message = MIPlugin.getResourceString((String)"src.GDBDebugger.Error_launch_timeout");
            throw new IOException(message);
        }
        return this.gdbProcess;
    }

    private IProject getProjectFromProject(String[] args) {
        IPath projectPath = this.getProjectPath(args);
        if (projectPath == null) {
            return null;
        }
        String path = FileUtil.appendPath((String)projectPath.toOSString(), (String)PROJECT_FILE);
        File projectFile = new File(path);
        if (projectFile.exists()) {
            Element root = null;
            try {
                root = XMLUtil.getDocumentRootFromFile((File)projectFile);
                if (root != null) {
                    List elementList = XMLUtil.getChildrenOfElement((Element)root);
                    for (Element element : elementList) {
                        String projectName;
                        if (!ATTR_PROJECT_NAME.equals(element.getTagName()) || StringUtil.isEmpty((CharSequence)(projectName = element.getTextContent()))) continue;
                        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    }
                }
            }
            catch (DOMException e) {
                this.logger.error("Failed to call getTextContent", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error("Failed to call getDocumentRootFromFile", (Throwable)e);
            }
        }
        return null;
    }
}

