/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBServerCDIDebugger2;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MICommand;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.tizen.common.util.OSChecker;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.LaunchUtils;

public class TizenDebugger
extends GDBServerCDIDebugger2 {
    protected void doStartSession(ILaunch launch, Session session, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        if ("core".equals(debugMode)) {
            String msg = MIPlugin.getResourceString((String)"src.GDBServerDebugger.GDBServer_corefiles_unsupported");
            throw this.newCoreException(msg, null);
        }
        this.startGDBServerSession(config, session, monitor);
        try {
            session.getSharedLibraryManager().update();
        }
        catch (CDIException e) {
            LaunchUtils.newCoreException(MIPlugin.getResourceString((String)"TizenDebugger: shared libraries update failed."), e);
        }
        this.checkAndUpdateExecutablePath(session, config);
        this.initializeLibraries(config, session);
    }

    private void checkAndUpdateExecutablePath(Session debugSession, ILaunchConfiguration config) throws CoreException {
        IProject project = ProjectUtil.getProject(config);
        String path = String.valueOf(project.getLocation().toOSString()) + File.separator + ProjectUtil.getDefaultConfiguration(project).getName() + File.separator + ProjectUtil.getBinaryName(project);
        ICDITarget[] targetArray = debugSession.getTargets();
        int i = 0;
        while (i < targetArray.length) {
            Target target = (Target)targetArray[i];
            ICDISharedLibrary[] sharedLibs = null;
            try {
                sharedLibs = target.getSharedLibraries();
            }
            catch (CDIException e) {
                LaunchUtils.newCoreException(MIPlugin.getResourceString((String)"TizenDebugger: get sharedlibraries failed."), e);
            }
            boolean isFound = false;
            int ii = 0;
            while (ii < sharedLibs.length) {
                ICDISharedLibrary sLib = sharedLibs[ii];
                if (sLib.getFileName().contains(path)) {
                    isFound = true;
                    break;
                }
                ++ii;
            }
            if (!isFound) {
                MISession miSession = target.getMISession();
                CommandFactory factory = miSession.getCommandFactory();
                String version = factory.getMIVersion();
                if (OSChecker.isWindows()) {
                    path = path.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement("\\\\"));
                }
                String gdbFileCommand = "file \"" + path + "\"";
                MIInfo info = null;
                MIException ex = null;
                if (gdbFileCommand != null && gdbFileCommand.length() > 0) {
                    try {
                        MICommand cmd = new MICommand(version, gdbFileCommand);
                        miSession.postCommand((Command)cmd);
                        info = cmd.getMIInfo();
                    }
                    catch (MIException e) {
                        ex = e;
                    }
                    if (info == null) {
                        LaunchUtils.newCoreException(MIPlugin.getResourceString((String)"src.GDBServerCDIDebugger.target_selection_failed"), ex);
                    }
                }
            }
            ++i;
        }
    }
}

