/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.file;

import java.io.File;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.file.FileHandlingCommand;
import org.tizen.common.core.command.policy.OptionPolicy;
import org.tizen.common.core.command.prompter.FileHandlingOption;
import org.tizen.common.core.command.prompter.Option;
import org.tizen.common.core.command.prompter.RunnableOption;
import org.tizen.common.file.FileHandler;

public class DirectoryCopyHandlingCommand
extends FileHandlingCommand<Boolean> {
    protected List<String> targetPathList;
    protected List<String> sourcePathList;
    private FileHandlingOption selectedAllFlagOption;
    private static Logger logger = LoggerFactory.getLogger(DirectoryCopyHandlingCommand.class);

    public DirectoryCopyHandlingCommand(List<String> sourcePathList, List<String> targetPathList) throws IllegalArgumentException {
        if (sourcePathList.size() != targetPathList.size()) {
            throw new IllegalArgumentException("Lenghs of sourcePathList and target paths are not same");
        }
        this.sourcePathList = sourcePathList;
        this.targetPathList = targetPathList;
    }

    protected boolean isExcludedFile(File sourceFile, File targetFile) {
        return false;
    }

    public void setOverwriteOption(FileHandlingOption opt) {
        this.selectedAllFlagOption = opt;
    }

    protected FileHandlingOption getOverwriteOption() {
        return this.selectedAllFlagOption;
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        Option[] options;
        FileHandler handler = context.getFileHandler();
        Policy policy = context.getPolicy("exist.file.when.copy");
        if (policy == null) {
            return;
        }
        OptionPolicy optionPolicy = policy.adapt(OptionPolicy.class);
        if (optionPolicy == null) {
            return;
        }
        Option[] optionArray = options = optionPolicy.getOptions();
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (!(option instanceof FileHandlingOption)) {
                throw new IllegalArgumentException(String.format("Option %s is not a FileHandlingOption", option.getName()));
            }
            ((FileHandlingOption)option).setHandler(handler);
            ++n2;
        }
        int i = 0;
        while (i < this.sourcePathList.size()) {
            String sourcePath = this.sourcePathList.get(i);
            String targetPath = this.targetPathList.get(i);
            Stack<File> sourceStack = new Stack<File>();
            Stack<File> targetStack = new Stack<File>();
            sourceStack.push(new File(sourcePath));
            targetStack.push(new File(targetPath));
            while (!sourceStack.isEmpty()) {
                File sourceFile = (File)sourceStack.pop();
                File targetFile = (File)targetStack.pop();
                if (sourceFile.isDirectory()) {
                    handler.makeDirectory(targetFile.getPath());
                    File[] sourceChildren = sourceFile.listFiles();
                    if (sourceChildren == null) continue;
                    File[] fileArray = sourceChildren;
                    int n3 = sourceChildren.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File sourceChild = fileArray[n4];
                        sourceStack.push(sourceChild);
                        targetStack.push(new File(targetFile, sourceChild.getName()));
                        ++n4;
                    }
                    continue;
                }
                if (sourceFile.isFile()) {
                    if (this.isExcludedFile(sourceFile, targetFile)) continue;
                    if (targetFile.exists()) {
                        RunnableOption resultOption = null;
                        resultOption = this.selectedAllFlagOption == null ? (RunnableOption)context.getPrompter().interact(String.valueOf(targetFile.getCanonicalPath()) + " already exists", options) : this.selectedAllFlagOption;
                        if (resultOption.isAllFlag()) {
                            this.selectedAllFlagOption = resultOption;
                        }
                        resultOption.setArgument(sourceFile, targetFile);
                        resultOption.run();
                        continue;
                    }
                    if (targetFile.getParentFile() != null && !targetFile.getParentFile().exists()) {
                        targetFile.getParentFile().mkdirs();
                    }
                    targetFile.createNewFile();
                    handler.copyFile(sourceFile.getPath(), targetFile.getPath());
                    continue;
                }
                logger.warn(String.format("%s is not a file or directory", sourceFile));
            }
            ++i;
        }
    }
}

