/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rds;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.OSChecker;

public class RdsUtil {
    public static final String SEPARATOR = OSChecker.isWindows() ? "\\" : "/";
    public static final String FAST_DEPLOY_DATA_PATH = "fast-deploy";
    public static final String OLD_SNAPSHOT_NAME = "old-snapshot";
    public static final String SNAPSHOT_NAME = "snapshot";
    public static final String LATEST_SNAPSHOT_NAME = "latest-snapshot";
    private static final RdsUtil instance = new RdsUtil();

    public static RdsUtil getInstance() {
        return instance;
    }

    public String getProjectDirPath(IProject project) {
        String workspaceHash = this.getHashformWorkspace(project);
        return String.valueOf(InstallPathConfig.getIdeUserDataPath()) + SEPARATOR + FAST_DEPLOY_DATA_PATH + SEPARATOR + workspaceHash + SEPARATOR + project.getName();
    }

    private String getHashformWorkspace(IProject project) {
        File projectLocation = new File(project.getLocation().toString());
        String workspaceName = projectLocation.getParentFile().getName();
        String workspaceLocation = projectLocation.getParent();
        int hashForWorkspace = workspaceLocation.hashCode();
        return String.valueOf(workspaceName) + "_" + Integer.toString(hashForWorkspace);
    }

    public String getLatestSnapshotDirPath(IProject project) {
        return String.valueOf(this.getProjectDirPath(project)) + SEPARATOR + LATEST_SNAPSHOT_NAME;
    }

    public String getLatestSnapshotFilePath(IProject project) {
        return String.valueOf(this.getLatestSnapshotDirPath(project)) + SEPARATOR + ".sdk_delta.info";
    }

    public String getOldSnapshotDirPath(IProject project) {
        return String.valueOf(this.getProjectDirPath(project)) + SEPARATOR + OLD_SNAPSHOT_NAME;
    }

    public String getOldSnapshotFilePath(IProject project) {
        return String.valueOf(this.getOldSnapshotDirPath(project)) + SEPARATOR + ".sdk_delta.info";
    }

    public String getSnapshotDirPath(IProject project) {
        return String.valueOf(this.getProjectDirPath(project)) + SEPARATOR + SNAPSHOT_NAME;
    }

    public String getSnapshotFilePath(IProject project) {
        return String.valueOf(this.getSnapshotDirPath(project)) + SEPARATOR + ".sdk_delta.info";
    }

    public String getRdsDeltaDirPath(IProject project) {
        return String.valueOf(this.getProjectDirPath(project)) + SEPARATOR;
    }

    public boolean mkdir(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }

    public boolean copyToLatest(IProject project) {
        String snapshotPath = this.getSnapshotFilePath(project);
        String lastestPath = this.getLatestSnapshotFilePath(project);
        try {
            FileUtil.copyTo(snapshotPath, lastestPath);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean removeRDSMeta(IProject project) {
        String path = this.getProjectDirPath(project);
        return FileUtil.recursiveDelete(path);
    }
}

