/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.signer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.CommandCancelException;
import org.tizen.common.core.command.Executor;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.sign.command.ReadSigningProfileFileCommand;
import org.tizen.common.sign.command.SignCommand;
import org.tizen.common.sign.exception.CertificationException;
import org.tizen.common.sign.model.DeltaListResource;
import org.tizen.common.sign.preferences.DefaultSigningProfile;
import org.tizen.common.sign.preferences.Messages;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.preferences.UIMessages;
import org.tizen.common.sign.signer.ReferenceCacheParser;
import org.tizen.common.sign.signer.TizenIncrementalSigner;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDevice;

public class SignatureGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(SignatureGenerator.class);
    protected Executor executor = CommonPlugin.getDefault().getExecutor();
    protected IPreferenceStore pStore = SigningProfileUtil.getPreferenceStore();
    protected boolean bRDS = false;
    protected IDevice device;
    protected boolean bBackground = false;

    protected boolean getInsertSignatureOption() {
        return TizenPlatformConstants.SIGNING_DEFAULT;
    }

    protected String getActiveProfileName() {
        return this.pStore.getString("defaultprofile");
    }

    protected boolean isEmulator() {
        if (this.device == null) {
            return false;
        }
        return this.device.isEmulator();
    }

    public void setDevice(IDevice device) {
        this.device = device;
    }

    public SigningProfile loadProfiles() throws IOException {
        logger.trace("load profiles");
        SigningProfile profile = null;
        while (this.getInsertSignatureOption()) {
            String activeProfileName = SigningProfileUtil.getProfileContainerFromFile().getActiveProfileName();
            ReadSigningProfileFileCommand readProfile = new ReadSigningProfileFileCommand(SigningProfileUtil.getProfilesPath().toOSString(), activeProfileName);
            try {
                this.executor.execute(new Command[]{readProfile});
            }
            catch (IllegalStateException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CertificationException) {
                    throw new IOException(cause.getMessage(), cause);
                }
                throw e;
            }
            profile = readProfile.getProfile();
            if (profile != null) {
                SigningProfileItem authorItem = profile.getProfileItem(0);
                SigningProfileItem dist1Item = profile.getProfileItem(1);
                if (authorItem != null && dist1Item != null && !StringUtil.isEmpty((CharSequence)authorItem.getKeyLocation()) && !StringUtil.isEmpty((CharSequence)dist1Item.getKeyLocation())) {
                    break;
                }
            } else if (this.isEmulator()) {
                if (!this.isBackground()) {
                    this.executor.getContext().getPrompter().notify("Default profile is used for sign. This signed package is valid for emulator test only.");
                    logger.trace("A default profile is selected for {}", (Object)this.device.getSerialNumber());
                }
                return new DefaultSigningProfile();
            }
            String error = Messages.bind((String)UIMessages.getString("org.tizen.common.sign.profileerrormsg"), (Object)UIMessages.getString("org.tizen.common.sign.preference"));
            this.executor.getContext().getPrompter().error(error);
        }
        return profile;
    }

    public void sign(String path, SigningProfile profile) {
        logger.trace("sign (path: {}, RDS: {})", (Object)path, (Object)this.isRDSMode());
        SignCommand command = new SignCommand(path, profile, this.isRDSMode());
        command.setExcludes(new String[]{".*", "*~"});
        this.executor.execute(this.executor.getContext(), new Command[]{command});
    }

    public void setRDSMode(boolean bRDS) {
        this.bRDS = bRDS;
    }

    public boolean isRDSMode() {
        return this.bRDS;
    }

    public void setBackground(boolean bBackground) {
        this.bBackground = bBackground;
    }

    public boolean isBackground() {
        return this.bBackground;
    }

    public static void generate(IProject project, IContainer workingFolder, IDevice device) throws CoreException {
        SignatureGenerator.generate(project, workingFolder, device, null);
    }

    /*
     * Unable to fully structure code
     */
    public static void generate(IProject project, IContainer workingFolder, IDevice device, List<DeltaResourceInfo> deltaInfoList, boolean background) throws CoreException {
        generator = new SignatureGenerator();
        generator.setRDSMode(deltaInfoList != null);
        generator.setBackground(background);
        deltaRes = null;
        try {
            if (!generator.isRDSMode()) ** GOTO lbl15
            SignatureGenerator.logger.trace("create a delta info file for RDS mode");
            deltaRes = new DeltaListResource(project, workingFolder);
            deltaCount = deltaRes.createListResource(deltaInfoList);
            if (deltaCount == 0) {
                SignatureGenerator.logger.trace("skip to sign. created a delta info file, but no delta.");
                return;
            }
            try {
                SignatureGenerator.logger.trace("created a delta info file with delta list");
lbl15:
                // 2 sources

                generator.setDevice(device);
                loadedProfiles = generator.loadProfiles();
                path = workingFolder.getLocation().toString();
                generator.sign(path, loadedProfiles);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.tizen.common.sign", "Error occurred while signing the package.\n" + e.getMessage()));
            }
            catch (CommandCancelException v0) {
                throw new OperationCanceledException("Canceled a sign process");
            }
        }
        finally {
            if (deltaRes != null) {
                deltaRes.removeListResource();
            }
        }
    }

    public static void generate(IProject project, IContainer workingFolder, IDevice device, List<DeltaResourceInfo> deltaInfoList) throws CoreException {
        SignatureGenerator.generate(project, workingFolder, device, deltaInfoList, false);
    }

    public static void generate(String dir, String signedDir, String profilesPath, String profileName) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, ParserConfigurationException, XMLSecurityException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(profilesPath);
            SignatureGenerator.generate(dir, signedDir, is, profileName);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
    }

    public static void generate(String dir, String signedDir, InputStream profilesIs, String profileName) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, ParserConfigurationException, XMLSecurityException {
        SigningProfile profile = SignatureGenerator.loadProfile(profilesIs, profileName);
        TizenIncrementalSigner signer = new TizenIncrementalSigner(profile, dir);
        signer.setReferenceCacheParser(new ReferenceCacheParser((FileHandler)new StandardFileHandler(signedDir)));
        signer.sign(false);
    }

    public static void generateBySlicing(String dir, String signedDir, IDevice device) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, ParserConfigurationException, XMLSecurityException {
        SignatureGenerator generator = new SignatureGenerator();
        generator.setDevice(device);
        SigningProfile profile = generator.loadProfiles();
        TizenIncrementalSigner signer = new TizenIncrementalSigner(profile, dir);
        signer.setReferenceCacheParser(new ReferenceCacheParser((FileHandler)new StandardFileHandler(signedDir)));
        signer.signWithSlicing();
    }

    public static void generateBySlicing(String dir, String signedDir, String profilesPath, String profileName) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, ParserConfigurationException, XMLSecurityException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(profilesPath);
            SignatureGenerator.generateBySlicing(dir, signedDir, is, profileName);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
    }

    public static void generateBySlicing(String dir, String signedDir, InputStream profilesIs, String profileName) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, ParserConfigurationException, XMLSecurityException {
        SigningProfile profile = SignatureGenerator.loadProfile(profilesIs, profileName);
        TizenIncrementalSigner signer = new TizenIncrementalSigner(profile, dir);
        signer.setReferenceCacheParser(new ReferenceCacheParser((FileHandler)new StandardFileHandler(signedDir)));
        signer.signWithSlicing();
    }

    public static SigningProfile loadProfile(InputStream profilesIs, String profileName) throws IOException {
        SigningProfileContainer container = new SigningProfileContainer();
        container.readProfileXML(profilesIs);
        SigningProfile profile = container.getProfileByName(profileName);
        if (profile == null) {
            throw new IOException("Not found a specified profile: " + profileName);
        }
        return profile;
    }
}

