/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.templateengine.process;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ParsingUtil;
import org.tizen.nativecommon.exception.TizenProcessFailureException;
import org.tizen.nativecommon.templateengine.model.TizenProcessArgument;
import org.tizen.nativecommon.templateengine.process.Messages;
import org.tizen.nativecommon.templateengine.process.TizenProcessRunner;
import org.tizen.nativecommon.templateengine.util.TemplateUtil;

public class TizenCopyFolder
extends TizenProcessRunner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void process(TizenProcessArgument[] args) throws TizenProcessFailureException {
        String samplePath = this.getTemplate().getSamplePath();
        ArrayList<ReplaceableFile> replaceableFileList = new ArrayList<ReplaceableFile>();
        String srcFolderPath = args[1].getSimpleValue();
        TizenProcessArgument[][] replaceableFiles = args[2].getComplexArrayValue();
        int i = 0;
        while (i < replaceableFiles.length) {
            TizenProcessArgument[] file = replaceableFiles[i];
            String replaceTargetPath = file[0].getSimpleValue();
            if (!replaceTargetPath.equals("")) {
                String replaceableFilePath = FileUtil.appendPath((String)samplePath, (String)srcFolderPath);
                replaceableFilePath = FileUtil.appendPath((String)replaceableFilePath, (String)replaceTargetPath);
                replaceableFileList.add(new ReplaceableFile(replaceableFilePath, file[1].getSimpleValue(), ParsingUtil.parseBoolean((String)file[2].getSimpleValue(), (boolean)false)));
            }
            ++i;
        }
        File folderFile = new File(FileUtil.appendPath((String)samplePath, (String)srcFolderPath));
        if (!folderFile.exists()) {
            throw new TizenProcessFailureException(MessageFormat.format(Messages.getString("TizenCopyFolder.ExceptionTargetNotExist"), folderFile.getPath()));
        }
        this.copyFile(folderFile, replaceableFileList, this.getTemplate().getProjectPath());
    }

    protected void copyFile(File sampleRootDir, List<ReplaceableFile> replaces, String targetPath) {
        this.copyReplaceableFiles(replaces);
        ArrayList<File> filters = new ArrayList<File>();
        for (ReplaceableFile replace : replaces) {
            filters.add(new File(replace.sourcePath));
        }
        try {
            FileUtil.copyRecursively((String)sampleRootDir.getPath(), (String)targetPath, (boolean)false, (File[])filters.toArray(new File[filters.size()]));
        }
        catch (IOException e) {
            this.logger.error(MessageFormat.format(Messages.getString("TizenCopyFolder.ExceptionCopyingDir"), sampleRootDir.getPath()), (Throwable)e);
        }
    }

    protected void copyReplaceableFiles(List<ReplaceableFile> replaces) {
        Map<String, String> valueStore = this.getTemplate().getValueStore();
        for (ReplaceableFile replace : replaces) {
            String sourcePath = replace.getSourcePath();
            String _targetName = replace.getTargetPath();
            String targetName = TemplateUtil.getValueAfterExpandingMacros(_targetName, valueStore);
            String targetPath = FileUtil.appendPath((String)this.getTemplate().getProjectPath(), (String)targetName);
            if (replace.isReplaceable()) {
                try {
                    TemplateUtil.createReplaceableFile(sourcePath, targetPath, this.getTemplate().getValueStore());
                }
                catch (IOException e) {
                    this.logger.error(MessageFormat.format(Messages.getString("TizenCopyFolder.ExceptionCreatingReplacableFile"), sourcePath), (Throwable)e);
                }
                continue;
            }
            try {
                FileUtil.copyTo((String)sourcePath, (String)targetPath);
            }
            catch (IOException e) {
                this.logger.error(MessageFormat.format(Messages.getString("TizenCopyFolder.ExceptionCopyingFile"), sourcePath), (Throwable)e);
            }
        }
    }

    public static class ReplaceableFile {
        private String sourcePath;
        private String targetPath;
        private boolean replaceable;

        public ReplaceableFile(String sourcePath, String targetPath, boolean replaceable) {
            this.sourcePath = sourcePath;
            this.targetPath = targetPath;
            this.replaceable = replaceable;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public boolean isReplaceable() {
            return this.replaceable;
        }
    }
}

