/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command;

import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.sdb.command.message.PkgcmdErrorType;
import org.tizen.common.sdb.command.receiver.PkgCmdReceiver;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.service.ApplicationCmdService;

public class InstallCommand
extends ApplicationCommand {
    protected String APP_INSTALL_COMMAND = "/usr/bin/pkgcmd -q -i -t \"%s\" -p \"%s\" %s";
    protected ApplicationCmdService.PackageType pkgType = null;
    protected String path = null;
    protected String args = "";

    public InstallCommand(IDevice device, ApplicationCmdService.PackageType pkgType, String pkgPath, String args, ITizenConsoleManager console) {
        super(device, console);
        this.pkgType = pkgType;
        this.path = pkgPath;
        this.args = args;
    }

    protected InstallCommand(IDevice device, ITizenConsoleManager console) {
        super(device, console);
    }

    @Override
    protected void executeCommand() throws Exception {
        if (ApplicationCommand.isAppCmdSupported(this.getDevice())) {
            ApplicationCmdService appcmd = this.getApplicationCmdService();
            if (!appcmd.installPackage(this.pkgType, this.getPath(), null, null, (IShellOutputReceiver)this.receiver)) {
                this.newCoreException("Install command failed: " + this.getPath(), null);
            }
        } else {
            this.helper = new SdbCommandHelper(this.getDevice(), this.getConsole(), new PkgCmdReceiver(this.getConsole()));
            this.helper.runPkgCmd(this.getCommand(), new PkgcmdErrorType(), -1);
        }
    }

    protected String getCommand() {
        String command = String.format(this.APP_INSTALL_COMMAND, this.getPkgType(), this.getPath(), this.getArgs());
        return command;
    }

    protected ApplicationCmdService.PackageType getPkgType() {
        return this.pkgType;
    }

    protected String getPath() {
        return this.path;
    }

    protected String getArgs() {
        return this.args;
    }
}

