/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.sa.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.page.properties.model.ICheckerElement;
import org.tizen.common.ui.page.properties.model.RootChecker;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.ui.sa.SAMessages;
import org.tizen.nativecommon.ui.sa.pages.CheckersProfileManager;
import org.tizen.nativecommon.ui.sa.pages.CheckersTreeEditor;
import org.tizen.nativecommon.ui.sa.pages.FieldEditorOverlayPreferencePage;

public class TizenSAProperty
extends FieldEditorOverlayPreferencePage
implements IWorkbenchPreferencePage {
    private CheckersTreeEditor checkerTreeEditor;
    private static final Logger logger = LoggerFactory.getLogger(TizenSAProperty.class);
    private Button btnWithRunCheck;
    public static final String WITH_RUN_OPTION_ID = "org.tizen.nativecommon.option.sa.withrun";
    public static final String SA_PROPERTIES_PAGE_ID = "org.tizen.nativecommon.ui.sa.property";
    public static final QualifiedName WITH_RUN_OPTION_NAME = new QualifiedName("org.tizen.nativecommon.ui.sa.property", "org.tizen.nativecommon.option.sa.withrun");
    public static final String OPTION_ENABLE = "true";
    public static final String OPTION_DISABLE = "false";
    private IProject project;

    public String getCheckersInfo() {
        String checkers = this.checkerTreeEditor.modelToSanatizedString(this.checkerTreeEditor.getViewer().getInput());
        return checkers;
    }

    public TizenSAProperty() {
        super(1);
    }

    protected Control createContents(Composite parent) {
        if (this.getElement() != null) {
            this.project = (IProject)this.getElement().getAdapter(IResource.class);
        }
        this.createWithRunCheck(parent);
        super.createContents(parent);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        return parent;
    }

    private void createWithRunCheck(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.createNoteComposite(JFaceResources.getDialogFont(), composite, "Note:", SAMessages.PROPERTY_WITH_RUN_NOTE);
        this.btnWithRunCheck = new Button(composite, 32);
        this.btnWithRunCheck.setText(SAMessages.PROPERTY_WITH_RUN);
        this.btnWithRunCheck.setSelection(TizenSAProperty.getWithRunOption(this.project));
        GridLayoutFactory.fillDefaults().generateLayout(composite);
    }

    public static String getSaCheckers(IProject project) {
        ProjectScope ps = new ProjectScope(project);
        CommonProjectDependentBuilder builder = ProjectTypeManager.getProjectBuilderInstance((IProject)project);
        if (builder == null) {
            logger.error("Failed to get Project builder: " + project);
            return "";
        }
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String toolchainID = sbi.getToolchainIDFromTargetID(builder.getTargetID());
        String toolchainName = null;
        try {
            toolchainName = sbi.getToolchianNameFromToolchainID(toolchainID);
        }
        catch (SBIException e) {
            logger.error("Get SAChecker name failed: " + (Object)((Object)e));
        }
        if (toolchainName == null) {
            logger.error("Get SAChecker name failed: toolchain name is null");
            return "";
        }
        String defaultCheckers = "";
        if (toolchainName.contains(CheckersProfileManager.LLVM)) {
            defaultCheckers = TizenSAProperty.modelToSanatizedString(CheckersProfileManager.getXMLInput(CheckersProfileManager.LLVM));
        }
        String SACheckers = Platform.getPreferencesService().getString("org.tizen.nativecommon.ui", CheckersProfileManager.LLVM, defaultCheckers, new IScopeContext[]{ps});
        return SACheckers;
    }

    public static String modelToString(Object model) {
        String modelString = "";
        if (model instanceof RootChecker) {
            RootChecker module = (RootChecker)model;
            for (ICheckerElement element : module.getChildren()) {
                if (!element.isChecked()) continue;
                modelString = String.valueOf(modelString) + "," + element.getEncoding();
            }
        }
        return modelString;
    }

    public static String modelToSanatizedString(Object model) {
        String modelString = TizenSAProperty.modelToString(model);
        String sanatizedString = modelString.replaceAll("(,)+", ",");
        if (sanatizedString.startsWith(",", 0)) {
            sanatizedString = sanatizedString.substring(1);
        }
        if (sanatizedString.endsWith(",")) {
            sanatizedString = sanatizedString.substring(0, sanatizedString.length() - 1);
        }
        return sanatizedString;
    }

    public boolean performOk() {
        super.performOk();
        this.setWithRunOption(this.btnWithRunCheck.getSelection());
        return true;
    }

    public void performDefaults() {
        this.btnWithRunCheck.setSelection(false);
        super.performDefaults();
    }

    public static boolean getWithRunOption(IProject project) {
        if (project == null) {
            return false;
        }
        String option = null;
        try {
            option = project.getPersistentProperty(WITH_RUN_OPTION_NAME);
        }
        catch (CoreException e) {
            logger.warn("Failed to get WITH_RUN_PROPERTY_OPTION" + project, (Throwable)e);
            return false;
        }
        return OPTION_ENABLE.equals(option);
    }

    public static void setWithRunOption(IProject project, boolean option) {
        if (project == null) {
            return;
        }
        try {
            if (option) {
                project.setPersistentProperty(WITH_RUN_OPTION_NAME, OPTION_ENABLE);
            } else {
                project.setPersistentProperty(WITH_RUN_OPTION_NAME, OPTION_DISABLE);
            }
        }
        catch (CoreException e) {
            logger.warn("Failed to set WITH_RUN_PROPERTY_OPTION" + project, (Throwable)e);
            return;
        }
    }

    private void setWithRunOption(boolean isCheck) {
        TizenSAProperty.setWithRunOption(this.project, isCheck);
    }

    protected void createFieldEditors() {
        CommonProjectDependentBuilder builder = ProjectTypeManager.getProjectBuilderInstance((IProject)this.project);
        if (builder == null) {
            logger.error("Failed to get project builder: " + this.project);
            return;
        }
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String toolchainID = sbi.getToolchainIDFromTargetID(builder.getTargetID());
        String toolchainName = null;
        CheckersProfileManager manager = null;
        try {
            toolchainName = sbi.getToolchianNameFromToolchainID(toolchainID);
            manager = toolchainName != null ? new CheckersProfileManager(toolchainName) : new CheckersProfileManager(null);
        }
        catch (SBIException e) {
            e.printStackTrace();
        }
        this.checkerTreeEditor = new CheckersTreeEditor(this.getFieldEditorParent(), manager);
        this.getPreferenceStore().setDefault(CheckersProfileManager.LLVM, this.checkerTreeEditor.modelToSanatizedString(CheckersProfileManager.getXMLInput(CheckersProfileManager.LLVM)));
        this.checkerTreeEditor.setPreferenceStore(this.getPreferenceStore());
        this.addField(this.checkerTreeEditor);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 200;
        this.checkerTreeEditor.getTreeViewer().getControl().setLayoutData((Object)layoutData);
    }

    @Override
    protected String getPageId() {
        return "org.tizen.common.ui.page.properties.TizenSAProperty";
    }

    public void init(IWorkbench workbench) {
    }
}

