/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.Factory;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Policy;

public class Executor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Factory<ExecutionContext> contextFactory;
    protected ThreadLocal<ExecutionContext> contexts = new ThreadLocal<ExecutionContext>(){

        @Override
        protected ExecutionContext initialValue() {
            if (Executor.this.contextFactory == null) {
                return null;
            }
            return Executor.this.contextFactory.create();
        }
    };

    public Executor() {
    }

    public Executor(Factory<ExecutionContext> factory) {
        this.setContextFactory(factory);
    }

    public Factory<ExecutionContext> getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(Factory<ExecutionContext> factory) {
        this.logger.trace("ExecutionContextFactory :{}", factory);
        this.contextFactory = factory;
    }

    public void execute(Command<?> ... commands) {
        this.logger.trace("Commands :{}", (Object[])commands);
        this.contexts.remove();
        this.execute(this.contexts.get(), commands);
    }

    public void execute(ExecutionContext context, Command<?> ... commands) {
        try {
            try {
                Command<?>[] commandArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    Command<?> command = commandArray[n2];
                    command.run(this, context);
                    ++n2;
                }
            }
            catch (Exception e) {
                Policy policy = context.getPolicy("exception.unhandled");
                if (policy == null) {
                    this.logger.error("Error occured", (Throwable)e);
                    this.contexts.remove();
                    return;
                }
                Thread.UncaughtExceptionHandler handler = policy.adapt(Thread.UncaughtExceptionHandler.class);
                if (handler == null) {
                    throw new IllegalStateException(e);
                }
                handler.uncaughtException(Thread.currentThread(), e);
                this.contexts.remove();
            }
        }
        finally {
            this.contexts.remove();
        }
    }

    public void run(Command<?> command, ExecutionContext context) throws Exception {
        command.run(this, context);
    }

    public ExecutionContext getContext() {
        return this.contexts.get();
    }
}

