/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.Macro;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;

public final class ReturnInstruction
extends TemplateElement {
    private Expression exp;

    ReturnInstruction(Expression exp) {
        this.exp = exp;
    }

    void accept(Environment env) throws TemplateException {
        if (this.exp != null) {
            env.setLastReturnValue(this.exp.getAsTemplateModel(env));
        }
        if (this.nextSibling() != null) {
            throw Return.INSTANCE;
        }
        if (!(this.getParent() instanceof Macro) && !(this.getParent().getParent() instanceof Macro)) {
            throw Return.INSTANCE;
        }
    }

    public String getCanonicalForm() {
        String expString = this.exp == null ? "" : " " + this.exp.getCanonicalForm();
        return "<#return" + expString + "/>";
    }

    public String getDescription() {
        return "return [" + this.getStartLocation() + "]";
    }

    public static class Return
    extends RuntimeException {
        static final Return INSTANCE = new Return();

        private Return() {
        }
    }
}

