/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.Activator;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.util.IOUtil;

public class SigningProfileUtil {
    protected static final Logger logger = LoggerFactory.getLogger(SigningProfileUtil.class);
    protected static final String PROFILES_FILE = "profiles.xml";
    protected static final String MIGRATE_FILE = "migrated";
    protected static SigningProfileContainer container = null;
    private static final String KEYSTORE_DIRECTORY = "keystore";
    private static final String PROFILE_DIRECTORY = "profile";
    private static IPath profilePath = null;

    public static SigningProfileContainer getProfileContainerFromFile() {
        container = new SigningProfileContainer();
        IPath profilesPath = SigningProfileUtil.getProfilesPath();
        InputStream inputStream = null;
        try {
            inputStream = SigningProfileUtil.openFileStream(profilesPath.toFile());
            if (inputStream != null) {
                container.readProfileXML(inputStream);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{inputStream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        return container;
    }

    public static SigningProfileContainer getProfileContainerFromFile(String filePath) {
        SigningProfileContainer newContainer = new SigningProfileContainer();
        InputStream inputStream = null;
        try {
            inputStream = SigningProfileUtil.openFileStream(new Path(filePath).toFile());
            if (inputStream != null) {
                newContainer.readProfileXML(inputStream);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{inputStream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        return newContainer;
    }

    public static InputStream openFileStream(File file) {
        try {
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (IllegalStateException e) {
            logger.error("Can't access state location", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error("Can't open profile", (Throwable)e);
        }
        return null;
    }

    public static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static String getWorkspaceActiveProfileName() {
        return SigningProfileUtil.getPreferenceStore().getString("defaultprofile");
    }

    public static String getActiveProfileName() {
        if (container == null) {
            SigningProfileUtil.getProfileContainerFromFile();
        }
        return container.getActiveProfileName();
    }

    public static void setWorkspaceActiveProfileName(String profileName) {
        if (profileName == null) {
            profileName = "";
        }
        SigningProfileUtil.getPreferenceStore().setValue("defaultprofile", profileName);
    }

    public static void setActiveProfileName(String profileName) {
        if (profileName == null) {
            profileName = "";
        }
        container.setActiveProfile(profileName);
        SigningProfileUtil.writeProfilesToFile();
    }

    public static String getUserDataPath() {
        String sdkDataPath = null;
        try {
            sdkDataPath = InstallPathConfig.getUserDataPath();
        }
        catch (Exception e) {
            logger.error("Can't read Sdk User Data Path", (Throwable)e);
        }
        return sdkDataPath;
    }

    public static IPath getWorkspaceProfilesPath() {
        return Activator.getDefault().getStateLocation().append(PROFILES_FILE);
    }

    public static IPath getProfilesPath() {
        if (profilePath != null) {
            return profilePath;
        }
        String profileFolder = null;
        profileFolder = new Path(SigningProfileUtil.getUserDataPath()).append(PROFILE_DIRECTORY).toString();
        File profileFile = new File(profileFolder);
        if (!profileFile.exists()) {
            profileFile.mkdirs();
        }
        profilePath = new Path(profileFolder).append(PROFILES_FILE);
        IOUtil.tryClose((Object[])new Object[]{profileFile});
        return profilePath;
    }

    public static boolean writeProfilesToFile() {
        IPath profilesPath = SigningProfileUtil.getProfilesPath();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(profilesPath.toFile());
            container.writeProfileXML(outputStream);
        }
        catch (FileNotFoundException e) {
            try {
                logger.error("Can't write a profile", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{outputStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{outputStream});
            return false;
        }
        IOUtil.tryClose((Object[])new Object[]{outputStream});
        return true;
    }

    public static boolean writeProfilesToFile(SigningProfileContainer profileContainer) {
        container = profileContainer;
        return SigningProfileUtil.writeProfilesToFile();
    }

    public static IPath getCertStorePath() {
        return new Path(InstallPathConfig.getUserDataPath()).append(KEYSTORE_DIRECTORY);
    }

    public static IPath getAuthorCertStorePath() {
        return SigningProfileUtil.getCertStorePath().append("author");
    }

    public static boolean isMigrated() {
        File migrateFile = Activator.getDefault().getStateLocation().append(MIGRATE_FILE).toFile();
        return migrateFile.exists();
    }

    public static void writeMigrated() {
        File migrateFile = Activator.getDefault().getStateLocation().append(MIGRATE_FILE).toFile();
        try {
            migrateFile.createNewFile();
        }
        catch (IOException iOException) {
            logger.error("migrate file creation failed.");
        }
    }

    public static void autoMigrate() {
        String workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().lastSegment();
        SigningProfileContainer importingContainer = SigningProfileUtil.getProfileContainerFromFile(SigningProfileUtil.getWorkspaceProfilesPath().toString());
        SigningProfileContainer profileContainer = SigningProfileUtil.getProfileContainerFromFile();
        for (SigningProfile profile : importingContainer.getProfiles()) {
            String profileName = profile.getProfileName();
            if (profileContainer.containsProfile(profileName)) {
                SigningProfile origProfile = profileContainer.getProfileByName(profileName);
                if (origProfile.equals(profile)) continue;
                String newName = String.valueOf(profileName) + "_" + workspace;
                while (profileContainer.containsProfile(newName)) {
                    newName = String.valueOf(newName) + " (1)";
                }
                profile.setProfileName(newName);
                profileContainer.addProfile(profile);
                continue;
            }
            profileContainer.addProfile(profile);
        }
        if (profileContainer.getActiveProfile() == null) {
            profileContainer.setActiveProfile(importingContainer.getProfileByName(SigningProfileUtil.getWorkspaceActiveProfileName()));
        }
        SigningProfileUtil.writeProfilesToFile(profileContainer);
    }
}

