/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.nativecommon.po.editor.FlagImageManager;
import org.tizen.nativecommon.po.editor.Messages;
import org.tizen.nativecommon.po.model.Language;

public class ComboSelectionDialog
extends Dialog {
    private Table mTable;
    private Object input;
    private String title;
    private Text filterString;
    private boolean isLang;
    private Set<String> languageSet;
    private String[] MSG_TITLE = new String[]{Messages.POFIleConstants_0, Messages.POFileEditorPage_11};
    private String[] LANG_TITLE = new String[]{Messages.ComboSelectionDialog_2, Messages.POFileEditorPage_10};
    private int[] LAYOUT_WIDTH = new int[]{100, 300};
    private List<String> resultMsg;
    private List<Language> baseLangs;
    private List<String> baselangStr;
    private Combo combo;
    private String selectedBaseLang;

    protected ComboSelectionDialog(Shell parentShell, Object input, List<Language> baselangs, String title) {
        super(parentShell);
        if (input instanceof List) {
            this.isLang = true;
            this.languageSet = new HashSet<String>();
        } else {
            this.isLang = false;
            this.resultMsg = new ArrayList<String>();
        }
        this.input = input;
        this.title = title;
        this.baseLangs = baselangs;
        if (baselangs != null) {
            this.baselangStr = new ArrayList<String>();
            for (Language l : baselangs) {
                this.baselangStr.add(l.getLang());
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        if (this.isLang) {
            this.createFilterComposite(composite);
        }
        if (this.baseLangs != null) {
            this.createComboComposite(composite);
        }
        this.createTableComposite(composite);
        return composite;
    }

    private void createComboComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText("Base Language:");
        this.combo = new Combo(composite, 0);
        this.combo.setLayoutData((Object)gridData);
        this.combo.setItems(this.baselangStr.toArray(new String[0]));
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                ComboSelectionDialog.this.selectedBaseLang = ComboSelectionDialog.this.combo.getText();
            }
        });
        if (this.baselangStr.isEmpty()) {
            this.combo.setEnabled(false);
        } else {
            this.combo.select(0);
            this.selectedBaseLang = this.baselangStr.get(0);
        }
    }

    private void createFilterComposite(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        Label filterLabel = new Label(c, 0);
        filterLabel.setText(Messages.ComboSelectionDialog_4);
        this.filterString = new Text(c, 2048);
        GridData gd = new GridData(0);
        gd.widthHint = this.LAYOUT_WIDTH[1];
        this.filterString.setLayoutData((Object)gd);
        this.filterString.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComboSelectionDialog.this.mTable.removeAll();
                List langList = (List)ComboSelectionDialog.this.input;
                String filter = ComboSelectionDialog.this.filterString.getText().toLowerCase().trim();
                if (filter == null || filter.equals("")) {
                    for (Language lang : langList) {
                        ComboSelectionDialog.this.addLangInTable(lang);
                    }
                    return;
                }
                for (Language lang : langList) {
                    if (!lang.getId().toLowerCase().contains(filter) && !lang.getLang().toLowerCase().contains(filter)) continue;
                    ComboSelectionDialog.this.addLangInTable(lang);
                }
            }
        });
    }

    private void addLangInTable(Language lang) {
        TableItem item = new TableItem(this.mTable, 0);
        item.setText(0, lang.getId());
        Image image = FlagImageManager.getImage(lang.getLang());
        item.setImage(1, image);
        item.setText(1, lang.getLang());
        if (this.languageSet.contains(lang.getId())) {
            item.setChecked(true);
        } else {
            item.setChecked(false);
        }
    }

    private void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 300;
        composite.setLayoutData((Object)gridData);
        this.createTable(composite);
    }

    private void createTable(Composite parent) {
        this.mTable = new Table(parent, 2084);
        if (!this.isLang) {
            this.mTable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TableItem[] tableItemArray = ComboSelectionDialog.this.mTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getChecked()) {
                            ComboSelectionDialog.this.resultMsg.add(item.getText(0));
                        }
                        ++n2;
                    }
                }
            });
        }
        this.createColumns();
        this.createTableList();
    }

    private void createTableList() {
        if (this.isLang) {
            List langList = (List)this.input;
            for (Language lang : langList) {
                this.addLangInTable(lang);
            }
        } else {
            Table msgList = (Table)this.input;
            TableItem[] tableItemArray = msgList.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem msg = tableItemArray[n2];
                TableItem item = new TableItem(this.mTable, 0);
                item.setText(0, msg.getText(0));
                Image image = FlagImageManager.getImage(msg.getText(1));
                item.setImage(1, image);
                item.setText(1, msg.getText(1));
                ++n2;
            }
        }
    }

    private void createColumns() {
        int i = 0;
        while (i < 2) {
            TableColumn column = new TableColumn(this.mTable, 0, i);
            if (this.isLang) {
                column.setText(this.LANG_TITLE[i]);
            } else {
                column.setText(this.MSG_TITLE[i]);
            }
            column.setWidth(this.LAYOUT_WIDTH[i]);
            column.setResizable(false);
            column.setMoveable(true);
            ++i;
        }
        if (this.isLang) {
            this.mTable.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem item = (TableItem)e.item;
                    if (item.getChecked()) {
                        ComboSelectionDialog.this.languageSet.add(item.getText(0));
                    } else {
                        ComboSelectionDialog.this.languageSet.remove(item.getText(0));
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.mTable.setLayoutData((Object)new GridData(1808));
        this.mTable.setHeaderVisible(true);
        this.mTable.setLinesVisible(true);
    }

    protected List<String> getValue() {
        ArrayList<String> selectedValues = new ArrayList<String>();
        if (this.isLang) {
            for (String temp : this.languageSet) {
                selectedValues.add(temp);
            }
            return selectedValues;
        }
        return this.resultMsg;
    }

    public String getBaseLang() {
        return this.selectedBaseLang;
    }
}

