/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.command;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.tizen.common.TizenProjectType;
import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.LaunchCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.OSChecker;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.service.ApplicationCmdService;

public class NativeLaunchCommand
extends LaunchCommand {
    protected static final String PLATFORM_FAIL_MESSAGE = "fail";
    protected ILaunchConfiguration config = null;
    protected boolean isGcov = false;
    protected boolean isTest = false;

    public NativeLaunchCommand(IDevice device, ILaunchConfiguration config, boolean isGcov, boolean isTest, String args, ITizenConsoleManager console) {
        super(device, console);
        this.config = config;
        this.isGcov = isGcov;
        this.isTest = isTest;
        this.args = args;
    }

    protected String getAppId() throws CoreException {
        IProject project = ProjectUtil.getProject(this.config);
        String appId = ProjectUtil.getAppId(project);
        this.widgetId = this.isWidgetViewer() ? "org.tizen.widget_viewer_sdk widget_id " + appId : appId;
        String format = this.WIDGET_ID_FORMAT_OTHERS;
        if (OSChecker.isWindows() && !ApplicationCommand.isAppCmdSupported((IDevice)this.getDevice())) {
            format = this.WIDGET_ID_FORMAT_WIN;
        }
        return String.format(format, this.widgetId);
    }

    protected boolean isWidgetViewer() throws CoreException {
        IProject project = ProjectUtil.getProject(this.config);
        TizenProjectType projectType = ProjectUtil.getTizenProjectType(project);
        if (projectType.equals((Object)TizenProjectType.TIZEN_C_WIDGET_APPLICATION) || projectType.equals((Object)TizenProjectType.TIZEN_C_WATCH_APPLICATION)) {
            this.isUseWidgetViewer = true;
        }
        return this.isUseWidgetViewer;
    }

    protected void executeCommand() throws Exception {
        if (ApplicationCommand.isAppCmdSupported((IDevice)this.getDevice())) {
            ApplicationCmdService appcmd = this.getApplicationCmdService();
            if (!appcmd.runApplication(this.getAppId(), (IShellOutputReceiver)this.receiver)) {
                this.newCoreException("NativeLaunch command failed", null);
            }
        } else {
            this.helper = new SdbCommandHelper(this.getDevice(), this.getConsole(), null);
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.getSdbPath());
            command.add("-s");
            command.add(this.getDevice().getSerialNumber());
            command.add("launch");
            command.add("-a");
            command.addAll(this.splitParams(this.getAppId()));
            command.add("-p");
            command.add("-e");
            command.add("-m");
            command.add("run");
            command.addAll(this.splitParams(this.getArgs()));
            this.helper.runHostCommand(command);
        }
    }

    private String getType() {
        String type = "";
        if (this.isTest) {
            type = "gtest";
        }
        if (this.isGcov) {
            if (!type.isEmpty()) {
                type = String.valueOf(type) + ",";
            }
            type = String.valueOf(type) + "gcov";
        }
        if (!type.isEmpty()) {
            type = "-t " + type;
        }
        return type;
    }

    protected String getArgs() {
        if (this.args != null && !this.args.isEmpty()) {
            return String.valueOf(this.getType()) + " " + this.args;
        }
        return this.getType();
    }
}

