/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.nativecommon.PathUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.templateengine.util.TemplateUtil;
import org.tizen.sbilib.SBI;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Tool;
import org.tizen.sbilib.ide.Toolchain;

public abstract class CommonProjectDependentBuilder {
    private final Logger logger = LoggerFactory.getLogger(CommonProjectDependentBuilder.class);
    protected static final String DEBUG_INFO_PATH = new Path("/usr/lib/debug").toOSString();
    private static final String TEMPLATE_GDBINIT_NAME = "/templates/gdbinit";
    private static final String KEY_PRETTYPRINTER_PATH = "prettyprinters_path";
    public static final String GDBINIT_FILENAME = ".gdbinit";
    public static final String GDBCOMMAND_FILENAME = ".gdbcommand";
    private IProject project = null;
    private SmartBuildInterface sbi = null;

    public CommonProjectDependentBuilder() {
        this.setSbi();
    }

    public CommonProjectDependentBuilder(IProject project) {
        this.setProject(project);
        this.setSbi(project);
    }

    protected abstract String getConfigureOption();

    protected abstract String getMakeOption();

    protected abstract String getCleanOption();

    protected abstract String getDebugOption(String[] var1);

    protected abstract String getElfInfoOption();

    public abstract String getTargetID();

    public abstract String getTargetID(IConfiguration var1);

    public abstract void setBuildTargetID(IConfiguration var1, String var2);

    public abstract void setToolCommand(IConfiguration var1);

    public abstract void changeToolchain(IConfiguration var1, String var2);

    public void make_clean() throws SBIException {
        String targetID = this.getTargetID();
        String workingDir = this.getWorkingDir();
        IConfiguration cfg = ManagedBuildManager.getBuildInfo((IResource)this.project).getDefaultConfiguration();
        IManagedProject managedProject = cfg.getManagedProject();
        String projectType = managedProject.getName();
        if (projectType.equals("SLP Application Executable") && !this.checkMakeFile(String.valueOf(workingDir) + "/Makefile")) {
            throw new SBIException("Fail to clean. \n - please build project first");
        }
        SBI sbi = SBI.getInstance();
        sbi.makeClean(targetID, "clean", workingDir);
    }

    public String getDebugSysRootPath() {
        String sysRoot = "";
        try {
            sysRoot = this.getSbi().getRootstrapPath(this.getTargetID());
        }
        catch (SBIException e) {
            this.logger.error("Problem occurred while getting rootstrap path of " + this.getTargetID(), (Throwable)e);
        }
        return sysRoot;
    }

    public String getGDBCommandFilePath() {
        String workingDir = this.getWorkingDir();
        String gdbCommandPath = String.valueOf(workingDir) + File.separatorChar + GDBCOMMAND_FILENAME;
        File gdbcommandFile = new File(gdbCommandPath);
        if (gdbcommandFile.exists()) {
            gdbcommandFile.delete();
        }
        String sysrootPath = this.getDebugSysRootPath();
        if (OSChecker.isWindows() || OSChecker.isMAC()) {
            sysrootPath = PathUtil.convertMinGWPath(sysrootPath);
        }
        String debugfilePath = String.valueOf(sysrootPath) + DEBUG_INFO_PATH;
        try {
            this.createCommandFile(gdbcommandFile, sysrootPath, debugfilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return gdbCommandPath;
    }

    public Process debug(String[] arrOption) throws IOException {
        Tool tool;
        String sysrootPath;
        String gdbCommandPath;
        String gdbInitPath;
        String workingDir;
        block10: {
            Toolchain toolchain;
            block9: {
                workingDir = this.getWorkingDir();
                String targetID = this.getTargetID();
                gdbInitPath = String.valueOf(workingDir) + File.separatorChar + GDBINIT_FILENAME;
                gdbCommandPath = this.getGDBCommandFilePath();
                sysrootPath = this.getDebugSysRootPath();
                PluginManager pm = PluginManager.getInstance();
                toolchain = pm.getToolchainByTargetId(targetID);
                if (toolchain != null) break block9;
                return null;
            }
            tool = toolchain.getTool("debugger");
            if (tool != null) break block10;
            return null;
        }
        try {
            String gdbPath = tool.getPath();
            if (OSChecker.isWindows() || OSChecker.isMAC()) {
                sysrootPath = PathUtil.convertMinGWPath(sysrootPath);
                gdbPath = PathUtil.convertMinGWPath(gdbPath);
            }
            String debugfilePath = String.valueOf(sysrootPath) + DEBUG_INFO_PATH;
            File gdbcommandFile = new File(gdbCommandPath);
            if (gdbcommandFile.exists()) {
                gdbcommandFile.delete();
            }
            this.createCommandFile(gdbcommandFile, sysrootPath, debugfilePath);
            File gdbinitFile = new File(gdbInitPath);
            if (!gdbinitFile.exists()) {
                this.createGDBInitFile(gdbInitPath);
            }
            String[] options = new String[arrOption.length + 1];
            int i = 0;
            String[] stringArray = arrOption;
            int n = arrOption.length;
            int n2 = 0;
            while (n2 < n) {
                String option;
                options[i] = option = stringArray[n2];
                ++i;
                ++n2;
            }
            options[options.length - 1] = "--command=" + gdbCommandPath;
            return this.sbi.execute((IPath)new Path(gdbPath), options, this.sbi.getEnvironmentVariables(), (IPath)new Path(workingDir), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            this.logger.error("Problem occurred while executing gdb", (Throwable)e);
        }
        catch (IOException e) {
            String message = NLS.bind((String)TizenLaunchMessages.GDBFILE_PROBLEM, (Object)"gdbcommand");
            this.logger.error(message, (Throwable)e);
            throw new IOException(message, e);
        }
        return null;
    }

    public String getGDBCommandLine(StringBuffer arrOption) throws IOException, CoreException {
        Tool tool;
        String sysrootPath;
        String gdbCommandPath;
        String gdbInitPath;
        block8: {
            Toolchain toolchain;
            block7: {
                String workingDir = this.getWorkingDir();
                String targetID = this.getTargetID();
                try {
                    gdbInitPath = String.valueOf(workingDir) + File.separatorChar + GDBINIT_FILENAME;
                    gdbCommandPath = String.valueOf(workingDir) + File.separatorChar + GDBCOMMAND_FILENAME;
                    sysrootPath = this.getDebugSysRootPath();
                    PluginManager pm = PluginManager.getInstance();
                    toolchain = pm.getToolchainByTargetId(targetID);
                    if (toolchain != null) break block7;
                    return null;
                }
                catch (IOException e) {
                    String message = NLS.bind((String)TizenLaunchMessages.GDBFILE_PROBLEM, (Object)"gdbcommand");
                    this.logger.error(message, (Throwable)e);
                    throw new IOException(message, e);
                }
            }
            tool = toolchain.getTool("debugger");
            if (tool != null) break block8;
            return null;
        }
        String gdbPath = tool.getPath();
        if (OSChecker.isWindows() || OSChecker.isMAC()) {
            sysrootPath = PathUtil.convertMinGWPath(sysrootPath);
            gdbPath = PathUtil.convertMinGWPath(gdbPath);
        }
        String debugfilePath = String.valueOf(sysrootPath) + DEBUG_INFO_PATH;
        File gdbcommandFile = new File(gdbCommandPath);
        if (gdbcommandFile.exists()) {
            gdbcommandFile.delete();
        }
        this.createCommandFile(gdbcommandFile, sysrootPath, debugfilePath);
        File gdbinitFile = new File(gdbInitPath);
        if (!gdbinitFile.exists()) {
            this.createGDBInitFile(gdbInitPath);
        }
        arrOption.append(" --command=" + gdbInitPath);
        arrOption.append(" --command=" + gdbCommandPath);
        return String.valueOf(gdbPath) + arrOption.toString();
    }

    private void createGDBInitFile(String gdbInitPath) {
        String pythonPath = String.valueOf(InstallPathConfig.getToolsPath()) + File.separatorChar + "python";
        HashMap<String, String> valueStore = new HashMap<String, String>();
        valueStore.put(KEY_PRETTYPRINTER_PATH, "\"" + pythonPath.replace('\\', '/') + "\"");
        InputStream in = CommonProjectDependentBuilder.class.getClassLoader().getResourceAsStream(TEMPLATE_GDBINIT_NAME);
        try {
            TemplateUtil.createReplaceableFile(in, gdbInitPath, valueStore);
        }
        catch (IOException e) {
            this.logger.error(NLS.bind((String)TizenLaunchMessages.GDBFILE_PROBLEM, (Object)"gdbinit"), (Throwable)e);
        }
    }

    public void createCommandFile(File f, String sysrootPath, String debugfilePath) throws IOException {
        String sysrootOp = "set sysroot " + sysrootPath;
        String debugInfoOp = "\nset debug-file-directory " + debugfilePath + "\nset solib-search-path " + this.project.getLocation().toOSString() + File.separator + ProjectUtil.getDefaultConfiguration(this.project).getName() + "\ndir " + sysrootPath + File.separator + new Path("usr/src/debug").toOSString();
        TizenProjectType type = ProjectUtil.getTizenProjectType(this.project);
        if (type != null && (type.isNativeServiceApplicationProject() || TizenProjectType.TIZEN_C_WIDGET_APPLICATION.equals((Object)type))) {
            String fileOption = "\nfile \"" + this.project.getLocation().toOSString() + File.separator + ProjectUtil.getDefaultConfiguration(this.project).getName() + File.separator + ProjectUtil.getBinaryName(this.project) + "\"";
            debugInfoOp = String.valueOf(debugInfoOp) + fileOption;
        }
        debugInfoOp = String.valueOf(debugInfoOp) + "\nsharedlibrary";
        FileUtil.writeTextFile((File)f, (String)(String.valueOf(sysrootOp) + debugInfoOp), null);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public SmartBuildInterface getSbi() {
        return this.sbi;
    }

    public String getWorkingDir() {
        IConfiguration config = this.getConfiguration();
        String workingDir = String.valueOf(this.getProjectPath()) + File.separatorChar + config.getName();
        return workingDir;
    }

    public String getWorkingDir(IConfiguration config) {
        String workingDir = String.valueOf(this.getProjectPath()) + File.separatorChar + config.getName();
        return workingDir;
    }

    public String getProjectPath() {
        IPath proLoc = this.project.getLocation();
        return proLoc.toOSString();
    }

    public IConfiguration getConfiguration() {
        return ManagedBuildManager.getBuildInfo((IResource)this.project).getDefaultConfiguration();
    }

    public boolean checkMakeFile(String path) {
        Path makeFilePath = new Path(path);
        return makeFilePath.toFile().isFile();
    }

    public void setSbi() {
        this.sbi = SmartBuildInterface.getInstance();
    }

    public void setSbi(IProject project) {
        this.sbi = SmartBuildInterface.getInstance(project);
    }
}

