/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command;

import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.sdb.command.message.PkgcmdErrorType;
import org.tizen.common.sdb.command.receiver.PkgCmdReceiver;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.service.ApplicationCmdService;

public class UnInstallCommand
extends ApplicationCommand {
    protected String APP_UNINSTALL_COMMAND = "/usr/bin/pkgcmd -q -u -t \"%s\" -n \"%s\"";
    protected String pkgId = null;
    protected String pkgType = null;

    public UnInstallCommand(IDevice device, String pkgId, String pkgType, ITizenConsoleManager console) {
        super(device, console);
        this.pkgId = pkgId;
        this.pkgType = pkgType;
    }

    @Override
    protected void executeCommand() throws Exception {
        if (ApplicationCommand.isAppCmdSupported(this.getDevice())) {
            ApplicationCmdService appcmd = this.getApplicationCmdService();
            if (!appcmd.uninstallPackage(this.pkgId, (IShellOutputReceiver)this.receiver)) {
                this.newCoreException("Unistall command failed: " + this.pkgId, null);
            }
        } else {
            this.helper = new SdbCommandHelper(this.getDevice(), this.getConsole(), new PkgCmdReceiver(this.getConsole()));
            this.helper.runPkgCmd(this.getCommand(), new PkgcmdErrorType(), -1);
        }
    }

    public String getCommand() {
        String command = String.format(this.APP_UNINSTALL_COMMAND, this.getPkgType(), this.getPkgId());
        return command;
    }

    public String getPkgId() {
        return this.pkgId;
    }

    public String getPkgType() {
        return this.pkgType;
    }
}

