/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po.editor;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.nativecommon.po.editor.TableViewerKeyBoardSupporter;

class CellEditorKeyListener
extends KeyAdapter {
    private TableViewerKeyBoardSupporter fKeyBoardSupporter = null;
    private CellEditor fEditor = null;
    private int fEditorColumn = -1;

    public CellEditorKeyListener(TableViewerKeyBoardSupporter keyBoardSupporter, CellEditor editor, int editorColumn) {
        this.fKeyBoardSupporter = keyBoardSupporter;
        this.fEditor = editor;
        this.fEditorColumn = editorColumn;
    }

    public void keyPressed(KeyEvent e) {
        if (!(e.stateMask != SWT.MOD1 && e.stateMask != SWT.MOD2 || e.keyCode != 0x1000001 && e.keyCode != 0x1000002)) {
            this.fEditor.deactivate();
            e.doit = false;
            return;
        }
        if (e.stateMask != 0) {
            return;
        }
        switch (e.keyCode) {
            case 0x1000002: {
                e.doit = false;
                int nextRow = this.fKeyBoardSupporter.getTable().getSelectionIndex() + 1;
                if (nextRow >= this.fKeyBoardSupporter.getTable().getItemCount()) break;
                this.fKeyBoardSupporter.getTable().setSelection(nextRow);
                this.fKeyBoardSupporter.editColumnOrPrevPossible(this.fEditorColumn);
                break;
            }
            case 0x1000001: {
                e.doit = false;
                int prevRow = this.fKeyBoardSupporter.getTable().getSelectionIndex() - 1;
                if (prevRow < 0) break;
                this.fKeyBoardSupporter.getTable().setSelection(prevRow);
                this.fKeyBoardSupporter.editColumnOrPrevPossible(this.fEditorColumn);
                break;
            }
            case 0x100000B: {
                e.doit = false;
                this.fEditor.deactivate();
                Rectangle area = this.fKeyBoardSupporter.getComposite().getClientArea();
                this.fKeyBoardSupporter.getSizeController().restoreIfFocusingStatus(area, this.fKeyBoardSupporter.getTable());
            }
        }
    }
}

