/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.templateengine.build.model;

import java.util.LinkedHashSet;
import java.util.List;
import org.tizen.common.util.CollectionUtil;

public class DevPackageModel {
    private String name;
    private boolean isFrameworkPackage;
    private boolean isVirtualPackage;
    private boolean resolved = false;
    private LinkedHashSet<String> includePathSet = null;
    private LinkedHashSet<String> includeFileSet = null;
    private LinkedHashSet<String> libraryPathSet = null;
    private LinkedHashSet<String> librarySet = null;
    private LinkedHashSet<String> dependencySet = null;
    private LinkedHashSet<String> includePackageSet = null;
    private LinkedHashSet<String> descriptionSet = null;
    private LinkedHashSet<String> otherCFlagSet = null;
    private LinkedHashSet<String> otherLFlagSet = null;
    private LinkedHashSet<String> extSharedLibFileSet = null;

    public DevPackageModel(String name, boolean isFramework, boolean isVirtual) {
        this.name = name.trim();
        this.isFrameworkPackage = isFramework;
        this.isVirtualPackage = isVirtual;
        this.includePathSet = new LinkedHashSet();
        this.includeFileSet = new LinkedHashSet();
        this.libraryPathSet = new LinkedHashSet();
        this.librarySet = new LinkedHashSet();
        this.dependencySet = new LinkedHashSet();
        this.includePackageSet = new LinkedHashSet();
        this.descriptionSet = new LinkedHashSet();
        this.otherCFlagSet = new LinkedHashSet();
        this.otherLFlagSet = new LinkedHashSet();
        this.extSharedLibFileSet = new LinkedHashSet();
    }

    public String getName() {
        return this.name;
    }

    public boolean isFrameworkPackage() {
        return this.isFrameworkPackage;
    }

    public boolean isVirtulalPackage() {
        return this.isVirtualPackage;
    }

    public List<String> getIncludePathList() {
        return CollectionUtil.resolveSetAsList(this.includePathSet);
    }

    public void addIncludePath(String value) {
        String path = value.trim();
        if (!this.includePathSet.contains(path)) {
            this.includePathSet.add(path);
        }
    }

    public List<String> getIncludeFileList() {
        return CollectionUtil.resolveSetAsList(this.includeFileSet);
    }

    public void addIncludeFile(String value) {
        String file = value.trim();
        if (!this.includeFileSet.contains(file)) {
            this.includeFileSet.add(file);
        }
    }

    public List<String> getLibraryPathList() {
        return CollectionUtil.resolveSetAsList(this.libraryPathSet);
    }

    public void addLibraryPath(String value) {
        String path = value.trim();
        if (!this.libraryPathSet.contains(path)) {
            this.libraryPathSet.add(path);
        }
    }

    public List<String> getLibraryList() {
        return CollectionUtil.resolveSetAsList(this.librarySet);
    }

    public void addLibrary(String value) {
        String library = value.trim();
        if (!this.librarySet.contains(library)) {
            this.librarySet.add(library);
        }
    }

    public List<String> getDependencyList() {
        return CollectionUtil.resolveSetAsList(this.dependencySet);
    }

    public void addDepenency(String value) {
        String dependency = value.trim();
        if (!this.dependencySet.contains(dependency)) {
            this.dependencySet.add(dependency);
        }
    }

    public List<String> getIncludePackageList() {
        return CollectionUtil.resolveSetAsList(this.includePackageSet);
    }

    public void addIncludePackage(String value) {
        String include = value.trim();
        if (!this.includePackageSet.contains(include)) {
            this.includePackageSet.add(include);
        }
    }

    public String getDescription() {
        if (this.descriptionSet.isEmpty()) {
            return "No Description";
        }
        return this.descriptionSet.toString().trim();
    }

    public void addDescription(String value) {
        this.descriptionSet.add(value.trim());
    }

    public List<String> getOtherCFlagList() {
        return CollectionUtil.resolveSetAsList(this.otherCFlagSet);
    }

    public void addOtherCFlag(String value) {
        String flag = value.trim();
        if (!this.otherCFlagSet.contains(flag)) {
            this.otherCFlagSet.add(flag);
        }
    }

    public List<String> getOtherLFlagList() {
        return CollectionUtil.resolveSetAsList(this.otherLFlagSet);
    }

    public void addOtherLFlag(String value) {
        String flag = value.trim();
        if (!this.otherLFlagSet.contains(flag)) {
            this.otherLFlagSet.add(flag);
        }
    }

    public List<String> getExtendedSharedLibraryFileList() {
        return CollectionUtil.resolveSetAsList(this.extSharedLibFileSet);
    }

    public void addExtendedSharedLibraryFile(String value) {
        String file = value.trim();
        if (!this.extSharedLibFileSet.contains(file)) {
            this.extSharedLibFileSet.add(file);
        }
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public boolean isResolved() {
        return this.resolved;
    }
}

