/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchConfigurationConstants;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Tool;
import org.tizen.sbilib.ide.Toolchain;
import org.tizen.sdblib.IDevice;

public class TizenLaunchConfiguration {
    public static final int defaultTimeOut = 60000;
    private ILaunchConfigurationWorkingCopy configuration = null;

    public TizenLaunchConfiguration(ILaunchConfigurationWorkingCopy config) {
        this.configuration = config;
    }

    public TizenLaunchConfiguration(ILaunchConfigurationWorkingCopy config, IDevice device) {
        this.configuration = config;
    }

    public String getGDBPath(IProject project) {
        CommonProjectDependentBuilder builder = ProjectTypeManager.getProjectBuilderInstance(project);
        if (builder == null) {
            return null;
        }
        String targetID = builder.getTargetID();
        PluginManager pm = PluginManager.getInstance();
        Toolchain toolchain = pm.getToolchainByTargetId(targetID);
        if (toolchain == null) {
            return null;
        }
        Tool tool = toolchain.getTool("debugger");
        if (tool == null) {
            return null;
        }
        String gdbPath = tool.getPath();
        return gdbPath;
    }

    public void setDefaults2() {
        this.setDefaults();
        this.configuration.setAttribute(TizenLaunchConfigurationConstants.ATTR_DEBUGGER_SHOW_WARNING, TizenLaunchConfigurationConstants.DEBUGGER_SHOW_WARNING_DEFAULT);
        this.configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
        this.configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
    }

    public void setDefaults() {
        LaunchUtils.setStopAtMain(this.configuration, null);
        this.configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", TizenLaunchConfigurationConstants.ATTR_REMOTE_TCP_DEFAULT);
        this.configuration.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", "127.0.0.1");
        this.configuration.setAttribute("org.eclipse.cdt.dsf.gdb.AUTO_SOLIB", true);
        this.configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        this.configuration.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102");
        try {
            String projectName = this.configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (projectName.isEmpty()) {
                return;
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null || project.getLocation() == null) {
                return;
            }
            String gdbPath = this.getGDBPath(project);
            if (gdbPath == null) {
                return;
            }
            this.configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", gdbPath);
            CommonProjectDependentBuilder builder = ProjectTypeManager.getProjectBuilderInstance(project);
            this.configuration.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", builder.getGDBCommandFilePath());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void saveTizenConfiguration() throws CoreException {
        this.configuration.doSave();
    }
}

