/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.AbstractTizenProject;
import org.tizen.common.ITizenNativeProject;
import org.tizen.common.ITizenNativeXMLStore;
import org.tizen.common.ITizenProject;
import org.tizen.common.ITizenProjectAdapter;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.core.application.Version;
import org.tizen.common.launch.ITizenLaunchInfo;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.TizenNativePackageInfoStore;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.launch.TizenLaunchInfo;
import org.tizen.tpklib.TPK;
import org.tizen.tpklib.exception.TPKException;
import org.tizen.tpklib.lib.PathUtil;

public class TizenNativeProject
extends AbstractTizenProject
implements ITizenProjectAdapter,
ITizenNativeProject,
IAdaptable {
    private IProject project;
    protected static final Logger logger = LoggerFactory.getLogger(TizenNativeProject.class);

    public TizenNativeProject() {
    }

    public TizenNativeProject(IProject project) {
        this.project = project;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getAppId() {
        return ProjectUtil.getAppId(this.getProject());
    }

    public String getPackageId() {
        return null;
    }

    public TizenProjectType getTizenProjectType() {
        return ProjectUtil.getTizenProjectType(this.project);
    }

    public List<String> getBuildConfigurations() {
        IConfiguration[] configs;
        ArrayList<String> list = new ArrayList<String>();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.project);
        IConfiguration[] iConfigurationArray = configs = info.getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            list.add(config.getName());
            ++n2;
        }
        return list;
    }

    public String getDefaultBuildConfiguration() {
        return ProjectUtil.getDefaultConfiguration(this.project).getName();
    }

    protected IProject getProject() {
        return this.project;
    }

    public boolean canHandle(IProject project) {
        return org.tizen.common.util.ProjectUtil.isTizenNativeProject((IProject)project);
    }

    public ITizenProject getTizenProject(IProject project) {
        this.project = project;
        return this;
    }

    public List<DeltaResourceInfo> setSubAppInterestList(IProject project, boolean isRootNative, boolean bFirst) {
        ArrayList<DeltaResourceInfo> madeInterestList = new ArrayList<DeltaResourceInfo>();
        if (isRootNative) {
            DeltaResourceInfo subAppBinaryInterest = TizenLaunchInfo.makeSubAppBinaryInterest(project);
            madeInterestList.add(subAppBinaryInterest);
        } else if (bFirst) {
            List<DeltaResourceInfo> interestList = TizenLaunchInfo.makeInterestList(project);
            madeInterestList.addAll(interestList);
        } else {
            DeltaResourceInfo subAppBinaryInterest = TizenLaunchInfo.makeSubAppBinaryInterest(project);
            madeInterestList.add(subAppBinaryInterest);
        }
        return madeInterestList;
    }

    public List<DeltaResourceInfo> setSubAppIgnoreList() {
        return TizenLaunchInfo.makeIgnoreList(this.project);
    }

    public TizenPackageInfoStore getTizenPkgInfoStore() {
        Map includeMap;
        String binaryName;
        String buildDir;
        ArrayList<PackageResourceInfo> invisibleResInfo;
        ArrayList<PackageResourceInfo> pkgResInfo;
        block14: {
            pkgResInfo = new ArrayList<PackageResourceInfo>();
            invisibleResInfo = new ArrayList<PackageResourceInfo>();
            TPK tpk = TPK.getInstance();
            buildDir = ManagedBuildManager.getBuildInfo((IResource)this.project).getDefaultConfiguration().getName();
            binaryName = ProjectUtil.getBinaryName(this.project);
            includeMap = null;
            try {
                String verStr = this.getDescription().getVersion();
                if (verStr != null) {
                    Version version = new Version(verStr);
                    boolean needEmptyDirectory = !version.isSameOrBiggerThanVersion3();
                    includeMap = tpk.getIncludeListForPackaging(String.valueOf(this.project.getLocation().toString()) + File.separator + buildDir, binaryName, null, null, needEmptyDirectory);
                    break block14;
                }
                logger.error("Failed to get version: " + this.project);
                return null;
            }
            catch (TPKException e) {
                logger.error("Failed to get include list from tpklib", (Throwable)e);
                return null;
            }
        }
        TizenProjectType tizenProjectType = ProjectUtil.getTizenProjectType(this.project);
        if (tizenProjectType != null && tizenProjectType.isImeProject()) {
            String configName = ProjectUtil.getDefaultConfiguration(this.project).getName();
            String binaryPath = PathUtil.addPath((String[])new String[]{configName, binaryName});
            String binFilePath = PathUtil.addPath((String[])new String[]{this.project.getLocation().toOSString(), binaryPath});
            String targetPath = PathUtil.addPath((String[])new String[]{"lib", binaryName});
            includeMap.remove(binFilePath);
            includeMap.put(binFilePath, targetPath);
        }
        int projectPathLength = this.project.getLocation().toString().length();
        ArrayList<String> srcList = new ArrayList<String>();
        for (String src : includeMap.keySet()) {
            srcList.add(src);
        }
        for (String src : srcList) {
            int resourceType = new File(src).isDirectory() ? 2 : 1;
            Path srcPath = null;
            try {
                if (src.length() <= projectPathLength) {
                    includeMap.remove(src);
                    continue;
                }
                srcPath = new Path(src.substring(projectPathLength));
                IFile res = this.project.getFile((IPath)srcPath);
                if (res.isLinked()) {
                    includeMap.remove(src);
                    continue;
                }
                ResourceAttributes attr = res.getResourceAttributes();
                if (attr != null && attr.isSymbolicLink()) {
                    includeMap.remove(src);
                    continue;
                }
            }
            catch (Exception e) {
                logger.error("getTizenPkgInfoStore() src: " + src + " , projectPathLength: " + projectPathLength, (Throwable)e);
                logger.error("project.getLocation().toString(): " + this.project.getLocation().toString() + " , project: " + this.project, (Throwable)e);
            }
            if (srcPath == null || !srcPath.isValidPath(srcPath.toString())) continue;
            String remotePath = "";
            String[] stringArray = new Path((String)includeMap.get(src)).segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                remotePath = String.valueOf(remotePath) + "/" + name;
                ++n2;
            }
            if (srcPath.segment(0).equals(buildDir)) {
                invisibleResInfo.add(new PackageResourceInfo(srcPath.toString(), resourceType, 1, remotePath, true));
                continue;
            }
            if (srcPath.segment(0).equals(TizenPlatformConstants.CORE_MANIFEST_XML_FILE_NAME) && srcPath.segmentCount() == 1) {
                invisibleResInfo.add(new PackageResourceInfo(srcPath.toString(), resourceType, 1, remotePath, true));
                continue;
            }
            pkgResInfo.add(new PackageResourceInfo(srcPath.toString(), resourceType, 1, remotePath, true));
        }
        invisibleResInfo.add(new PackageResourceInfo("/" + SigningPathUtil.getSignatureDirectory(), 2, 1, "/", true));
        return new TizenNativePackageInfoStore(this.project, pkgResInfo, invisibleResInfo, includeMap, buildDir, binaryName);
    }

    private boolean isInvisibleRes(String src, String buildDir) {
        String[] INVISIBLE_RES_ARRAY = new String[]{"tizen-manifest.xml", buildDir, SigningPathUtil.getSignatureDirectory()};
        return false;
    }

    public ITizenNativeXMLStore getXmlStore() {
        return ProjectUtil.getXmlStore(this.project);
    }

    public ITizenLaunchInfo getLaunchInfo() {
        return ProjectUtil.getProjectManifest(this.project);
    }

    public List<PackageResourceInfo> optimize(List<PackageResourceInfo> pris) {
        if ("release".equalsIgnoreCase(this.getDefaultBuildConfiguration()) && "arm".equalsIgnoreCase(ProjectUtil.getArchitectureName(this.project))) {
            IConfiguration config = ProjectUtil.getDefaultConfiguration(this.project);
            String targetId = CommonConfigurationManager.getBuildTargetName(config);
            String outputPath = FileUtil.appendPath((String)this.getDefaultBuildConfiguration(), (String)".tpk");
            FileUtil.recursiveDelete((File)new File(FileUtil.appendPath((String)this.project.getLocation().toOSString(), (String)outputPath)));
            ArrayList<String> resourcePaths = new ArrayList<String>();
            for (PackageResourceInfo pri : pris) {
                resourcePaths.add(pri.getName());
            }
            TPK.strip((String)this.project.getLocation().toOSString(), resourcePaths, (String)outputPath, (String)targetId);
            ArrayList<PackageResourceInfo> results = new ArrayList<PackageResourceInfo>();
            int i = 0;
            while (i < resourcePaths.size()) {
                PackageResourceInfo pri = pris.get(i);
                results.add(new PackageResourceInfo(FileUtil.appendPath((String)outputPath, (String)pris.get(i).getName()), pri.getResourceType(), pri.getElementType(), pri.remotePath(), pri.isRequirement()));
                ++i;
            }
            return results;
        }
        return pris;
    }
}

