/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.spi.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.tizen.common.core.application.InstallPathConfig;

public class DynamicClassLoader
extends URLClassLoader {
    private static final String EXT_FOLDER = "cert-security-ext";
    private static ClassLoader classLoader;
    private static URL[] jarPath;

    public DynamicClassLoader(URL[] urls) {
        super(urls, Thread.currentThread().getContextClassLoader());
    }

    private static URL[] getPluginJarPath() {
        String sdkPath = InstallPathConfig.getToolsPath();
        URL[] jarPath = null;
        if (sdkPath == null) {
            return jarPath;
        }
        Path extJarsPath = Paths.get(String.valueOf(sdkPath) + File.separator + EXT_FOLDER, new String[0]);
        if (Files.exists(extJarsPath, new LinkOption[0])) {
            try {
                Object[] jars = Files.list(extJarsPath).toArray();
                ArrayList<URL> urls = new ArrayList<URL>();
                Object[] objectArray = jars;
                int n = jars.length;
                int n2 = 0;
                while (n2 < n) {
                    Object jar = objectArray[n2];
                    urls.add(new File(jar.toString()).toURI().toURL());
                    ++n2;
                }
                jarPath = new URL[urls.size()];
                jarPath = urls.toArray(jarPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return jarPath;
    }

    public static ClassLoader getClassLoader() {
        jarPath = DynamicClassLoader.getPluginJarPath();
        if (jarPath != null) {
            classLoader = new DynamicClassLoader(jarPath);
        }
        return classLoader;
    }
}

