/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.log.CustomLevel;
import org.tizen.common.util.log.UserLogger;

public class GoogleAnalyticAppender
extends AbstractAppender {
    private boolean isUsage = false;
    private boolean isPerform = false;
    static final String URL_GOOGLE_ANALYTIC = "http://www.google-analytics.com/collect";
    private static final int MAX_STACK_TRACE = 2;
    private static final String KEY_ANALYTIC_VER = "v";
    private static final String KEY_TRACKING_ID = "tid";
    private static final String KEY_CLIENT_ID = "cid";
    private static final String KEY_HIT_TYPE = "t";
    private static final String KEY_APP_NAME = "an";
    private static final String KEY_APP_VER = "av";
    private static final String KEY_CONTENT_DES = "cd";
    private static final String KEY_EVENT_CATEGORY = "ec";
    private static final String KEY_EVENT_ACTION = "ea";
    private static final String KEY_PERFORM_CATEGORY = "utc";
    private static final String KEY_PERFORM_VARIABLE = "utv";
    private static final String KEY_PERFORM_TIME = "utt";
    private static final String KEY_EXCEPTION = "exd";
    private static final String KEY_FATAL = "exf";
    private static final String VALUE_ANALYTIC_VER = "1";
    private static final String VALUE_TRACKING_ID = "UA-33537119-1";
    private static final String VALUE_CLIENT_ID = ObjectUtil.generateGUID(GoogleAnalyticAppender.class);
    private static final String VALUE_APP_NAME = "tizen-ide";
    private static final String VALUE_APP_VER = "dev";
    private static final String VALUE_HIT_TYPE_TIMING = "timing";
    private static final String VALUE_HIT_TYPE_EVENT = "event";
    private static final String VALUE_HIT_TYPE_APP = "appview";
    int rc;
    private static final Logger logger = LogManager.getLogger(GoogleAnalyticAppender.class);
    private static final StatusLogger statusLogger = StatusLogger.getLogger();

    public GoogleAnalyticAppender(boolean isUsage, boolean isPerform) {
        this(isUsage, isPerform, (Layout)PatternLayout.newBuilder().withPattern("[%d{yyyy.MM.dd HH:mm:ss}][%-5p] %F(%L) - %m%n").build());
    }

    public GoogleAnalyticAppender(boolean isUsage, boolean isPerform, Layout layout) {
        super("TIZEN_GOOGLE_APPENDER", null, layout, false);
        this.isUsage = isUsage;
        this.isPerform = isPerform;
    }

    public void setUsage(boolean isUsage) {
        this.isUsage = isUsage;
    }

    public void setPerform(boolean isPerform) {
        this.isPerform = isPerform;
    }

    protected String assembly(String key, String value) throws UnsupportedEncodingException {
        return String.valueOf(URLEncoder.encode(key, "utf-8")) + "=" + URLEncoder.encode(value, "utf-8");
    }

    protected String join(String ... props) {
        StringBuilder buffer = new StringBuilder(1000);
        int i = 0;
        int n = props.length;
        while (i < n) {
            if (i != 0) {
                buffer.append("&");
            }
            String prop = props[i];
            buffer.append(prop);
            ++i;
        }
        return buffer.toString();
    }

    public void append(LogEvent event) {
        try {
            this.rc = 0;
            ArrayList<String> result = new ArrayList<String>();
            try {
                if (!this.assembleString(result, event)) {
                    return;
                }
            }
            catch (UnsupportedEncodingException e) {
                statusLogger.error("Exception occurred while creating google analytic message", (Throwable)e);
                return;
            }
            String resultData = this.join(result.toArray(new String[result.size()]));
            try {
                URL u = new URL(URL_GOOGLE_ANALYTIC);
                HttpURLConnection con = (HttpURLConnection)u.openConnection();
                OutputStream out = null;
                OutputStreamWriter writer = null;
                try {
                    con.setDoOutput(true);
                    out = con.getOutputStream();
                    writer = new OutputStreamWriter(out);
                    writer.write(resultData);
                    writer.flush();
                    this.rc = con.getResponseCode();
                    if (200 <= this.rc && this.rc < 300) {
                        statusLogger.debug("Send log data to google analytic");
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose(writer, out);
                    con.disconnect();
                    throw throwable;
                }
                IOUtil.tryClose(writer, out);
                con.disconnect();
            }
            catch (MalformedURLException e) {
                statusLogger.debug(String.format("Malformed URL: %s", URL_GOOGLE_ANALYTIC), (Throwable)e);
            }
            catch (IOException e) {
                e.printStackTrace();
                statusLogger.debug("Exception occurred while transmitting google analytic data.", (Throwable)e);
            }
        }
        catch (Throwable t) {
            statusLogger.error(MessageFormat.format("Exception occurred while logging message: {0}", event.getMessage()), t);
        }
    }

    private boolean assembleString(ArrayList<String> result, LogEvent event) throws UnsupportedEncodingException {
        Level level = event.getLevel();
        if (level == CustomLevel.PERFORM_END) {
            if (!this.isPerform) {
                return false;
            }
            UserLogger.PerformanceInfo perform = (UserLogger.PerformanceInfo)event.getMessage();
            this.addPerformPreVariables(result, perform);
            result.add(this.assembly(KEY_PERFORM_TIME, perform.getPerformanceString()));
        } else if (level == CustomLevel.PERFORM_START) {
            if (!this.isPerform) {
                return false;
            }
            UserLogger.PerformanceInfo perform = (UserLogger.PerformanceInfo)event.getMessage();
            this.addPerformPreVariables(result, perform);
        } else if (level == CustomLevel.PAGE) {
            if (!this.isUsage) {
                return false;
            }
            this.addPageVariable(result, (UserLogger.Page)event.getMessage());
        } else if (level == CustomLevel.EVENT) {
            if (!this.isUsage) {
                return false;
            }
            this.addEventVariable(result, (UserLogger.Event)event.getMessage());
        } else {
            result.add(this.assembly(KEY_HIT_TYPE, VALUE_HIT_TYPE_APP));
        }
        this.addBasicInfo(result, event);
        return true;
    }

    private void addPageVariable(ArrayList<String> result, UserLogger.Page page) throws UnsupportedEncodingException {
        result.add(this.assembly(KEY_HIT_TYPE, VALUE_HIT_TYPE_EVENT));
        result.add(this.assembly(KEY_EVENT_CATEGORY, page.getCategory()));
    }

    private void addEventVariable(ArrayList<String> result, UserLogger.Event event) throws UnsupportedEncodingException {
        result.add(this.assembly(KEY_HIT_TYPE, VALUE_HIT_TYPE_EVENT));
        result.add(this.assembly(KEY_EVENT_CATEGORY, event.getCategory()));
        result.add(this.assembly(KEY_EVENT_ACTION, event.getAction()));
    }

    private void addPerformPreVariables(ArrayList<String> result, UserLogger.PerformanceInfo performanceInfo) throws UnsupportedEncodingException {
        result.add(this.assembly(KEY_HIT_TYPE, VALUE_HIT_TYPE_TIMING));
        result.add(this.assembly(KEY_PERFORM_CATEGORY, performanceInfo.getCategory()));
        result.add(this.assembly(KEY_PERFORM_VARIABLE, performanceInfo.getVariableName()));
    }

    private void addBasicInfo(ArrayList<String> result, LogEvent event) throws UnsupportedEncodingException {
        event.getLevel();
        StringBuilder msg = new StringBuilder();
        msg.append(this.getLayout().toSerializable(event));
        result.add(this.assembly(KEY_ANALYTIC_VER, VALUE_ANALYTIC_VER));
        result.add(this.assembly(KEY_TRACKING_ID, VALUE_TRACKING_ID));
        result.add(this.assembly(KEY_CLIENT_ID, VALUE_CLIENT_ID));
        result.add(this.assembly(KEY_APP_NAME, VALUE_APP_NAME));
        result.add(this.assembly(KEY_APP_VER, VALUE_APP_VER));
        result.add(this.assembly(KEY_CONTENT_DES, msg.toString()));
    }
}

