/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.AccessLog;
import org.tizen.common.AnalyticConfig;
import org.tizen.common.DeleteUser;
import org.tizen.common.ProfileLog;
import org.tizen.common.UsageLog;
import org.tizen.common.core.application.InstallPathConfig;

public class RemoteLogger {
    private static final Logger logger = LoggerFactory.getLogger(RemoteLogger.class);
    private static final String DEFAULT_VERSION = "Default";
    private static final String LOGGING_URL = "https://1lxb5yo2lb.execute-api.ap-northeast-2.amazonaws.com/v1";

    private static AnalyticConfig parseConfig(Path filePath) {
        File f = new File(filePath.toString());
        AnalyticConfig config = new AnalyticConfig("", false);
        if (f.exists()) {
            Gson gson = new Gson();
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (BufferedReader reader = Files.newBufferedReader(filePath);){
                    AnalyticConfig data = (AnalyticConfig)gson.fromJson((Reader)reader, AnalyticConfig.class);
                    if (data != null && data.id != null && data.logging != null) {
                        config.id = data.id;
                        config.logging = data.logging;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return config;
            }
        }
        return config;
    }

    public static Boolean isLoggingEnabled() {
        return RemoteLogger.getAnalyticsConf().logging;
    }

    public static void writeLoggingInfoToFile(Boolean log) {
        RemoteLogger.writeAnalyticsConf(RemoteLogger.getAnalyticsConf().id, log);
    }

    private static AnalyticConfig writeAnalyticsConf(String uuid, Boolean log) {
        Path filePath = Paths.get(InstallPathConfig.getAnalyticsConfig(), new String[0]);
        File f = new File(filePath.toString());
        f.delete();
        AnalyticConfig config = new AnalyticConfig(uuid, log);
        Gson gson = new Gson();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileWriter writer = new FileWriter(filePath.toString());){
                gson.toJson((Object)config, (Appendable)writer);
                ((Writer)writer).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonIOException | IOException e) {
            e.printStackTrace();
            return config;
        }
        return config;
    }

    public static boolean isUUIDExists() {
        Path filePath = Paths.get(InstallPathConfig.getAnalyticsConfig(), new String[0]);
        AnalyticConfig config = RemoteLogger.parseConfig(filePath);
        return !config.id.isEmpty();
    }

    private static AnalyticConfig getAnalyticsConf() {
        Path filePath = Paths.get(InstallPathConfig.getAnalyticsConfig(), new String[0]);
        File f = new File(filePath.toString());
        AnalyticConfig config = RemoteLogger.parseConfig(filePath);
        if (config.id.isEmpty()) {
            f.delete();
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            return RemoteLogger.writeAnalyticsConf(id, true);
        }
        return config;
    }

    private static String getTimestamp() {
        OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String timestamp = fmt.format(now);
        return timestamp;
    }

    private static String getOS() {
        String os = System.getProperty("os.name");
        return os;
    }

    private static void postUsage(UsageLog log) throws IOException {
        URL url = new URL("https://1lxb5yo2lb.execute-api.ap-northeast-2.amazonaws.com/v1/postusage");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        Gson gson = new Gson();
        String json = gson.toJson((Object)log);
        OutputStream os = conn.getOutputStream();
        os.write(json.getBytes("UTF-8"));
        os.close();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        String result = IOUtils.toString((InputStream)in, (String)"UTF-8");
        logger.debug(result);
    }

    private static void postAccess(AccessLog log) throws IOException {
        URL url = new URL("https://1lxb5yo2lb.execute-api.ap-northeast-2.amazonaws.com/v1/postaccess");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        Gson gson = new Gson();
        String json = gson.toJson((Object)log);
        OutputStream os = conn.getOutputStream();
        os.write(json.getBytes("UTF-8"));
        os.close();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        String result = IOUtils.toString((InputStream)in, (String)"UTF-8");
        logger.debug(result);
    }

    private static void postProfile(ProfileLog log) throws IOException {
        URL url = new URL("https://1lxb5yo2lb.execute-api.ap-northeast-2.amazonaws.com/v1/postprofile");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        Gson gson = new Gson();
        String json = gson.toJson((Object)log);
        OutputStream os = conn.getOutputStream();
        os.write(json.getBytes("UTF-8"));
        os.close();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        String result = IOUtils.toString((InputStream)in, (String)"UTF-8");
        logger.debug(result);
    }

    public static void logAccess(String product, String type, String profile, String apptype, String appversion) {
        AnalyticConfig conf = RemoteLogger.getAnalyticsConf();
        String uuid = conf.id;
        if (uuid.isEmpty()) {
            logger.info("Failed to generate UUID");
            return;
        }
        if (!conf.logging.booleanValue()) {
            logger.info("Logging is disabled by user");
            return;
        }
        AccessLog log = new AccessLog();
        log.id = uuid;
        log.type = type;
        log.product = product;
        log.timestamp = RemoteLogger.getTimestamp();
        try {
            log.version = RemoteLogger.getVersion();
        }
        catch (IOException iOException) {
            logger.info("Failed to get version");
            log.version = DEFAULT_VERSION;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("profile", profile);
        map.put("apptype", apptype);
        map.put("appversion", appversion);
        map.put("os", RemoteLogger.getOS());
        Gson gson = new Gson();
        log.custom_data = gson.toJson(map);
        try {
            RemoteLogger.postAccess(log);
        }
        catch (IOException iOException) {
            logger.info("Post Request failed");
        }
    }

    public static void deleteAnalytics() {
        try {
            URL url = new URL("https://1lxb5yo2lb.execute-api.ap-northeast-2.amazonaws.com/v1/deleteuser");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            AnalyticConfig conf = RemoteLogger.getAnalyticsConf();
            DeleteUser user = new DeleteUser();
            user.id = conf.id;
            Gson gson = new Gson();
            String json = gson.toJson((Object)user);
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes("UTF-8"));
            os.close();
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            String result = IOUtils.toString((InputStream)in, (String)"UTF-8");
            logger.debug(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void logUsage(String product, long usage) {
        AnalyticConfig conf = RemoteLogger.getAnalyticsConf();
        String uuid = conf.id;
        if (uuid.isEmpty()) {
            logger.info("Failed to generate UUID");
            return;
        }
        if (!conf.logging.booleanValue()) {
            logger.info("Logging is disabled by user");
            return;
        }
        UsageLog log = new UsageLog();
        log.id = uuid;
        log.type = "usage";
        log.product = product;
        log.timestamp = RemoteLogger.getTimestamp();
        log.usage = usage;
        try {
            log.version = RemoteLogger.getVersion();
        }
        catch (IOException iOException) {
            logger.info("Failed to get version");
            log.version = DEFAULT_VERSION;
        }
        try {
            RemoteLogger.postUsage(log);
        }
        catch (IOException iOException) {
            logger.info("Post Request failed");
        }
    }

    public static void logProfile(String hash, String product, String profile, String version, String os, String type) {
        AnalyticConfig conf = RemoteLogger.getAnalyticsConf();
        String uuid = conf.id;
        if (uuid.isEmpty()) {
            logger.info("Failed to generate UUID");
            return;
        }
        if (!conf.logging.booleanValue()) {
            logger.info("Logging is disabled by user");
            return;
        }
        ProfileLog log = new ProfileLog();
        log.id = uuid;
        log.type = type;
        log.product = product;
        log.hash = hash;
        log.profile = profile;
        log.pver = version;
        log.os = os;
        log.timestamp = RemoteLogger.getTimestamp();
        try {
            log.version = RemoteLogger.getVersion();
        }
        catch (IOException iOException) {
            logger.info("Failed to get version");
            log.version = DEFAULT_VERSION;
        }
        try {
            RemoteLogger.postProfile(log);
        }
        catch (IOException iOException) {
            logger.info("Post Request failed");
        }
    }

    private static String getVersion() throws IOException {
        Path filePath = Paths.get(InstallPathConfig.getSDKPath(), "sdk.version");
        byte[] encoded = Files.readAllBytes(Paths.get(filePath.toString(), new String[0]));
        String content = new String(encoded, StandardCharsets.UTF_8);
        String[] data = content.split("=");
        if (data.length < 2) {
            return DEFAULT_VERSION;
        }
        data[1] = data[1].replaceAll("[\\n\\t ]", "");
        return data[1];
    }
}

