/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.launch;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.RemoteLogger;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.fastdeploy.FastDeployer;
import org.tizen.common.rds.RdsUtil;
import org.tizen.common.util.ProjectUtil;

public class ProjectDeletionListener
implements IResourceChangeListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected IProject project;

    public void resourceChanged(IResourceChangeEvent event) {
        IResource rsrc;
        if (event.getType() == 4 && (rsrc = event.getResource()) instanceof IProject) {
            this.preProjectDelete((IProject)rsrc);
        }
    }

    private void preProjectDelete(IProject project) {
        RdsUtil.getInstance().removeRDSMeta(project);
        FastDeployer.reinstallComplete(project);
        ITizenProject tizenProject = ProjectUtil.getTizenProject(project);
        TizenProjectDescription desc = tizenProject.getDescription();
        ProfileInfo profileInfo = desc.getProfileInfo();
        String profile = profileInfo.getProfile();
        String appversion = desc.getVersion();
        String apptype = "Web";
        File file = project.getLocation().toFile();
        Path prjFile = Paths.get(file.getAbsolutePath(), ".cproject");
        if (Files.exists(prjFile, new LinkOption[0])) {
            apptype = "Native";
        }
        RemoteLogger.logAccess("TizenStudio", "delete_project", profile, apptype, appversion);
    }
}

