/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.fastdeploy;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.fastdeploy.FastDeployer;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.rds.RdsDeployer;
import org.tizen.common.rds.RdsMessages;
import org.tizen.common.sdb.command.PackageInfoCommand;
import org.tizen.common.sdb.command.TerminateCommand;
import org.tizen.common.sign.model.DeltaListResource;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.signer.SignatureGenerator;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.PluginUtil;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.IProjectLaunchCommand;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchInfo;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.util.StringUtil;
import org.tizen.tpklib.TPK;

public class NativeFastDeployer
extends FastDeployer {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String SIGNATURE_FILE_FOLDER = "/.sign";
    protected static final String SIGNATURE_TEMP_FILE = ".manifest.tmp";

    public NativeFastDeployer(IProject project, IDevice device, ITizenConsoleManager console, String pkgType, IProgressMonitor monitor) {
        super(project, device, console, pkgType, monitor);
        this.init(project);
    }

    private void init(IProject project) {
        this.setInterestList(TizenLaunchInfo.makeInterestList(project));
        this.setIgnoreList(TizenLaunchInfo.makeIgnoreList(project));
        List<DeltaResourceInfo> rootProjectAppendIngoreList = this.convertBlackListToRDSDeltaList(project);
        if (rootProjectAppendIngoreList != null) {
            this.appendIgnoreList(rootProjectAppendIngoreList);
        }
    }

    private List<DeltaResourceInfo> convertBlackListToRDSDeltaList(IProject project) {
        ArrayList<DeltaResourceInfo> appendIgnoreList = null;
        ITizenProject tizenProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)project);
        TizenPackageInfoStore tizenPkgInfoStore = tizenProject.getTizenPkgInfoStore();
        List blackList = tizenPkgInfoStore.getBlackList();
        if (blackList != null && blackList.size() > 0) {
            appendIgnoreList = new ArrayList<DeltaResourceInfo>();
            for (PackageResourceInfo packageInfo : blackList) {
                String name = packageInfo.getName();
                String remotePath = packageInfo.getRemotePath();
                int resourceType = packageInfo.getResourceType();
                DeltaResourceInfo ingoreDelta = new DeltaResourceInfo(name, "/" + name, remotePath, null, resourceType, project.getName());
                appendIgnoreList.add(ingoreDelta);
            }
        }
        return appendIgnoreList;
    }

    protected boolean preDeploy() throws CoreException {
        if (!super.preDeploy()) {
            return false;
        }
        PackageInfoCommand command = new PackageInfoCommand(this.device, this.console);
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(this.project);
        try {
            if (!command.isInstalled(manifest.getPackageName(), "TPK".toLowerCase())) {
                return false;
            }
        }
        catch (Exception e) {
            LaunchUtils.newCoreException(RdsMessages.CANNOT_FIND_APPLICATION, e);
        }
        return true;
    }

    protected void configureResMeta(List<DeltaResourceInfo> deltaInfoList) {
        for (DeltaResourceInfo info : deltaInfoList) {
            info.getName();
            IResource res = info.getResource();
            String[] stringArray = res.getFullPath().segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (segment.equals("res")) {
                    ProjectUtil.generateResMetaFile(this.project);
                    return;
                }
                ++n2;
            }
        }
    }

    protected void incrementalSign(List<DeltaResourceInfo> deltaList, IContainer workingFolder) throws CoreException, IOException {
        Assert.notNull((Object)workingFolder);
        SignatureGenerator generator = new SignatureGenerator();
        generator.setDevice(this.device);
        generator.setRDSMode(true);
        generator.setBackground(true);
        DeltaListResource deltaRes = new DeltaListResource(this.project, workingFolder);
        try {
            int deltaCount = deltaRes.createListResource(deltaList);
            if (deltaCount == 0) {
                return;
            }
            SigningProfile profile = generator.loadProfiles();
            IPath relativePath = workingFolder.getFullPath().makeRelativeTo(workingFolder.getWorkspace().getRoot().getFullPath());
            generator.sign(relativePath.toPortableString(), profile);
        }
        finally {
            deltaRes.removeListResource();
            workingFolder.refreshLocal(1, null);
        }
    }

    protected void killApplication() throws CoreException {
        TerminateCommand command = new TerminateCommand(this.device, this.getPkgId(), this.pkgType, this.console);
        try {
            command.execute();
        }
        catch (Exception e) {
            LaunchUtils.newCoreException(RdsDeployer.makeRdsLog((String)TizenLaunchMessages.CANNOT_TERMINATE), e);
        }
    }

    protected void printInfo(String message) {
        if (this.console != null) {
            this.console.println(message);
        }
    }

    protected String getAppInstallPath() {
        return ProjectUtil.getAppTmpDirectory(this.project, this.device);
    }

    protected String getPkgId() {
        IProjectLaunchCommand projectManifest = ProjectUtil.getProjectManifest(this.project);
        return projectManifest.getPackageName();
    }

    protected boolean sign(List<DeltaResourceInfo> deltaInfoList) {
        try {
            IFolder signFolder = this.project.getFolder(".sign");
            if (!signFolder.isSynchronized(2)) {
                signFolder.refreshLocal(2, null);
            }
            this.incrementalSign(deltaInfoList, (IContainer)signFolder);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IllegalStateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected void mergeApplicationXML() throws Exception {
        IXMLStore rootStore = this.getIXmlStore();
        if (rootStore != null) {
            String outputPath = this.getRootPrjPath();
            rootStore.setProject(outputPath);
            rootStore.loadXml();
            String[] refPrjPaths = this.getRefPrjPaths();
            if (refPrjPaths != null) {
                String[] stringArray = this.getRefPrjPaths();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String refPath = stringArray[n2];
                    IXMLStore refStore = this.getIXmlStore();
                    if (refStore != null) {
                        refStore.setProject(refPath);
                        refStore.loadXml();
                        rootStore.mergeAppData(refStore);
                        rootStore.mergePrivData(refStore);
                    }
                    ++n2;
                }
            }
            FileUtil.createTextFile((String)"manifest_multi.xml", (String)"", (String)outputPath, null);
            rootStore.storeXml(new File(outputPath, "manifest_multi.xml"));
        }
    }

    protected IXMLStore getIXmlStore() throws Exception {
        IXMLStore store = null;
        try {
            store = (IXMLStore)PluginUtil.loadClass((String)"org.tizen.nativecommon.store", (String)"org.tizen.nativecpp.misc.core.NewAppXmlStore");
        }
        catch (CoreException e) {
            throw new Exception(e);
        }
        return store;
    }

    public List<DeltaResourceInfo> getInterestDelta() {
        List<DeltaResourceInfo> deltaInfoList = null;
        ITizenProject tProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)this.project);
        this.setInterestList(tProject.getTizenPkgInfoStore().getInterestList());
        try {
            deltaInfoList = this.getDelta();
            if (deltaInfoList == null) {
                this.newCoreException(RdsMessages.CANNOT_FIND_DELTA, null);
            }
            deltaInfoList = this.getInterestDelta(deltaInfoList);
        }
        catch (CoreException coreException) {
            this.printInfo(RdsDeployer.makeRdsLog((String)RdsMessages.CANNOT_FIND_DELTA));
            return null;
        }
        return deltaInfoList;
    }

    public List<DeltaResourceInfo> getInterestDelta(List<DeltaResourceInfo> deltaInfoList) throws CoreException {
        ArrayList<DeltaResourceInfo> delta = new ArrayList<DeltaResourceInfo>();
        DeltaResourceInfo interestNode = null;
        String strRemotePath = "";
        String buildConf = ProjectUtil.getDefaultConfiguration(this.project).getName();
        String binFileName = ProjectUtil.getBinaryName(this.project);
        for (DeltaResourceInfo node : deltaInfoList) {
            String strProjectPath = this.project.getLocation().toString();
            String nodeProjectName = node.getProjectName();
            if (nodeProjectName != null && !this.project.getName().equals(nodeProjectName)) {
                strProjectPath = strProjectPath.replace(this.project.getName(), nodeProjectName);
            }
            interestNode = null;
            if (this.containsNode(node, this.ignoreList, strProjectPath) != null) continue;
            if ("delete" == node.getType()) {
                TPK tpk = TPK.getInstance();
                strRemotePath = tpk.getIncludePath(node.getResource().getProjectRelativePath().toString(), buildConf, binFileName);
                if (StringUtil.isEmpty((CharSequence)strRemotePath)) {
                    continue;
                }
            } else {
                interestNode = this.containsNode(node, this.interestList, strProjectPath);
                if (interestNode == null) continue;
                strRemotePath = this.getRemotePathOfDelta(interestNode, strProjectPath, node);
            }
            node.setRemotePath(strRemotePath);
            delta.add(node);
            this.getInterestDelta(node.getChildren());
        }
        return delta;
    }
}

