/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.model;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.signature.reference.ReferenceData;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ReflectionUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceDelegator
extends Reference {
    protected static final Logger logger = LoggerFactory.getLogger(ReferenceDelegator.class);
    protected static Reference referenceForInit;
    protected Reference reference;
    protected byte[] digestValue;
    protected String realPath;

    public static void setReference(Reference reference) {
        Assert.notNull((Object)reference);
        referenceForInit = reference;
    }

    public ReferenceDelegator(Element element, String baseURI, Manifest manifest, byte[] digestValue) throws XMLSecurityException {
        super(element, baseURI, manifest);
        this.digestValue = digestValue;
        referenceForInit = null;
    }

    public ReferenceDelegator(Element element, String baseURI, Manifest manifest, String realPath) throws XMLSecurityException {
        super(element, baseURI, manifest);
        this.realPath = realPath;
        referenceForInit = null;
    }

    private Reference getReference() {
        if (this.reference == null) {
            Assert.notNull((Object)referenceForInit, (String)"The setReference method must be called before an instance is created");
            this.reference = referenceForInit;
        }
        return this.reference;
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() throws XMLSignatureException {
        return this.getReference().getMessageDigestAlgorithm();
    }

    public void setURI(String uri) {
        this.getReference().setURI(uri);
    }

    public String getURI() {
        return this.getReference().getURI();
    }

    public void setId(String id) {
        this.getReference().setId(id);
    }

    public String getId() {
        return this.getReference().getId();
    }

    public void setType(String type) {
        this.getReference().setType(type);
    }

    public String getType() {
        return this.getReference().getType();
    }

    public boolean typeIsReferenceToObject() {
        return this.getReference().typeIsReferenceToObject();
    }

    public boolean typeIsReferenceToManifest() {
        return this.getReference().typeIsReferenceToManifest();
    }

    public void generateDigestValue() throws XMLSignatureException, ReferenceNotInitializedException {
        Reference ref = this.getReference();
        String uri = ref.getURI();
        if (SignatureUtility.isSignatureFile(uri)) {
            ref.generateDigestValue();
        } else if (this.realPath == null) {
            Class[] argsType = new Class[]{byte[].class};
            Object[] args = new Object[]{this.digestValue};
            try {
                ReflectionUtil.callMethod((Object)ref, (String)"setDigestValueElement", (Class[])argsType, (Object[])args, (boolean)true);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof XMLSignatureException) {
                    throw (XMLSignatureException)cause;
                }
                if (cause instanceof ReferenceNotInitializedException) {
                    throw (ReferenceNotInitializedException)cause;
                }
                throw new IllegalStateException(cause);
            }
        } else {
            ref.setURI(new File(this.realPath).toURI().toString());
            ref.generateDigestValue();
            ref.setURI(uri);
        }
    }

    public XMLSignatureInput getContentsBeforeTransformation() throws ReferenceNotInitializedException {
        return this.getReference().getContentsBeforeTransformation();
    }

    public XMLSignatureInput getContentsAfterTransformation() throws XMLSignatureException {
        return this.getReference().getContentsAfterTransformation();
    }

    public XMLSignatureInput getNodesetBeforeFirstCanonicalization() throws XMLSignatureException {
        return this.getReference().getNodesetBeforeFirstCanonicalization();
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        return this.getReference().getHTMLRepresentation();
    }

    public XMLSignatureInput getTransformsOutput() {
        return this.getReference().getTransformsOutput();
    }

    public ReferenceData getReferenceData() {
        return this.getReference().getReferenceData();
    }

    protected XMLSignatureInput dereferenceURIandPerformTransforms(OutputStream os) throws XMLSignatureException {
        Class[] argsType = new Class[]{OutputStream.class};
        Object[] args = new Object[]{os};
        try {
            return (XMLSignatureInput)ReflectionUtil.callMethod((Object)this.getReference(), (String)"dereferenceURIandPerformTransforms", (Class[])argsType, (Object[])args, (boolean)true);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof XMLSignatureException) {
                throw (XMLSignatureException)cause;
            }
            throw new IllegalStateException(cause);
        }
    }

    public Transforms getTransforms() throws XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        return this.getReference().getTransforms();
    }

    public byte[] getReferencedBytes() throws ReferenceNotInitializedException, XMLSignatureException {
        return this.getReference().getReferencedBytes();
    }

    public byte[] getDigestValue() throws Base64DecodingException, XMLSecurityException {
        return this.getReference().getDigestValue();
    }

    public boolean verify() throws ReferenceNotInitializedException, XMLSecurityException {
        return this.getReference().verify();
    }

    public String getBaseLocalName() {
        return this.getReference().getBaseLocalName();
    }

    public String getBaseNamespace() {
        return this.getReference().getBaseNamespace();
    }

    protected Element createElementForFamilyLocal(Document doc, String namespace, String localName) {
        Class[] argsType = new Class[]{Document.class, String.class, String.class};
        Object[] args = new Object[]{doc, namespace, localName};
        try {
            return (Element)ReflectionUtil.callMethod((Object)this.getReference(), (String)"createElementForFamilyLocal", (Class[])argsType, (Object[])args, (boolean)true);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new IllegalStateException(cause);
        }
    }

    public void setElement(Element element, String BaseURI) throws XMLSecurityException {
        this.getReference().setElement(element, BaseURI);
    }

    public Document getDocument() {
        return this.getReference().getDocument();
    }

    public String getBaseURI() {
        return this.getReference().getBaseURI();
    }

    public void addBigIntegerElement(BigInteger bi, String localname) {
        this.getReference().addBigIntegerElement(bi, localname);
    }

    public void addBase64Element(byte[] bytes, String localname) {
        this.getReference().addBase64Element(bytes, localname);
    }

    public void addTextElement(String text, String localname) {
        this.getReference().addTextElement(text, localname);
    }

    public void addBase64Text(byte[] bytes) {
        this.getReference().addBase64Text(bytes);
    }

    public void addText(String text) {
        this.getReference().addText(text);
    }

    public BigInteger getBigIntegerFromChildElement(String localname, String namespace) throws Base64DecodingException {
        return this.getReference().getBigIntegerFromChildElement(localname, namespace);
    }

    public byte[] getBytesFromChildElement(String localname, String namespace) throws XMLSecurityException {
        return this.getReference().getBytesFromChildElement(localname, namespace);
    }

    public String getTextFromChildElement(String localname, String namespace) {
        return this.getReference().getTextFromChildElement(localname, namespace);
    }

    public byte[] getBytesFromTextChild() throws XMLSecurityException {
        return this.getReference().getBytesFromTextChild();
    }

    public String getTextFromTextChild() {
        return this.getReference().getTextFromTextChild();
    }

    public int length(String namespace, String localname) {
        return this.getReference().length(namespace, localname);
    }

    public void setXPathNamespaceContext(String prefix, String uri) throws XMLSecurityException {
        this.getReference().setXPathNamespaceContext(prefix, uri);
    }

    protected Object clone() throws CloneNotSupportedException {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        try {
            return ReflectionUtil.callMethod((Object)this.getReference(), (String)"clone", (Class[])argsType, (Object[])args, (boolean)true);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CloneNotSupportedException) {
                throw (CloneNotSupportedException)cause;
            }
            throw new IllegalStateException(cause);
        }
    }

    public boolean equals(Object obj) {
        return this.getReference().equals(obj);
    }

    protected void finalize() throws Throwable {
        Class[] argsType = new Class[]{};
        Object[] args = new Object[]{};
        try {
            ReflectionUtil.callMethod((Object)this.getReference(), (String)"finalize", (Class[])argsType, (Object[])args, (boolean)true);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public int hashCode() {
        return this.getReference().hashCode();
    }

    public String toString() {
        return this.getReference().toString();
    }
}

