/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.templateengine.process;

import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.util.OSChecker;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;

public class SetDefaultExportMap
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectType = args[0].getSimpleValue();
        if ("org.tizen.nativecore.buildArtefactType.app".equals(projectType)) {
            SetDefaultExportMap.createExportMapFile(args[1].getSimpleValue(), args[2].getSimpleValue(), monitor);
        }
    }

    public static void createExportMapFile(String projectName, String exportMapFileName, IProgressMonitor monitor) throws ProcessFailureException {
        block25: {
            IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (!projectHandle.exists()) {
                throw new ProcessFailureException(String.valueOf(Messages.getString((String)"CreateSourceFolder.0")) + projectName);
            }
            IFile exportMapFile = projectHandle.getFile(exportMapFileName);
            if (exportMapFile.exists()) {
                try {
                    exportMapFile.delete(true, true, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            try {
                exportMapFile.create(null, true, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            String exportMapFilePath = exportMapFile.getLocation().toOSString();
            if (OSChecker.isWindows()) {
                String[] cmd = new String[]{"attrib", "+h", exportMapFilePath};
                Process p = null;
                try {
                    p = Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (p != null) {
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            FileWriter fw = null;
            try {
                try {
                    fw = new FileWriter(exportMapFilePath);
                    fw.write("{\n");
                    fw.write("\tglobal: main;\n");
                    fw.write("\tlocal: *;\n");
                    fw.write("};\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (fw == null) break block25;
                    try {
                        fw.close();
                        break block25;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                throw throwable;
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
        NativeCoreConfigurationManager.setExportMapFileName(exportMapFileName);
    }
}

