/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.templateengine;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.core.templateengine.process.Process;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.nativeappcommon.templateengine.TizenTemplateProcessParser;
import org.tizen.nativecommon.templateengine.TizenTemplateEngine;
import org.tizen.nativecommon.templateengine.model.TizenTemplate;
import org.tizen.nativecore.wizards.TizenCoreProjectWizard;
import org.tizen.nativecore.wizards.project.TizenNativeProjectCreator;
import org.w3c.dom.Element;

public class TizenCoreTemplateProcess
extends ProcessRunner {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String VALUESTORE_WORKSPACE_LOCATION = "location";
    public static final String VALUE_PRECOMPILE_OFF = "#include <app.h>\n#include <vconf.h>\n#include <Elementary.h>\n#include <dlog.h>";

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        ArrayList<Process> processes = new ArrayList<Process>();
        String id = null;
        List processElement = null;
        IPath samplePath = TizenTemplateProcessParser.getSelectedSampleLocationFromMainPage((String)"core");
        if (samplePath == null) {
            throw new ProcessFailureException("Failed to find a template " + samplePath);
        }
        TemplateDescriptor desc = TizenTemplateProcessParser.createTemplateDesc((File)samplePath.toFile());
        if (desc == null) {
            throw new ProcessFailureException("Failed to find a template " + samplePath);
        }
        Element root = desc.getRootElement();
        processElement = TizenTemplateProcessParser.getElementsFromTag((Element)root, (String)"process");
        int i = 0;
        for (Element element : processElement) {
            id = "No Condition--> Process " + (i + 1) + " (" + element.getAttribute("type") + ")";
            processes.add(new Process(template, element, id));
            ++i;
        }
        Map valueStore = template.getValueStore();
        String pkgName = TizenNativeProjectCreator.getPkgName();
        Boolean hasPCHOption = TizenCoreProjectWizard.hasPrecompiledHeader();
        valueStore.put("packageName", pkgName);
        valueStore.put("pcheader", hasPCHOption != false ? "#include \"tizenx.h\"" : VALUE_PRECOMPILE_OFF);
        ProfileInfo profileInfo = TizenTemplateProcessParser.getProfileInfoFromSelectedTemplate();
        if (profileInfo != null) {
            String profile = profileInfo.getProfile();
            valueStore.put("packageProfile", profile);
            valueStore.put("profile", profile);
            valueStore.put("platform", profileInfo.getLatestPlatformName());
            valueStore.put("version", profileInfo.getLatestPlatformVersion());
        }
        TizenTemplateEngine.pressCommonValueStore((Map)valueStore, (boolean)TizenCoreProjectWizard.hasPrecompiledHeader(), (TizenTemplate)TizenTemplate.EMPTY_TEMPLATE);
        ArrayList<IStatus> statuses = new ArrayList<IStatus>(processes.size());
        for (Process process : processes) {
            try {
                statuses.add(process.process(monitor));
            }
            catch (ProcessFailureException e) {
                throw new ProcessFailureException(e.getMessage(), (Throwable)e, statuses);
            }
        }
    }

    public static void pressValueStore(Map<String, String> valueStore) {
    }
}

