/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsoleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.tpklib.TPK;
import org.tizen.tpklib.exception.TPKException;
import org.tizen.tpklib.model.BuildOption;

public class TPKPackagingThread
implements Runnable {
    private TPK tpk;
    private BuildOption bOption;
    private static final Logger logger = LoggerFactory.getLogger(TPKPackagingThread.class);

    public TPKPackagingThread(TPK tpk, BuildOption bOption) {
        this.tpk = tpk;
        this.bOption = bOption;
    }

    @Override
    public void run() {
        ConsoleManager cm = new ConsoleManager("Packaging", false);
        MessageConsoleStream stdoutStream = cm.getMessageConsoleStream();
        MessageConsoleStream stderrStream = cm.getMessageConsoleStream();
        cm.clear();
        cm.show();
        stdoutStream.println("Start...");
        stdoutStream.println(String.format("< Options >\n%s", this.bOption));
        this.tpk.setOutputStream((OutputStream)stdoutStream);
        this.tpk.setErrorStream((OutputStream)stderrStream);
        try {
            this.tpk.packaging(this.bOption);
        }
        catch (ThreadDeath e) {
            logger.error("Cannot complete build packaging", (Throwable)e);
            this.handleException(e.getMessage(), cm, stdoutStream, stderrStream);
            return;
        }
        catch (TPKException e) {
            this.handleException(e.getMessage(), cm, stdoutStream, stderrStream);
            return;
        }
    }

    private void handleException(String errMsg, ConsoleManager cm, MessageConsoleStream stdoutStream, MessageConsoleStream stderrStream) {
        this.tpk.cleanAll(this.bOption.getBuildDirectory(), this.bOption.getPkgName(), this.bOption.getPkgVersion(), this.bOption.getArch());
        if (errMsg == null || errMsg.isEmpty()) {
            errMsg = "unknown error has occured";
        }
        cm.println(errMsg, 0, new Color((Device)Display.getCurrent(), 255, 0, 0));
        this.closeStream(stdoutStream, stderrStream);
    }

    public void closeStream(MessageConsoleStream stdoutStream, MessageConsoleStream stderrStream) {
        try {
            stdoutStream.close();
            stderrStream.close();
        }
        catch (IOException e) {
            logger.error("MessageConsoleStream is not closed", (Throwable)e);
        }
    }
}

