/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.MessageConsoleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.core.application.Version;
import org.tizen.common.core.command.CommandCancelException;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeappcommon.build.DevPackageManager;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.TizenNativePackageInfoStore;
import org.tizen.nativecommon.build.CommonBuildMessages;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.CommonProjectDependentPackager;
import org.tizen.nativecommon.build.NativeSigner;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecore.build.Messages;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.build.NativeIDEMultiPackager;
import org.tizen.nativecore.manifest.CoreProjectManifest;
import org.tizen.nativecore.manifest.CoreXmlStore;
import org.tizen.nativecore.util.PackageUtil;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Tool;
import org.tizen.sbilib.ide.Toolchain;
import org.tizen.tpklib.TPK;
import org.tizen.tpklib.core.sign.ISigner;
import org.tizen.tpklib.exception.TPKException;
import org.tizen.tpklib.lib.PathUtil;
import org.tizen.tpklib.model.BuildOption;

public class NativeCoreProjectDependentPackager
extends CommonProjectDependentPackager {
    private static NativeCoreProjectDependentPackager instance = new NativeCoreProjectDependentPackager();
    private static final String LLVM_BC_BUILD_XML = "bc_build_info.xml";
    private static Logger logger = LoggerFactory.getLogger(NativeCoreProjectDependentPackager.class);
    private int returnMessage;

    public static final CommonProjectDependentPackager getInstance() {
        return instance;
    }

    public static final CommonProjectDependentPackager getInstance(IProject project) {
        instance.setProject(project);
        return instance;
    }

    private NativeCoreProjectDependentPackager() {
    }

    public NativeCoreProjectDependentPackager(IProject project) {
        super(project);
    }

    public String getPackageOption(IConfiguration config, String pkgType) {
        String options;
        String targetID = this.getTargetID(config);
        String workingDir = this.getWorkingDir(config);
        IProject project = this.getProject();
        IXMLStore xmlStore = ProjectUtil.getXmlStore((IProject)project);
        String projectName = project.getName();
        String artifactName = ProjectUtil.getBinaryName((IProject)project);
        try {
            options = String.format("-BUILD_DIR=\"%s\" -ARCH=%s -PKG_TYPE=%s -PKG_NAME=%s -PRJ_NAME=%s -ARTIFACT_NAME=%s -PKG_VER=%s", new Path(workingDir).toPortableString(), this.getSbi().getRootstrapArchitecture(targetID), pkgType, xmlStore.getPkgId(), projectName, artifactName, xmlStore.getVersion());
        }
        catch (SBIException e) {
            e.printStackTrace();
            return "";
        }
        return options;
    }

    public void buildPackage(String pkgType) throws SBIException, CoreException {
        this.buildPackage(pkgType, false, true);
    }

    public void buildPackage(String pkgType, boolean signApp, boolean isLaunchMode, Thread packageThread) throws SBIException, CoreException {
        IConfiguration config = this.getCurrentConfiguration();
        this.buildPackage(config, pkgType, signApp, isLaunchMode, packageThread);
    }

    public void buildPackage(String pkgType, boolean signApp, boolean isLaunchMode) throws SBIException, CoreException {
        IConfiguration config = this.getCurrentConfiguration();
        this.buildPackage(config, pkgType, signApp, isLaunchMode);
    }

    private void buildPackage(IConfiguration config, String pkgType, boolean signApp, boolean isLaunchMode, Thread packageThread) throws SBIException, CoreException {
        if (config == null) {
            logger.error("Config is null");
            return;
        }
        this.firePreCreated(this.project, isLaunchMode);
        this.validateManifest(config);
        String workingDir = this.getWorkingDir(config);
        File file = new File(String.valueOf(workingDir) + File.separatorChar + LLVM_BC_BUILD_XML);
        if (file.exists()) {
            file.delete();
        }
        String targetID = this.getTargetID(config);
        ArrayList<String> copiedFiles = new ArrayList<String>();
        for (String devPackage : NativeCoreConfigurationManager.getDevPackageList(config)) {
            String dstFilePath;
            String baseName;
            String srcFilePath;
            for (String filePath : DevPackageManager.getExtendedSharedLibraryFileList((String)targetID, (String)devPackage)) {
                srcFilePath = String.valueOf(this.sbi.getRootstrapPath(targetID)) + filePath;
                if (System.getProperty("os.name").startsWith("Windows")) {
                    srcFilePath = this.sbi.getWindowsPathFromMinGWPath(srcFilePath);
                }
                baseName = srcFilePath.substring(srcFilePath.lastIndexOf(47) + 1);
                dstFilePath = this.project.getLocation().append("lib").append(baseName).toString();
                try {
                    FileUtil.copyTo((String)srcFilePath, (String)dstFilePath);
                    copiedFiles.add(dstFilePath);
                }
                catch (IOException e) {
                    logger.error(NLS.bind((String)Messages.NativeProjectDependentPackager_CopyFileError, (Object)srcFilePath), (Throwable)e);
                }
            }
            for (String filePath : DevPackageManager.getResourceFileList((String)targetID, (String)devPackage)) {
                srcFilePath = String.valueOf(this.sbi.getRootstrapPath(targetID)) + filePath;
                if (System.getProperty("os.name").startsWith("Windows")) {
                    srcFilePath = this.sbi.getWindowsPathFromMinGWPath(srcFilePath);
                }
                baseName = srcFilePath.substring(srcFilePath.lastIndexOf(47) + 1);
                dstFilePath = this.project.getLocation().append("res").append(baseName).toString();
                try {
                    FileUtil.copyTo((String)srcFilePath, (String)dstFilePath);
                    copiedFiles.add(dstFilePath);
                }
                catch (IOException e) {
                    logger.error(NLS.bind((String)Messages.NativeProjectDependentPackager_CopyFileError, (Object)srcFilePath), (Throwable)e);
                }
            }
        }
        ProjectUtil.generateResMetaFile((IProject)this.project);
        BuildOption bOption = this.getBuildOption(config, pkgType, signApp, targetID);
        if (packageThread != null) {
            this.buildPackage(bOption, packageThread);
        } else {
            this.buildPackage(bOption);
        }
        workingDir = new Path(workingDir).toOSString();
        for (String filePath : copiedFiles) {
            File f = new File(filePath);
            f.delete();
        }
    }

    private void buildPackage(IConfiguration config, String pkgType, boolean signApp, boolean isLaunchMode) throws SBIException, CoreException {
        this.buildPackage(config, pkgType, signApp, isLaunchMode, null);
    }

    public BuildOption getBuildOption(IConfiguration config, String pkgType, boolean signApp, String targetID) throws CoreException, SBIException {
        BuildOption bOption = new BuildOption();
        bOption.clear();
        this.setPackagingOption(bOption, config, pkgType);
        this.setSigningOption(bOption, signApp, targetID);
        this.setStripOption(bOption, config, targetID);
        this.project.getFolder(config.getName()).refreshLocal(2, null);
        ITizenProject tProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)this.project);
        Version version = new Version(tProject.getDescription().getVersion());
        if (version.isSameOrBiggerThanVersion3()) {
            bOption.setNeedEmptyDirectory(false);
        } else {
            bOption.setNeedEmptyDirectory(true);
        }
        TizenNativePackageInfoStore store = (TizenNativePackageInfoStore)tProject.getTizenPkgInfoStore();
        bOption.addIncludeMap(this.makeIncludeList(store));
        bOption.addExcludeList(this.makeExcludeList(store));
        return bOption;
    }

    private void setSigningOption(BuildOption bOption, boolean signApp, String targetID) throws CoreException, SBIException {
        NativeSigner signer = new NativeSigner(this.getDevice());
        bOption.setSign(true);
        bOption.setSigner((ISigner)signer);
    }

    private void setStripOption(BuildOption bOption, IConfiguration config, String targetId) {
        Toolchain tc;
        if (CommonConfigurationManager.isReleaseMode((IConfiguration)config)) {
            PluginManager pm = PluginManager.getInstance();
            tc = pm.getToolchainByTargetId(targetId);
            if (tc == null || tc.getStrip() == null) {
                bOption.setStrIP(false);
                bOption.setStripper(null);
                return;
            }
        } else {
            bOption.setStrIP(false);
            bOption.setStripper(null);
            return;
        }
        bOption.setStrIP(true);
        bOption.setStripper(tc.getStrip().getPath());
    }

    public void setPackagingOption(BuildOption bOption, IConfiguration config, String pkgType) {
        String targetID = this.getTargetID(config);
        String workingDir = this.getWorkingDir(config);
        IProject project = this.getProject();
        IXMLStore xmlStore = ProjectUtil.getXmlStore((IProject)project);
        String projectName = project.getName();
        String artifactName = ProjectUtil.getBinaryName((IProject)project);
        bOption.setBuildDirectory(new Path(workingDir).toOSString());
        try {
            String arch = this.getSbi().getRootstrapArchitecture(targetID);
            arch = ProjectUtil.modifyArchitecture((String)arch);
            bOption.setArch(arch);
        }
        catch (SBIException e) {
            e.printStackTrace();
            return;
        }
        bOption.setPkgName(xmlStore.getPkgId());
        bOption.setPkgType(pkgType);
        bOption.setPrjName(projectName);
        bOption.setArtifactName(artifactName);
        bOption.setPkgVersion(xmlStore.getVersion());
    }

    private void setPackageResFile() {
        org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)this.project);
        TizenPackageInfoStore store = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)this.project).getTizenPkgInfoStore();
        store.getBlackList();
        store.getPackageRes();
    }

    public String getSignerFromTargetID(String targetID) throws SBIException {
        TPK.getInstance();
        String signerPath = null;
        PluginManager pm = PluginManager.getInstance();
        Toolchain tc = pm.getToolchainByTargetId(targetID);
        if (tc == null) {
            throw new SBIException("Cannot find signer from " + targetID);
        }
        Tool signerTool = tc.getNativeSigner();
        if (signerTool == null) {
            throw new SBIException("Cannot find signer from " + targetID);
        }
        signerPath = signerTool.getPath();
        return signerPath;
    }

    public boolean buildPackage(BuildOption bOption, Thread packageThread) throws SBIException {
        TPK tpk = TPK.getInstance();
        tpk.doPerformance();
        if (this.cm == null) {
            this.cm = new ConsoleManager(Messages.PACKAGE, false);
            this.cm.clear();
            this.cm.show();
        }
        MessageConsoleStream stdoutStream = this.cm.getMessageConsoleStream();
        MessageConsoleStream stderrStream = this.cm.getMessageConsoleStream();
        stdoutStream.println(Messages.START);
        stdoutStream.println(String.format("< Options >\n%s", bOption));
        tpk.setOutputStream((OutputStream)stdoutStream);
        tpk.setErrorStream((OutputStream)stderrStream);
        if (packageThread != null) {
            try {
                packageThread.start();
            }
            catch (OperationCanceledException e) {
                logger.error("Packaging is cancelled.", (Throwable)e);
                return false;
            }
            try {
                packageThread.join();
            }
            catch (InterruptedException e) {
                String errMsg = e.getMessage();
                if (errMsg == null || errMsg.isEmpty()) {
                    errMsg = "unknown error has occured";
                }
                if (this.cm != null) {
                    this.cm.println("Packaging failed", 0, new Color((Device)Display.getCurrent(), 255, 0, 0));
                    this.cm.println("");
                    this.cm.println(" " + errMsg, 0, new Color((Device)Display.getCurrent(), 255, 0, 0));
                }
                throw new SBIException(Messages.FAILED_TO_PACKAGE);
            }
            return true;
        }
        try {
            tpk.packaging(bOption);
        }
        catch (TPKException e) {
            String errMsg = e.getMessage();
            if (errMsg == null || errMsg.isEmpty()) {
                errMsg = "unknown error has occured";
            }
            if (this.cm != null) {
                this.cm.println("Packaging failed", 0, new Color((Device)Display.getCurrent(), 255, 0, 0));
                this.cm.println("");
                this.cm.println(" " + errMsg, 0, new Color((Device)Display.getCurrent(), 255, 0, 0));
            }
            throw new SBIException(Messages.FAILED_TO_PACKAGE);
        }
        return true;
    }

    public boolean buildPackage(BuildOption bOption) throws SBIException {
        return this.buildPackage(bOption, null);
    }

    private String getCommandLineArgForPassword(String arg) {
        String result = "";
        int i = 0;
        while (i < arg.length()) {
            char c = arg.charAt(i);
            result = c == '\\' ? String.valueOf(result) + "\\:5C\\:5C" : (c == '\"' ? String.valueOf(result) + "\\:5C\\:22" : String.valueOf(result) + c);
            ++i;
        }
        return result;
    }

    public void buildPackage(String configName, String pkgType) throws SBIException, CoreException {
        IConfiguration[] configurations = ManagedBuildManager.getBuildInfo((IResource)this.project).getManagedProject().getConfigurations();
        IConfiguration config = null;
        IConfiguration[] iConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration c = iConfigurationArray[n2];
            if (c.getName().equals(configName)) {
                config = c;
                break;
            }
            ++n2;
        }
        this.buildPackage(config, pkgType);
    }

    private void buildPackage(IConfiguration config, String pkgType) throws SBIException, CoreException {
        this.buildPackage(config, pkgType, false, true, null);
    }

    private void validateManifest(IConfiguration config) throws CoreException {
        IProject[] refPrjs = PackageUtil.getRefProjects(this.getProject());
        if (refPrjs != null && refPrjs.length > 0) {
            IProject[] iProjectArray = refPrjs;
            int n = refPrjs.length;
            int n2 = 0;
            while (n2 < n) {
                IProject refProject = iProjectArray[n2];
                this.validateExecutableFile(refProject);
                ++n2;
            }
        }
        NativeCoreProjectDependentPackager.validateSettingFile(this.project);
    }

    public static void validateSettingFile(IProject project) throws CoreException {
        String settingDirectory = String.valueOf(project.getLocation().toString()) + "/setting";
        String settingFileFormat = String.valueOf(settingDirectory) + "/setting.%s.xml";
        if (!new File(settingDirectory).exists()) {
            return;
        }
        IXMLStore xmlStore = ProjectUtil.getXmlStore((IProject)project);
        String version = xmlStore.getVersion();
        String settingFilePath = String.format(settingFileFormat, version);
        File settingFile = new File(settingFilePath);
        if (!settingFile.exists()) {
            String exeFileErrorStr = String.valueOf(NLS.bind((String)Messages.NativeProjectDependentPackager_ValidatingSettingFileError, (Object)settingFile.getName())) + CommonBuildMessages.FAIL_TO_BUILD_PACKAGE;
            throw new CoreException((IStatus)new Status(4, "org.tizen.nativecore", exeFileErrorStr));
        }
    }

    private void validateIconFile(IProject project) throws CoreException {
        CoreProjectManifest projectManifest = new CoreProjectManifest(project);
        projectManifest.loadManifestfile();
        if (projectManifest.getNativeProjectType() == null || !projectManifest.getNativeProjectType().isNeededIconValidation()) {
            return;
        }
        List<String> iconList = projectManifest.getProjectIconFiles();
        File iconFile = null;
        String iconFileErrorStr = NLS.bind((String)Messages.NativeProjectDependentPackager_ValidatingIconError, (Object)("'" + TizenPlatformConstants.APP_ICON_INSTALL_PATH + "'"));
        if (iconList.isEmpty()) {
            this.openIconValidateDiagog(iconFileErrorStr);
            return;
        }
        for (String icon : iconList) {
            if (icon.isEmpty() || (iconFile = new File(String.format(CoreProjectManifest.C_ICON_PATH, project.getLocation().toOSString(), icon))).exists()) continue;
            this.openIconValidateDiagog(iconFileErrorStr);
        }
    }

    private void openIconValidateDiagog(final String iconFileErrorStr) throws CoreException {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Shell shell = SWTUtil.getShell();
                MessageBox messageBox = new MessageBox(shell, 200);
                messageBox.setText("Build Package");
                messageBox.setMessage(iconFileErrorStr);
                NativeCoreProjectDependentPackager.this.returnMessage = messageBox.open();
            }
        });
        if (this.returnMessage == 128) {
            throw new CoreException((IStatus)new Status(8, "org.tizen.nativecore", CommonBuildMessages.FAIL_TO_BUILD_PACKAGE));
        }
    }

    private void validateExecutableFile(IProject project, IConfiguration config) throws CoreException {
        if (config == null) {
            config = ProjectUtil.getDefaultConfiguration((IProject)project);
        }
        CoreProjectManifest projectManifest = new CoreProjectManifest(project);
        projectManifest.loadManifestfile();
        List<String> executableList = projectManifest.getExecutableNames();
        for (String executable : executableList) {
            if (project.getFile(String.valueOf(config.getName()) + "/" + executable).exists()) continue;
            String exeFileErrorStr = String.valueOf(NLS.bind((String)Messages.NativeProjectDependentPackager_ValidatingExecutableError, (Object)executable)) + CommonBuildMessages.FAIL_TO_BUILD_PACKAGE;
            throw new CoreException((IStatus)new Status(4, "org.tizen.nativecore", exeFileErrorStr));
        }
    }

    private void validateExecutableFile(IProject project) throws CoreException {
        this.validateExecutableFile(project, null);
    }

    public void doMultiAppPreProcess(IProgressMonitor monitor) {
        NativeIDEMultiPackager multiPackager = new NativeIDEMultiPackager(this.getProject(), monitor, CommonPlugin.getDefault().getExecutor());
        try {
            multiPackager.doMultiPreProcess();
        }
        catch (OperationCanceledException e) {
            multiPackager.removeMutilAppResources();
            logger.error(NLS.bind((String)Messages.NativeProjectDependentPackager_MultipackCancel, (Object)this.getProject().getName()), (Throwable)e);
            throw e;
        }
        catch (CommandCancelException e) {
            multiPackager.removeMutilAppResources();
            logger.error(NLS.bind((String)Messages.NativeProjectDependentPackager_MultipackCommandCancel, (Object)this.getProject().getName()), (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            multiPackager.removeMutilAppResources();
            logger.error(NLS.bind((String)Messages.NativeProjectDependentPackager_MultipackIllegalArgumentError, (Object)this.getProject().getName()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            multiPackager.removeMutilAppResources();
            logger.error(NLS.bind((String)Messages.NativeProjectDependentPackager_MultipackError, (Object)this.getProject().getName()), (Throwable)e);
        }
    }

    public boolean checkPackageFile(String pkgType) {
        final String pkgExt = "." + pkgType.toLowerCase();
        IConfiguration configuration = ManagedBuildManager.getBuildInfo((IResource)this.project).getDefaultConfiguration();
        String packageDirectory = String.valueOf(File.separatorChar) + configuration.toString() + File.separatorChar;
        Path debPath = new Path(String.valueOf(this.project.getLocation().toString()) + packageDirectory);
        File file = new File(debPath.toString());
        String[] list = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(pkgExt);
            }
        });
        if (list == null) {
            return false;
        }
        IXMLStore xmlStore = ProjectUtil.getXmlStore((IProject)this.project);
        String pkgFilePrefix = "";
        pkgFilePrefix = "DEB".equals(pkgType) ? String.valueOf(xmlStore.getPkgId()) + "_" + xmlStore.getVersion() + "_" : ("RPM".equals(pkgType) ? String.valueOf(xmlStore.getPkgId()) + "-" + xmlStore.getVersion() + "-1." : ProjectUtil.getPackageFileName((IProject)this.project, (String)"TPK".toLowerCase()));
        pkgFilePrefix = ProjectUtil.modifyArchitecture((String)pkgFilePrefix);
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            if (l.startsWith(pkgFilePrefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getTargetID(IConfiguration config) {
        return NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
    }

    public boolean isDependencyCheckSuppoted() {
        return false;
    }

    protected String getPackageDependencyCheckOption() {
        return null;
    }

    public boolean isPackageCheckSuppoted() {
        return true;
    }

    public void buildPackage(String configName, String pkgType, boolean signApp) throws SBIException, CoreException {
        IConfiguration[] configurations = ManagedBuildManager.getBuildInfo((IResource)this.project).getManagedProject().getConfigurations();
        IConfiguration config = null;
        IConfiguration[] iConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration c = iConfigurationArray[n2];
            if (c.getName().equals(configName)) {
                config = c;
                break;
            }
            ++n2;
        }
        this.buildPackage(config, pkgType, signApp, true, null);
    }

    public List<String> makeExcludeList(TizenNativePackageInfoStore store) {
        String projectPath = this.project.getLocation().toString();
        ArrayList<String> excludeList = new ArrayList<String>();
        Map includeMap = store.getOriginIncludeMap();
        Set includeSet = includeMap.keySet();
        for (String include : includeSet) {
            IResource res = this.project.findMember(include.substring(projectPath.length()));
            if (res != null && res.exists()) continue;
            try {
                excludeList.add(new File(include).getCanonicalPath());
            }
            catch (IOException e) {
                logger.error("Cannot add exclude list.", (Throwable)e);
            }
        }
        if (PackageUtil.getRefProjects(this.project).length > 0) {
            excludeList.add(CoreXmlStore.MANIFEST_FILE);
        }
        return excludeList;
    }

    private Map<String, String> makeIncludeList(TizenNativePackageInfoStore store) {
        Map includeList = store.getIncludeMap();
        if (ProjectUtil.getTizenProjectType((IProject)this.project).isImeProject()) {
            includeList.putAll(store.getOriginIncludeMap());
        }
        if (PackageUtil.getRefProjects(this.project).length > 0) {
            includeList.put(PathUtil.addPath((String[])new String[]{ProjectUtil.getDefaultConfiguration((IProject)this.project).getName(), ".packaging"}), ".");
            includeList.put(PathUtil.addPath((String[])new String[]{ProjectUtil.getDefaultConfiguration((IProject)this.project).getName(), "manifest_multi.xml"}), CoreXmlStore.MANIFEST_FILE);
        }
        return includeList;
    }
}

