/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildfileMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.nativecore.cli.SetterUtil;
import org.tizen.nativecore.cli.model.EDCFlagModel;
import org.tizen.nativecore.cli.model.FlagsFile;
import org.tizen.nativecore.cli.model.ProjectDefFile;

public class ToolFlagSetter {
    private IProject project;
    private IConfiguration config;
    private List<IPath> sources;
    private Map<ITool, IPath[]> toolInfo = new HashMap<ITool, IPath[]>();
    private Map<ITool, List<String>> edcToolInfo = new HashMap<ITool, List<String>>();
    private boolean isSetDebugDefine = false;
    private static final String DEBUG_DEFINE = "-D_DEBUG";
    private static final String EMPTY_STRING = "";
    private static final String WHITESPACE = " ";
    private static final String DEF_DEBUG_OP = "$(DEBUG_OP)";
    private static final String DEF_OPTIMIZE_OP = "$(OPTIMIZATION_OP)";
    private static final String DEF_CPP_DEBUG_OP = "$(CPP_DEBUG_OP)";
    private static final String DEF_CPP_OPTIMIZE_OP = "$(CPP_OPTIMIZATION_OP)";
    private static final String LINK_OP = "-l";
    private static final String AR_OP = "-r";

    public ToolFlagSetter(IConfiguration config, List<IPath> sources) {
        this.project = (IProject)config.getOwner();
        this.config = config;
        this.sources = sources;
        this.setTools();
        this.setEDCTools();
    }

    public void setProjectDefinition(ProjectDefFile projDef) {
        this.setCIncludePath(projDef);
        this.setCIncludeFiles(projDef);
        this.setCppIncludePath(projDef);
        this.setCppIncludeFiles(projDef);
        this.setCDefines(projDef);
        this.setCUndefines(projDef);
        this.setCppDefines(projDef);
        this.setCppUndefines(projDef);
        this.setLibraryPath(projDef);
        this.setEDCCompileFlags(projDef);
        this.setUserLibs(projDef);
        this.setUserObjs(projDef);
    }

    public void setToolFlags(FlagsFile toolFlags) {
        this.setCompileDebugFlag(toolFlags);
        this.setCppCompileDebugFlag(toolFlags);
        this.setCompileOptimizeFlag(toolFlags);
        this.setCppCompileOptimizeFlag(toolFlags);
        this.setCompileFlags(toolFlags);
        this.setCppCompileFlags(toolFlags);
        this.setLinkFlags(toolFlags);
        this.setArchiveFlags(toolFlags);
    }

    public void setEDCFlags(ProjectDefFile projDef) {
        Set<ITool> tools = this.edcToolInfo.keySet();
        int i = 0;
        for (ITool tool : tools) {
            String path;
            if (!tool.getId().startsWith("org.tizen.nativecore.tool.sbi.edc.compiler")) continue;
            List<String> srcs = this.edcToolInfo.get(tool);
            List<String> idFlags = this.getFlagsWithToolId(tool.getId(), "sbi.gnu.edc.compiler.option.misc.id");
            List<String> sdFlags = this.getFlagsWithToolId(tool.getId(), "sbi.gnu.edc.compiler.option.misc.sd");
            List<String> fdFlags = this.getFlagsWithToolId(tool.getId(), "sbi.gnu.edc.compiler.option.misc.fd");
            EDCFlagModel edcFlags = new EDCFlagModel(srcs);
            for (String flag : idFlags) {
                path = flag.trim();
                if ((path = SetterUtil.isUnderProjectPath(this.project, path = SetterUtil.removeQuotes(path)) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) continue;
                edcFlags.addRelIDPath(path);
            }
            for (String flag : sdFlags) {
                path = flag.trim();
                if ((path = SetterUtil.isUnderProjectPath(this.project, path = SetterUtil.removeQuotes(path)) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) continue;
                edcFlags.addRelSDPath(path);
            }
            for (String flag : fdFlags) {
                path = flag.trim();
                if ((path = SetterUtil.isUnderProjectPath(this.project, path = SetterUtil.removeQuotes(path)) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) continue;
                edcFlags.addRelFDPath(path);
            }
            String key = "EDC" + String.valueOf(i);
            edcFlags.setKey(key);
            projDef.addEDCFlag(edcFlags);
            ++i;
        }
    }

    private void setEDCTools() {
        for (IPath inputPath : this.sources) {
            if (!inputPath.getFileExtension().equals("edc")) continue;
            IResourceInfo rcInfo = this.config.getResourceInfo(inputPath, false);
            ITool tool = null;
            if (rcInfo instanceof IFileInfo) {
                IFileInfo fi = (IFileInfo)rcInfo;
                ITool[] tools = fi.getToolsToInvoke();
                if (tools != null && tools.length > 0) {
                    tool = tools[0];
                }
            } else {
                IFolderInfo foInfo = (IFolderInfo)rcInfo;
                tool = foInfo.getToolFromInputExtension(inputPath.getFileExtension());
            }
            if (!this.edcToolInfo.containsKey(tool)) {
                ArrayList<String> sources = new ArrayList<String>();
                sources.add(inputPath.toString());
                this.edcToolInfo.put(tool, sources);
                continue;
            }
            this.edcToolInfo.get(tool).add(inputPath.toString());
        }
    }

    private void setTools() {
        for (IPath inputPath : this.sources) {
            IResourceInfo rcInfo = this.config.getResourceInfo(inputPath, false);
            ITool tool = null;
            if (rcInfo instanceof IFileInfo) {
                IFileInfo fi = (IFileInfo)rcInfo;
                ITool[] tools = fi.getToolsToInvoke();
                if (tools != null && tools.length > 0) {
                    tool = tools[0];
                }
            } else {
                IFolderInfo foInfo = (IFolderInfo)rcInfo;
                tool = foInfo.getToolFromInputExtension(inputPath.getFileExtension());
            }
            if (tool == null || this.toolInfo.containsKey(tool)) continue;
            String inputExt = inputPath.getFileExtension();
            String outputExt = tool.getOutputExtension(inputExt);
            IPath outputPath = inputPath.removeFileExtension().addFileExtension(outputExt);
            IPath[] value = new IPath[]{inputPath, outputPath};
            this.toolInfo.put(tool, value);
        }
        ITool cppLinkerTool = this.config.getToolsBySuperClassId("org.tizen.nativecore.tool.sbi.gnu.cpp.linker")[0];
        IPath[] value = new IPath[2];
        this.toolInfo.put(cppLinkerTool, value);
        ITool archiveTool = this.config.getToolsBySuperClassId("org.tizen.nativecore.tool.sbi.gnu.archiver")[0];
        this.toolInfo.put(archiveTool, value);
    }

    private void setCompileDebugFlag(FlagsFile toolFlags) {
        List<String> flags = this.getFlagsWithToolBaseId("org.tizen.nativecore.tool.sbi.gnu.c.compiler", "sbi.gnu.c.compiler.option.debugging.level.core");
        if (this.isSetDebugDefine) {
            flags.add(DEBUG_DEFINE);
        }
        if (flags.size() > 0) {
            toolFlags.setComplieDebugFlag(flags.toArray(new String[0]));
        }
    }

    private void setCppCompileDebugFlag(FlagsFile toolFlags) {
        List<String> flags = this.getFlagsWithToolBaseId("org.tizen.nativecore.tool.sbi.gnu.cpp.compiler", "sbi.gnu.cpp.compiler.option.debugging.level.core");
        if (this.isSetDebugDefine) {
            flags.add(DEBUG_DEFINE);
        }
        if (flags.size() > 0) {
            toolFlags.setCppComplieDebugFlag(flags.toArray(new String[0]));
        }
    }

    private void setCompileOptimizeFlag(FlagsFile toolFlags) {
        List<String> flags = this.getFlagsWithToolBaseId("org.tizen.nativecore.tool.sbi.gnu.c.compiler", "gnu.c.compiler.option.optimization.level");
        if (flags.size() > 0) {
            toolFlags.setComplieOptimizeFlag(flags.toArray(new String[0]));
        }
    }

    private void setCppCompileOptimizeFlag(FlagsFile toolFlags) {
        List<String> flags = this.getFlagsWithToolBaseId("org.tizen.nativecore.tool.sbi.gnu.cpp.compiler", "gnu.cpp.compiler.option.optimization.level");
        if (flags.size() > 0) {
            toolFlags.setCppComplieOptimizeFlag(flags.toArray(new String[0]));
        }
    }

    private void setCompileFlags(FlagsFile toolFlags) {
        HashSet<String> exceptOptions = new HashSet<String>();
        exceptOptions.add("gnu.c.compiler.option.include.paths");
        exceptOptions.add("gnu.c.compiler.option.include.files");
        exceptOptions.add("gnu.c.compiler.option.preprocessor.def.symbols");
        exceptOptions.add("gnu.c.compiler.option.preprocessor.undef.symbol");
        exceptOptions.add("sbi.gnu.c.compiler.option.preprocessor.def.symbols.deprecation");
        exceptOptions.add("sbi.gnu.c.compiler.option");
        exceptOptions.add("sbi.gnu.c.compiler.option.frameworks.core");
        exceptOptions.add("sbi.gnu.c.compiler.option.frameworks_cflags.core");
        exceptOptions.add("sbi.gnu.c.compiler.option.frameworks_inc.core");
        exceptOptions.add("sbi.gnu.c.compiler.option.dynamicanalysis.core");
        exceptOptions.add("sbi.gnu.c.compiler.option.dynamicanalysis_flags.core");
        exceptOptions.add("sbi.gnu.c.compiler.option.wi.app.core");
        exceptOptions.add("gnu.c.compiler.option.optimization.level");
        exceptOptions.add("sbi.gnu.c.compiler.option.debugging.level.core");
        List<String> flags = this.getAllFlags("org.tizen.nativecore.tool.sbi.gnu.c.compiler", exceptOptions);
        flags.add(0, DEF_DEBUG_OP);
        flags.add(1, DEF_OPTIMIZE_OP);
        toolFlags.setCompileFlags(flags.toArray(new String[0]));
    }

    private void setCppCompileFlags(FlagsFile toolFlags) {
        HashSet<String> exceptOptions = new HashSet<String>();
        exceptOptions.add("gnu.cpp.compiler.option.include.paths");
        exceptOptions.add("gnu.cpp.compiler.option.include.files");
        exceptOptions.add("gnu.cpp.compiler.option.preprocessor.def");
        exceptOptions.add("gnu.cpp.compiler.option.preprocessor.undef");
        exceptOptions.add("sbi.gnu.cpp.compiler.option.preprocessor.def.deprecation");
        exceptOptions.add("sbi.gnu.cpp.compiler.option");
        exceptOptions.add("sbi.gnu.cpp.compiler.option.frameworks.core");
        exceptOptions.add("sbi.gnu.cpp.compiler.option.frameworks_cflags.core");
        exceptOptions.add("sbi.gnu.cpp.compiler.option.frameworks_inc.core");
        exceptOptions.add("sbi.gnu.cpp.compiler.option.dynamicanalysis.core");
        exceptOptions.add("sbi.gnu.cpp.compiler.option.dynamicanalysis_flags.core");
        exceptOptions.add("sbi.gnu.cpp.compiler.option.wi.app.core");
        exceptOptions.add("gnu.cpp.compiler.option.optimization.level");
        exceptOptions.add("sbi.gnu.cpp.compiler.option.debugging.level.core");
        List<String> flags = this.getAllFlags("org.tizen.nativecore.tool.sbi.gnu.cpp.compiler", exceptOptions);
        flags.add(0, DEF_CPP_DEBUG_OP);
        flags.add(1, DEF_CPP_OPTIMIZE_OP);
        toolFlags.setCppCompileFlags(flags.toArray(new String[0]));
    }

    private void setLinkFlags(FlagsFile toolFlags) {
        HashSet<String> exceptOptions = new HashSet<String>();
        exceptOptions.add("gnu.cpp.link.option.paths");
        exceptOptions.add("gnu.cpp.link.option.libs");
        exceptOptions.add("gnu.cpp.link.option.userobjs");
        exceptOptions.add("sbi.gnu.cpp.linker.option.frameworks_lflags.core");
        exceptOptions.add("sbi.gnu.cpp.linker.option.dynamicanalysis_flags.core");
        exceptOptions.add("sbi.gnu.cpp.linker.option.app_flag.core");
        List<String> flags = this.getAllFlags("org.tizen.nativecore.tool.sbi.gnu.cpp.linker", exceptOptions);
        toolFlags.setLinkFlags(flags.toArray(new String[0]));
    }

    private void setEDCCompileFlags(ProjectDefFile projDef) {
        String path;
        List<String> idFlags = this.getFlagsWithToolBaseId("org.tizen.nativecore.tool.sbi.edc.compiler", "sbi.gnu.edc.compiler.option.misc.id");
        List<String> sdFlags = this.getFlagsWithToolBaseId("org.tizen.nativecore.tool.sbi.edc.compiler", "sbi.gnu.edc.compiler.option.misc.sd");
        List<String> fdFlags = this.getFlagsWithToolBaseId("org.tizen.nativecore.tool.sbi.edc.compiler", "sbi.gnu.edc.compiler.option.misc.fd");
        for (String flag : idFlags) {
            path = flag.trim();
            if ((path = SetterUtil.isUnderProjectPath(this.project, path = SetterUtil.removeQuotes(path)) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) continue;
            projDef.addRelativeEdcIdPath(path);
        }
        for (String flag : sdFlags) {
            path = flag.trim();
            if ((path = SetterUtil.isUnderProjectPath(this.project, path = SetterUtil.removeQuotes(path)) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) continue;
            projDef.addRelativeEdcSdPath(path);
        }
        for (String flag : fdFlags) {
            path = flag.trim();
            if ((path = SetterUtil.isUnderProjectPath(this.project, path = SetterUtil.removeQuotes(path)) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) continue;
            projDef.addRelativeEdcFdPath(path);
        }
    }

    private void setArchiveFlags(FlagsFile toolFlags) {
        HashSet<String> exceptOptions = new HashSet<String>();
        List<String> flags = this.getAllFlags("org.tizen.nativecore.tool.sbi.gnu.archiver", exceptOptions);
        ArrayList<String> newFlags = new ArrayList<String>();
        String sFlags = flags.get(0);
        String[] stringArray = sFlags.split(WHITESPACE);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String flag = stringArray[n2];
            if (!flag.equals(AR_OP)) {
                newFlags.add(flag);
            }
            ++n2;
        }
        toolFlags.setArFlags(newFlags.toArray(new String[0]));
    }

    private void setIncludePath(String toolId, String optionId, List<String> relList) {
        List<String> values = this.getFlagsWithToolBaseId(toolId, optionId);
        for (String value : values) {
            String path = value.trim();
            if ((path = SetterUtil.removeQuotes(path)).isEmpty()) continue;
            if (new Path(path).isAbsolute()) {
                if ((path = SetterUtil.isUnderProjectPath(this.project, path) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) continue;
                relList.add(path);
                continue;
            }
            relList.add(SetterUtil.encloseDoubleQuotes(path));
        }
    }

    private void setCIncludePath(ProjectDefFile projDef) {
        this.setIncludePath("org.tizen.nativecore.tool.sbi.gnu.c.compiler", "gnu.c.compiler.option.include.paths", projDef.getRelativeCIncPath());
    }

    private void setCppIncludePath(ProjectDefFile projDef) {
        this.setIncludePath("org.tizen.nativecore.tool.sbi.gnu.cpp.compiler", "gnu.cpp.compiler.option.include.paths", projDef.getRelativeCppIncPath());
    }

    private void setCIncludeFiles(ProjectDefFile projDef) {
        this.setIncludePath("org.tizen.nativecore.tool.sbi.gnu.c.compiler", "gnu.c.compiler.option.include.files", projDef.getRelativeCIncFile());
    }

    private void setCppIncludeFiles(ProjectDefFile projDef) {
        this.setIncludePath("org.tizen.nativecore.tool.sbi.gnu.cpp.compiler", "gnu.cpp.compiler.option.include.files", projDef.getRelativeCppIncFile());
    }

    private void setDefines(String toolId, String optionId, List<String> list) {
        List<String> values = this.getFlagsWithToolBaseId(toolId, optionId);
        for (String value : values) {
            if (value.equals("_DEBUG")) {
                this.isSetDebugDefine = true;
                continue;
            }
            list.add(value);
        }
    }

    private void setUndefines(String toolId, String optionId, List<String> list) {
        List<String> values = this.getFlagsWithToolBaseId(toolId, optionId);
        for (String value : values) {
            list.add(value);
        }
    }

    private void setCDefines(ProjectDefFile projDef) {
        this.setDefines("org.tizen.nativecore.tool.sbi.gnu.c.compiler", "gnu.c.compiler.option.preprocessor.def.symbols", projDef.getCDefines());
    }

    private void setCUndefines(ProjectDefFile projDef) {
        this.setUndefines("org.tizen.nativecore.tool.sbi.gnu.c.compiler", "gnu.c.compiler.option.preprocessor.undef.symbol", projDef.getCUndefines());
    }

    private void setCppDefines(ProjectDefFile projDef) {
        this.setDefines("org.tizen.nativecore.tool.sbi.gnu.cpp.compiler", "gnu.cpp.compiler.option.preprocessor.def", projDef.getCppDefines());
    }

    private void setCppUndefines(ProjectDefFile projDef) {
        this.setUndefines("org.tizen.nativecore.tool.sbi.gnu.cpp.compiler", "gnu.cpp.compiler.option.preprocessor.undef", projDef.getCppUndefines());
    }

    private void setLibraryPath(ProjectDefFile projDef) {
        List<String> values = this.getFlagsWithToolBaseId("org.tizen.nativecore.tool.sbi.gnu.cpp.linker", "gnu.cpp.link.option.paths");
        for (String value : values) {
            String path = value.trim();
            if ((path = SetterUtil.removeQuotes(path)).isEmpty()) continue;
            if (new Path(path).isAbsolute()) {
                if ((path = SetterUtil.isUnderProjectPath(this.project, path) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) continue;
                projDef.addRelativeLibPath(path);
                continue;
            }
            projDef.addRelativeLibPath(SetterUtil.encloseDoubleQuotes(path));
        }
    }

    private void setUserLibs(ProjectDefFile projDef) {
        String[] values;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.project);
        String buildTargetExt = info.getBuildArtifactExtension();
        String[] stringArray = values = this.config.getLibs(buildTargetExt);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value.startsWith(LINK_OP)) {
                value = value.substring(2);
            }
            projDef.addUserLib(value);
            ++n2;
        }
    }

    private void setUserObjs(ProjectDefFile projDef) {
        String[] values;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.project);
        String buildTargetExt = info.getBuildArtifactExtension();
        String[] stringArray = values = this.config.getUserObjects(buildTargetExt);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            String path = value.trim();
            if (!(path = SetterUtil.removeQuotes(path)).isEmpty()) {
                if (new Path(path).isAbsolute()) {
                    if (!(path = SetterUtil.isUnderProjectPath(this.project, path) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) {
                        projDef.addRelativeUserObj(path);
                    }
                } else {
                    projDef.addRelativeUserObj(SetterUtil.encloseDoubleQuotes(path));
                }
            }
            ++n2;
        }
    }

    private List<String> getAllFlags(String toolId, Set<String> exceptOptions) {
        ITool tool = null;
        for (ITool t : this.toolInfo.keySet()) {
            if (!t.getBaseId().equals(toolId)) continue;
            tool = t;
            break;
        }
        if (tool == null) {
            return new ArrayList<String>();
        }
        IOption[] ops = tool.getOptions();
        IPath[] files = this.toolInfo.get(tool);
        ArrayList<String> flags = new ArrayList<String>();
        try {
            IOption[] iOptionArray = ops;
            int n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                IOption op = iOptionArray[n2];
                List<String> result = null;
                if (!exceptOptions.contains(op.getBaseId())) {
                    result = this.parseToolFlags(tool, op, files[0], files[1]);
                }
                if (result != null && !result.isEmpty()) {
                    flags.addAll((Collection<String>)result);
                }
                ++n2;
            }
        }
        catch (CdtVariableException e) {
            e.printStackTrace();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return flags;
    }

    private List<String> getFlagsWithToolId(String toolId, String optionId) {
        ITool tool = null;
        for (ITool t : this.toolInfo.keySet()) {
            if (!t.getId().equals(toolId)) continue;
            tool = t;
            break;
        }
        if (tool == null) {
            return new ArrayList<String>();
        }
        IOption op = tool.getOptionBySuperClassId(optionId);
        IPath[] files = this.toolInfo.get(tool);
        List<String> result = null;
        try {
            result = this.parseToolFlags(tool, op, files[0], files[1]);
        }
        catch (CdtVariableException e) {
            e.printStackTrace();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<String> getFlagsWithToolBaseId(String toolId, String optionId) {
        ITool tool = null;
        for (ITool t : this.toolInfo.keySet()) {
            if (!t.getBaseId().equals(toolId)) continue;
            tool = t;
            break;
        }
        if (tool == null) {
            return new ArrayList<String>();
        }
        IOption op = tool.getOptionBySuperClassId(optionId);
        IPath[] files = this.toolInfo.get(tool);
        List<String> result = null;
        try {
            result = this.parseToolFlags(tool, op, files[0], files[1]);
        }
        catch (CdtVariableException e) {
            e.printStackTrace();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<String> parseToolFlags(ITool tool, IOption option, IPath inputLocation, IPath outputLocation) throws BuildException, CdtVariableException {
        ArrayList<String> flags = new ArrayList<String>();
        new StringBuilder();
        BuildMacroProvider provider = BuildMacroProvider.getDefault();
        BuildfileMacroSubstitutor macroSubstitutor = new BuildfileMacroSubstitutor(null, EMPTY_STRING, WHITESPACE);
        switch (option.getValueType()) {
            case 0: {
                String boolCmd = option.getBooleanValue() ? option.getCommand() : option.getCommandFalse();
                if (boolCmd == null || boolCmd.length() <= 0) break;
                flags.add(boolCmd);
                break;
            }
            case 1: {
                String enumVal = option.getEnumCommand(option.getSelectedEnum());
                if (enumVal.length() <= 0) break;
                flags.add(enumVal);
                break;
            }
            case 2: {
                String val = option.getStringValue();
                IMacroContextInfo info = provider.getMacroContextInfo(1, (Object)new FileContextData(inputLocation, outputLocation, option, (IBuildObject)tool));
                if (info == null) break;
                macroSubstitutor.setMacroContextInfo((IVariableContextInfo)info);
                val = val.trim();
                if (val.length() <= 0 || (val = CdtVariableResolver.resolveToString((String)val, (IVariableSubstitutor)macroSubstitutor)).length() <= 0) break;
                if (option.getBaseId().equals("gnu.cpp.link.option.soname") || option.getBaseId().equals("gnu.cpp.link.option.defname") || option.getBaseId().equals("gnu.cpp.link.option.implname")) {
                    flags.add(this.evaluateCommand(option.getCommand(), val));
                    break;
                }
                flags.add(val);
                break;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -4: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                IMacroContextInfo info = provider.getMacroContextInfo(1, (Object)new FileContextData(inputLocation, outputLocation, option, (IBuildObject)tool));
                if (info == null) break;
                macroSubstitutor.setMacroContextInfo((IVariableContextInfo)info);
                String[] list = CdtVariableResolver.resolveStringListValues((String[])option.getBasicStringListValue(), (IVariableSubstitutor)macroSubstitutor, (boolean)true);
                if (list == null) break;
                String[] stringArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    if ((temp = temp.trim()).length() > 0 && !temp.equals("\"\"") && temp.startsWith("\"") && temp.endsWith("\"")) {
                        temp = temp.substring(1, temp.length() - 1);
                    }
                    if (option.getBaseId().equals("gnu.cpp.link.option.other")) {
                        flags.add(this.evaluateCommand(option.getCommand(), temp));
                    } else {
                        flags.add(temp);
                    }
                    ++n2;
                }
                break;
            }
            case -5: 
            case 5: {
                IMacroContextInfo info = provider.getMacroContextInfo(1, (Object)new FileContextData(inputLocation, outputLocation, option, (IBuildObject)tool));
                if (info == null) break;
                macroSubstitutor.setMacroContextInfo((IVariableContextInfo)info);
                String[] symbols = CdtVariableResolver.resolveStringListValues((String[])option.getBasicStringListValue(), (IVariableSubstitutor)macroSubstitutor, (boolean)true);
                if (symbols == null) break;
                String[] stringArray = symbols;
                int n = symbols.length;
                int n3 = 0;
                while (n3 < n) {
                    String temp = stringArray[n3];
                    if ((temp = temp.trim()).length() > 0) {
                        flags.add(temp);
                    }
                    ++n3;
                }
                break;
            }
        }
        return flags;
    }

    public String evaluateCommand(String command, String values) {
        int len;
        int index;
        if (command == null) {
            return values.trim();
        }
        String ret = command;
        boolean found = false;
        int start = 0;
        while ((index = ret.indexOf("${", start)) >= 0 && (len = ret.length()) >= index + 8) {
            start = index;
            char ch = ret.charAt(index += 2);
            if (!(ch != 'v' && ch != 'V' || (ch = ret.charAt(++index)) != 'a' && ch != 'A' || (ch = ret.charAt(++index)) != 'l' && ch != 'L' || (ch = ret.charAt(++index)) != 'u' && ch != 'U' || (ch = ret.charAt(++index)) != 'e' && ch != 'E' || (ch = ret.charAt(++index)) != '}')) {
                String temp = EMPTY_STRING;
                ++index;
                found = true;
                if (start > 0) {
                    temp = ret.substring(0, start);
                }
                temp = temp.concat(values.trim());
                if (len > index) {
                    start = temp.length();
                    ret = temp.concat(ret.substring(index));
                    index = start;
                } else {
                    ret = temp;
                    break;
                }
            }
            start = index;
        }
        if (found) {
            return ret.trim();
        }
        return new String(String.valueOf(command) + values).trim();
    }
}

