/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.wizards;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeappcommon.wizards.NewProjectChecker;
import org.tizen.nativeappcommon.wizards.TizenMainWizardPage;
import org.tizen.nativeappcommon.wizards.WizardConstants;
import org.tizen.nativecore.wizards.Messages;

public class NewCoreProjectChecker
extends NewProjectChecker {
    private Text pkgNameField;
    private boolean isDirtyPkgName = false;
    private static final String PKGNAME_PREFIX = "org.tizen.";
    private static final String NAME_PATTERN = "^[a-zA-Z][a-zA-Z0-9-\\._]{2,49}(?<![\\._\\-])$";

    public NewCoreProjectChecker(TizenMainWizardPage wizardPage) {
        super(wizardPage);
    }

    public NewCoreProjectChecker(TizenMainWizardPage wizardPage, NewProjectChecker.IErrorMessageReporter reporter) {
        super(wizardPage, reporter);
    }

    public void createGroupComposite(Composite c) {
        Composite composite = new Composite(c, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        SWTUtil.setGridLayoutData((Control)composite, (int)-1, (int)-1, (int)-1, (int)-1, (int)768);
        this.createGroup(composite, "name", org.tizen.nativeappcommon.wizards.Messages.NewProjectChecker_projectNameLabel, false, true);
        this.pkgNameField = this.createGroup(composite, Messages.PROJECTCHECKER_PKG_LABEL, false, true);
        this.createDefaultGroup(composite);
        this.createGroup(composite, "location", org.tizen.nativeappcommon.wizards.Messages.NewProjectChecker_projectLocationLabel, true, false);
        this.addGroupListener();
        this.addProjNameFieldListener();
        this.addPkgNameFieldListener();
    }

    private void addProjNameFieldListener() {
        final Text projNameField = this.getProjNameText();
        if (projNameField == null) {
            return;
        }
        projNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!NewCoreProjectChecker.this.isDirtyPkgName) {
                    NewCoreProjectChecker.this.pkgNameField.setText(NewCoreProjectChecker.PKGNAME_PREFIX + projNameField.getText().trim());
                }
            }
        });
    }

    private void addPkgNameFieldListener() {
        if (this.pkgNameField == null) {
            return;
        }
        this.pkgNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                NewCoreProjectChecker.this.isDirtyPkgName = true;
            }
        });
        this.pkgNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCoreProjectChecker.this.getWizardPage().setPageComplete(NewCoreProjectChecker.this.getWizardPage().validatePage());
            }
        });
        this.pkgNameField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toLowerCase();
            }
        });
    }

    public String getPkgName() {
        if (this.pkgNameField == null) {
            return "";
        }
        return this.pkgNameField.getText().trim();
    }

    public boolean validatePage() {
        boolean isRet = super.validatePage();
        if (!isRet) {
            return isRet;
        }
        String msg = this.validatePackageName();
        if (!"".equals(msg)) {
            this.setErrorMessage(msg);
            return false;
        }
        return true;
    }

    protected String validateProjectName(String projName) {
        return NewCoreProjectChecker.validateProjectName(projName, ResourcesPlugin.getWorkspace());
    }

    private String validatePackageName() {
        String pkgName = this.getPkgName();
        if (pkgName.length() > 50) {
            return NLS.bind((String)Messages.WIZARD_PACKAGE_SHORTER_ERROR, (Object)51);
        }
        if (pkgName.length() < 3) {
            return NLS.bind((String)Messages.WIZARD_PACKAGE_LONGER_ERROR, (Object)2);
        }
        if (!pkgName.matches(NAME_PATTERN)) {
            return Messages.WIZARD_PACKAGE_INVALID_ERROR;
        }
        if (pkgName.indexOf(35) >= 0) {
            return Messages.WIZARD_PACKAGE_INVALID_CHAR_ERROR;
        }
        return "";
    }

    public static String validateProjName(String projName) {
        return NewCoreProjectChecker.validateProjectName(projName, ResourcesPlugin.getWorkspace());
    }

    public static String validateProjectName(String projName, IWorkspace workspace) {
        IStatus nameStatus;
        if (workspace != null && !(nameStatus = workspace.validateName(projName, 4)).isOK()) {
            return nameStatus.getMessage();
        }
        if (WizardConstants.CPP_KEYWORDS.contains(projName)) {
            return NLS.bind((String)org.tizen.nativeappcommon.wizards.Messages.TizenMainWizardPage_isCppKeyword, (Object)projName);
        }
        if (projName.length() > 50) {
            return NLS.bind((String)org.tizen.nativeappcommon.wizards.Messages.WizardConstants_6, (Object)51);
        }
        if (projName.length() < 3) {
            return NLS.bind((String)org.tizen.nativeappcommon.wizards.Messages.WizardConstants_5, (Object)2);
        }
        if (!projName.matches(NAME_PATTERN)) {
            return org.tizen.nativeappcommon.wizards.Messages.WizardConstants_2;
        }
        if (projName.indexOf(35) >= 0) {
            return org.tizen.nativeappcommon.wizards.Messages.TizenMainWizardPage_3;
        }
        return "";
    }
}

