/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.util.List;
import org.tizen.common.core.application.Version;
import org.tizen.nativecommon.build.CommonBuildTargetManager;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;
import org.tizen.sbilib.ide.Toolchain;

public class NativeCoreBuildTargetManager
extends CommonBuildTargetManager {
    public static final String LLVM_ONEVERSION_SUPPORT_VER = "3.7";

    public String getDefaultToolchainId(String rootstrapId) {
        Version ver2;
        String version;
        Version ver1;
        String name;
        Toolchain tc = null;
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rootstrap = pm.getRootstrap(rootstrapId);
        String arch = rootstrap.getArchitecture();
        if (rootstrapId.contains("emulator")) {
            if (CommonConfigurationManager.isX86Arch((String)arch)) {
                tc = CommonBuildTargetManager.getX86LLVMToolchain((String)rootstrapId);
            } else if (CommonConfigurationManager.isX86_64Arch((String)arch)) {
                tc = CommonBuildTargetManager.getX86_64LLVMToolchain((String)rootstrapId);
            }
        } else if (rootstrapId.contains("device")) {
            if (CommonConfigurationManager.isArmArch((String)arch)) {
                tc = CommonBuildTargetManager.getArmLLVMToolchain((String)rootstrapId);
            } else if (CommonConfigurationManager.isArm64Arch((String)arch)) {
                tc = CommonBuildTargetManager.getArm64LLVMToolchain((String)rootstrapId);
            }
        }
        if (tc != null && (name = tc.getName().toLowerCase()).startsWith("llvm-") && (ver1 = new Version(version = name.substring(5))).compareTo(ver2 = new Version(LLVM_ONEVERSION_SUPPORT_VER)) >= 0) {
            return tc.getId();
        }
        return super.getDefaultToolchainId(rootstrapId);
    }

    public String getDefaultRootstrapId(String platformName, String[] archs) {
        PluginManager pm = PluginManager.getInstance();
        String projectType = "core";
        List rsList = pm.getRootstrapList();
        for (Rootstrap rs : rsList) {
            String profile = rs.getProfile().toLowerCase();
            String version = rs.getProfileVersion().toLowerCase();
            String supportType = rs.getSupportToolchainType();
            if (!supportType.endsWith(projectType) || !this.containValue(archs, rs.getArchitecture()) || !platformName.toLowerCase().startsWith(profile) || !platformName.toLowerCase().endsWith(version)) continue;
            return rs.getId();
        }
        return null;
    }
}

