/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.cli.model;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.tizen.nativecore.cli.model.PrePostFile;

public class PrePostFileWriter {
    private static final String DEF_PREBUILD_STEP = "PREBUILD_COMMAND";
    private static final String DEF_POSTBUILD_STEP = "POSTBUILD_COMMAND";
    private static final String DEF_PREBUILD_STEP_DESC = "PREBUILD_DESC";
    private static final String DEF_POSTBUILD_STEP_DESC = "POSTBUILD_DESC";
    private PrePostFile prepostFile;

    public PrePostFileWriter(PrePostFile prepostFile) {
        this.prepostFile = prepostFile;
    }

    public void write(String filePath) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(filePath));){
            out.newLine();
            out.write("# Add pre/post build process");
            out.newLine();
            out.write(this.makeStatement(DEF_PREBUILD_STEP_DESC, this.prepostFile.getPreBuildStepDesc()));
            out.newLine();
            out.write(this.makeStatement(DEF_PREBUILD_STEP, this.prepostFile.getPreBuildStep()));
            out.newLine();
            out.write(this.makeStatement(DEF_POSTBUILD_STEP_DESC, this.prepostFile.getPostBuildStepDesc()));
            out.newLine();
            out.write(this.makeStatement(DEF_POSTBUILD_STEP, this.prepostFile.getPostBuildStep()));
            out.newLine();
        }
    }

    private String makeStatement(String key, String value) {
        return String.valueOf(key) + " = " + value;
    }
}

