/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.ExternalBuildRunner;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.Messages;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.ui.sa.pages.TizenSAProperty;
import org.tizen.nativecommon.ui.sa.view.TizenSAView;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;

public class NativeExternalBuildRunner
extends ExternalBuildRunner {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String MARKER_ID = "org.tizen.nativecore.build.marker";

    public boolean invokeBuild(int kind, IProject project, IConfiguration configuration, IBuilder builder, IConsole console, IMarkerGenerator markerGenerator, IncrementalProjectBuilder projectBuilder, IProgressMonitor monitor) throws CoreException {
        TizenProjectDescription tproject = org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)project);
        project.deleteMarkers(MARKER_ID, false, 0);
        if (!InstallPathConfig.isSupportSameProfileToAppType((String)tproject.getProfileName(), (String)tproject.getVersion(), (String)"native")) {
            IMarker marker = project.createMarker(MARKER_ID);
            marker.setAttribute("severity", 2);
            marker.setAttribute("priority", 2);
            String errMsg = MessageFormat.format(Messages.CANNOT_SUPPORT_PLATFORM, tproject.getPlatformName());
            marker.setAttribute("message", (Object)errMsg);
            Status status = new Status(8, "org.tizen.nativecommon", errMsg, null);
            throw new CoreException((IStatus)status);
        }
        if (kind != 15) {
            try {
                NativeCoreConfigurationManager.checkBuildInfo(project);
            }
            catch (CoreException e) {
                ConsoleOutputStream outStream = console.getErrorStream();
                try {
                    outStream.write((String.valueOf(e.getMessage()) + "\n").getBytes());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                throw new CoreException(e.getStatus());
            }
        }
        UserLogger.start((String)"native.build");
        boolean result = this.invokeExternalBuild(kind, project, configuration, builder, console, markerGenerator, projectBuilder, monitor);
        UserLogger.end((String)"native.build");
        project.getFolder(configuration.getName()).refreshLocal(2, null);
        final IProject currentProject = project;
        if (TizenSAProperty.getWithRunOption((IProject)project)) {
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        IConfiguration defaultConfig = ProjectUtil.getDefaultConfiguration((IProject)currentProject);
                        if (defaultConfig == null) {
                            return;
                        }
                        IConfigurationEnvironmentVariableSupplier envVariableSupplier = null;
                        envVariableSupplier = defaultConfig.getEnvironmentVariableSupplier();
                        if (envVariableSupplier == null) {
                            NativeExternalBuildRunner.this.logger.error("Failed to show TizenSA results on view");
                            return;
                        }
                        IBuildEnvironmentVariable envVariable = null;
                        envVariable = envVariableSupplier.getVariable("SA_REPORT_PATH", defaultConfig, null);
                        if (envVariable == null) {
                            NativeExternalBuildRunner.this.logger.error("Failed to show TizenSA results on view");
                            return;
                        }
                        String saResultPath = envVariable.getValue();
                        File outDir = new File(saResultPath);
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IWorkbenchPart part = page.getActivePart();
                        TizenSAView view = (TizenSAView)page.showView("org.tizen.nativecommon.ui.view.tizensa");
                        view.refresh(currentProject, outDir);
                        page.activate(part);
                    }
                    catch (Exception e) {
                        NativeExternalBuildRunner.this.logger.error("Failed to show TizenSA results on view", (Throwable)e);
                    }
                }
            });
        }
        return result;
    }
}

