/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.apichecker.quickfix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.slf4j.LoggerFactory;
import org.tizen.nativecore.apichecker.utility.CommonUtility;
import org.tizen.nativecore.apichecker.utility.Messages;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.xmlstore.CoreXMLStore;
import org.tizen.nativecore.misc.editor.ManifestEditor;

public class QuickFixForUnusedPrivilege
extends WorkbenchMarkerResolution {
    private String label;
    private String privilege;
    private List<ManifestEditor> editorList = new ArrayList<ManifestEditor>();
    private List<CoreXMLStore> xmlStoreList = new ArrayList<CoreXMLStore>();
    private HashMap<IProject, HashMap<String, Integer>> projectMap = new HashMap();

    public QuickFixForUnusedPrivilege(String privilege) {
        this.privilege = privilege;
        this.label = NLS.bind((String)Messages.QuickFixer_labelString, (Object)privilege);
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        if (!(marker.getResource() instanceof IFile)) {
            MessageDialog.openError(null, (String)Messages.QuickFixer_dialogMessage, (String)Messages.QuickFixer_errorMessage);
            return;
        }
        try {
            IProject project = marker.getResource().getProject();
            String privilege = null;
            privilege = this.getPrivilegString((String)marker.getAttribute("message"));
            if (project == null || privilege == null) {
                return;
            }
            HashMap<Object, Object> unusedPrivilegeMap = new HashMap();
            unusedPrivilegeMap = CommonUtility.populateUnusedPrivileges(project);
            boolean isManifestEditorOpened = false;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                IEditorReference[] editorRefs;
                IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
                int n = editorRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart editorPart;
                    ManifestEditor manifestEditor;
                    IProject eProject;
                    IEditorReference editorRef = iEditorReferenceArray[n2];
                    String editorId = editorRef.getId();
                    if (editorId.equals("org.tizen.nativecore.misc.ManifestEditor") && ((eProject = (manifestEditor = (ManifestEditor)(editorPart = editorRef.getEditor(true))).getProject()) == null || project.getName().equals(eProject.getName()))) {
                        Manifest manifest = manifestEditor.getCoreManifest();
                        manifest.removePrivilege(privilege);
                        manifestEditor.getPrivilegePage().update(manifest);
                        manifestEditor.getPrivilegePage().setDirty(true);
                        manifestEditor.updateXmlFromUI();
                        manifestEditor.getPrivilegePage().firePrivilegeRemoved(privilege);
                        isManifestEditorOpened = true;
                        if (this.editorList.contains(manifestEditor)) break;
                        this.editorList.add(manifestEditor);
                        break;
                    }
                    ++n2;
                }
            }
            if (!isManifestEditorOpened) {
                CoreXMLStore coreXMLStore = new CoreXMLStore(project);
                coreXMLStore.loadXml();
                coreXMLStore.getCoreManifest().removePrivilege(privilege);
                if (!this.xmlStoreList.contains(coreXMLStore)) {
                    this.xmlStoreList.add(coreXMLStore);
                }
            }
            marker.delete();
            this.projectMap.put(project, unusedPrivilegeMap);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private String getPrivilegString(String message) {
        String[] words = message.split(" ");
        String unusedPrivilege = null;
        int i = 0;
        while (i < words.length) {
            if (words[i].startsWith("http:")) {
                unusedPrivilege = words[i];
                break;
            }
            ++i;
        }
        return unusedPrivilege;
    }

    public String getDescription() {
        return this.privilege;
    }

    public Image getImage() {
        return null;
    }

    public IMarker[] findOtherMarkers(IMarker[] all) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                String message = (String)marker.getAttribute("message");
                if (!this.getDescription().equals(message) && message.contains("Privilege") && message.contains("unused in project")) {
                    markers.add(marker);
                }
            }
            catch (CoreException coreException) {
                LoggerFactory.getLogger(QuickFixForUnusedPrivilege.class).error("Marker does not exist");
            }
            ++n2;
        }
        return markers.toArray(new IMarker[markers.size()]);
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.exists()) {
                this.run(marker);
            }
            ++n2;
        }
        for (ManifestEditor manifestEditor : this.editorList) {
            manifestEditor.doSave(null);
        }
        for (CoreXMLStore coreXMLStore : this.xmlStoreList) {
            coreXMLStore.storeXml();
        }
        for (IProject project : this.projectMap.keySet()) {
            CommonUtility.creatUnusedPrivilegeMarkers(project, this.projectMap.get(project));
        }
        this.projectMap.clear();
    }
}

