/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.editor.Messages;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiAttrLocaledName;

public class CoreLocalizationPage
extends TizenFormPage {
    String imagePath;
    public UiAttrLocaledName fUiName;
    public UiAttrLocaledName fUiDescriptions;
    public UiAttrLocaledName fUiIcon;

    public CoreLocalizationPage(FormEditor editor) {
        super(editor, Messages.CoreLocalizationPage_localization, Messages.CoreLocalizationPage_localization);
    }

    private Font getBoldFont(Control label, int fontSize) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    private String updatedVersion(String version, String sep, int width) {
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(String.format("%" + width + 's', s));
            ++n2;
        }
        return sb.toString();
    }

    private int compareVersion(String ver1, String ver2) {
        int result = -1;
        String s1 = this.updatedVersion(ver1, ".", 2);
        String s2 = this.updatedVersion(ver2, ".", 2);
        result = s1.compareTo(s2);
        return result;
    }

    boolean isIconSupported(String apiversion, String profile) {
        if (profile.equals("mobile") && this.compareVersion(apiversion, "3.0") >= 0) {
            return true;
        }
        return profile.equals("wearable") && this.compareVersion(apiversion, "2.3.2") >= 0;
    }

    protected void createFormContent(IManagedForm managedForm) {
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        ScrolledForm scrolledForm = managedForm.getForm();
        FormToolkit tk = managedForm.getToolkit();
        Composite body = scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout());
        GridData clientGD = new GridData(0x1000000, 0, true, true, 0, 0);
        clientGD.widthHint = 640;
        Composite client = tk.createComposite(body);
        client.setLayout((Layout)new GridLayout());
        client.setLayoutData((Object)clientGD);
        tk.decorateFormHeading(scrolledForm.getForm());
        GridData titleGridData = new GridData();
        titleGridData.horizontalAlignment = 1;
        titleGridData.grabExcessHorizontalSpace = true;
        Composite titleComposite = tk.createComposite(client);
        titleComposite.setLayout((Layout)new GridLayout(2, false));
        titleComposite.setLayoutData((Object)titleGridData);
        GridData iconImageGD = new GridData();
        iconImageGD.widthHint = 70;
        Label iconImage = new Label(titleComposite, 0x2000000);
        this.imagePath = IdePlugin.getDefault().getResourceLocationURL("icons/editor/title_localization.png").getFile();
        iconImage.setImage(new Image(null, new ImageData(this.imagePath)));
        iconImage.setBackground(new Color(null, 255, 255, 255));
        iconImage.setLayoutData((Object)iconImageGD);
        Label titleText = new Label(titleComposite, 0x2000000);
        titleText.setText(Messages.CoreLocalizationPage_localization);
        titleText.setAlignment(0x1000000);
        titleText.setFont(this.getBoldFont((Control)titleText, 13));
        titleText.setBackground(new Color(null, 255, 255, 255));
        Label separator = new Label(client, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setBackground(new Color(null, 255, 255, 255));
        Label textLabel = new Label(client, 0);
        textLabel.setFont(this.getBoldFont((Control)textLabel, 10));
        textLabel.setText(Messages.CoreLocalizationPage_title);
        textLabel.setBackground(new Color(null, 255, 255, 255));
        textLabel.setForeground(new Color(null, 0, 138, 238));
        GridData desGd = new GridData();
        desGd.heightHint = 50;
        Label desLabel = new Label(client, 0x1000000);
        desLabel.setText(Messages.CoreLocalizationPage_subtitle);
        desLabel.setBackground(new Color(null, 255, 255, 255));
        desLabel.setFont(this.getBoldFont((Control)desLabel, 10));
        desLabel.setForeground(new Color(null, 51, 51, 51));
        desLabel.setLayoutData((Object)desGd);
        Composite tableBody = tk.createComposite(client);
        tableBody.setLayout((Layout)new GridLayout());
        tableBody.setLayoutData((Object)new GridData(768));
        this.fUiName = new UiAttrLocaledName(this, false);
        this.fUiName.setDefaultLocaleRequired(false);
        this.fUiName.createUi(tableBody, tk, Messages.CoreLocalizationPage_label, true);
        this.fUiDescriptions = new UiAttrLocaledName(this, false);
        this.fUiDescriptions.setDefaultLocaleRequired(false);
        this.fUiDescriptions.createUi(tableBody, tk, Messages.CoreLocalizationPage_description, true);
        String apiversion = this.getEditor().getCoreManifest().getApiVersion();
        String profile = this.getEditor().getCoreManifest().getProfile().getName();
        if (this.isIconSupported(apiversion, profile)) {
            this.fUiIcon = new UiAttrLocaledName(this, false);
            this.fUiIcon.setDefaultLocaleRequired(false);
            this.fUiIcon.createUi(tableBody, tk, Messages.CoreLocalizationPage_icon, true);
        }
        this.update(this.getEditor().getCoreManifest());
        this.setDirty(false);
    }

    public void update(Manifest coreManifest) {
        if (this.fUiName != null) {
            this.fUiName.setInput(coreManifest.getDefaultApp().getLabels());
        }
        if (this.fUiDescriptions != null) {
            this.fUiDescriptions.setInput(coreManifest.getDescriptions());
        }
        if (this.fUiIcon != null) {
            String profile;
            String apiversion = this.getEditor().getCoreManifest().getApiVersion();
            if (this.isIconSupported(apiversion, profile = this.getEditor().getCoreManifest().getProfile().getName())) {
                List<LocaledValue> icons = coreManifest.getDefaultApp().getIcons();
                if (icons != null) {
                    this.fUiIcon.setInput(icons);
                }
                this.fUiIcon.setVisible(true);
            } else {
                this.fUiIcon.setVisible(false);
            }
        }
    }
}

