/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.editor.CoreProjectInfoSection;
import org.tizen.nativecore.misc.editor.LinkSection;
import org.tizen.nativecore.misc.editor.TizenFormPage;

public class CoreOverviewPage
extends TizenFormPage {
    public CoreProjectInfoSection projInfo;
    public LinkSection linkSection;
    String imagePath;

    public CoreOverviewPage(FormEditor editor) {
        super(editor, "Overview", "Overview");
    }

    private Font getBoldFont(Control label, int fontSize) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    protected void createFormContent(IManagedForm managedForm) {
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        ScrolledForm scrolledForm = managedForm.getForm();
        FormToolkit tk = managedForm.getToolkit();
        Composite body = scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout());
        GridData clientGD = new GridData(0x1000000, 0, true, true, 0, 0);
        clientGD.widthHint = 640;
        Composite client = tk.createComposite(body);
        client.setLayout((Layout)new GridLayout());
        client.setLayoutData((Object)clientGD);
        tk.decorateFormHeading(scrolledForm.getForm());
        GridData titleGridData = new GridData();
        titleGridData.horizontalAlignment = 1;
        titleGridData.grabExcessHorizontalSpace = true;
        Composite titleComposite = tk.createComposite(client);
        titleComposite.setLayout((Layout)new GridLayout(2, false));
        titleComposite.setLayoutData((Object)titleGridData);
        GridData iconImageGD = new GridData();
        iconImageGD.widthHint = 70;
        Label iconImage = new Label(titleComposite, 0x2000000);
        this.imagePath = IdePlugin.getDefault().getResourceLocationURL("icons/editor/title_overview.png").getFile();
        iconImage.setImage(new Image(null, new ImageData(this.imagePath)));
        iconImage.setBackground(new Color(null, 255, 255, 255));
        iconImage.setLayoutData((Object)iconImageGD);
        Label titleText = new Label(titleComposite, 0x2000000);
        titleText.setText("Overview");
        titleText.setAlignment(0x1000000);
        titleText.setFont(this.getBoldFont((Control)titleText, 13));
        titleText.setBackground(new Color(null, 255, 255, 255));
        Label separator = new Label(client, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setBackground(new Color(null, 255, 255, 255));
        Label textLabel = new Label(client, 0);
        textLabel.setText("General Information");
        textLabel.setBackground(new Color(null, 255, 255, 255));
        textLabel.setFont(this.getBoldFont((Control)textLabel, 10));
        textLabel.setForeground(new Color(null, 0, 138, 238));
        GridData gd = new GridData();
        gd.heightHint = 50;
        Label desLabel = new Label(client, 0x1000000);
        desLabel.setText("This section describes general information about this project");
        desLabel.setBackground(new Color(null, 255, 255, 255));
        desLabel.setFont(this.getBoldFont((Control)desLabel, 10));
        desLabel.setForeground(new Color(null, 51, 51, 51));
        desLabel.setLayoutData((Object)gd);
        this.create_GeneralControl(client, tk);
        this.update(this.getEditor().getCoreManifest());
        this.setDirty(false);
    }

    String createFormTextContent(IMessage[] messages) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<form>");
        int i = 0;
        while (i < messages.length) {
            IMessage message = messages[i];
            pw.print("<li vspace=\"false\" style=\"image\" indent=\"16\" value=\"");
            switch (message.getMessageType()) {
                case 3: {
                    pw.print("error");
                    break;
                }
                case 2: {
                    pw.print("warning");
                    break;
                }
                case 1: {
                    pw.print("info");
                    break;
                }
            }
            pw.print("\"> <a href=\"");
            pw.print(String.valueOf(i));
            pw.print("\">");
            pw.print(message.getKey());
            pw.println("</a></li>");
            ++i;
        }
        pw.println("</form>");
        pw.flush();
        return sw.toString();
    }

    private Image getImage(int type) {
        switch (type) {
            case 3: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            case 2: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            case 1: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }

    protected void create_GeneralControl(Composite parent, FormToolkit tk) {
        this.create_GeneralControl_Left(tk, parent);
    }

    private void create_GeneralControl_Left(FormToolkit tk, Composite body) {
        this.projInfo = new CoreProjectInfoSection(tk, body, this);
    }

    public static boolean checkLegal(String str, String illegalStr) {
        int i = 0;
        while (i < str.length()) {
            int j = 0;
            while (j < illegalStr.length()) {
                if (str.charAt(i) == illegalStr.charAt(j)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void update(Manifest coreManifest) {
        this.projInfo.update(coreManifest);
    }
}

