/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.tizen.nativecore.misc.editor.TizenSectionPart;

public class SectionHelper {
    public static Section createSection(FormToolkit tk, Composite parent, String name, String desc) {
        int style = 336;
        if (desc != null) {
            style |= 0x80;
        }
        Section section = tk.createSection(parent, style);
        section.setText(name);
        if (desc != null) {
            section.setDescription(desc);
        }
        tk.createCompositeSeparator((Composite)section);
        return section;
    }

    public static SectionPart createSectionPart(FormToolkit tk, Composite parent, String name, String desc) {
        int style = 336;
        if (desc != null) {
            style |= 0x80;
        }
        TizenSectionPart spart = new TizenSectionPart(parent, tk, style);
        Section section = spart.getSection();
        section.setText(name);
        if (desc != null) {
            section.setDescription(desc);
        }
        tk.createCompositeSeparator((Composite)section);
        return spart;
    }

    public static Composite createTableLayout(Composite parent, FormToolkit toolkit, int column) {
        Composite table = toolkit.createComposite(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = column;
        table.setLayout((Layout)layout);
        toolkit.paintBordersFor(table);
        if (parent instanceof Section) {
            ((Section)parent).setClient((Control)table);
        }
        return table;
    }

    public static Composite createGridLayout(Composite parent, FormToolkit toolkit, int column) {
        Composite grid = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginRight = 1;
        layout.marginLeft = 1;
        layout.numColumns = column;
        grid.setLayout((Layout)layout);
        toolkit.paintBordersFor(grid);
        if (parent instanceof Section) {
            ((Section)parent).setClient((Control)grid);
        }
        return grid;
    }

    public static Text createLabelAndText(Composite parent, FormToolkit toolkit, String labelText, String labelTooltip, String value) {
        Label label = toolkit.createLabel(parent, labelText);
        if (labelTooltip != null) {
            label.setToolTipText(labelTooltip);
        }
        label.setLayoutData((Object)new TableWrapData(2, 32));
        Text text = toolkit.createText(parent, value);
        text.setLayoutData((Object)new TableWrapData(256, 32));
        return text;
    }

    public static Text createGridLabelAndText(Composite parent, FormToolkit toolkit, String labelText, String labelTooltip, String value) {
        Label label = toolkit.createLabel(parent, labelText, 0);
        if (labelTooltip != null) {
            label.setToolTipText(labelTooltip);
        }
        Text text = toolkit.createText(parent, value);
        text.setLayoutData((Object)new GridData(1808));
        return text;
    }

    public static Combo createLabelAndCombo(Composite parent, FormToolkit toolkit, String labelText, String[] values, String tooltip) {
        if (toolkit != null) {
            Label label = toolkit.createLabel(parent, labelText);
            label.setToolTipText(tooltip);
            label.setLayoutData((Object)new TableWrapData(2, 32));
        }
        Combo combo = new Combo(parent, 4);
        TableWrapData twd = new TableWrapData(256, 32);
        twd.maxWidth = 100;
        combo.setLayoutData((Object)twd);
        combo.setItems(values);
        return combo;
    }

    public static Combo createLabelAndReadOnlyCombo(Composite parent, FormToolkit toolkit, String labelText, String[] values, String tooltip) {
        if (toolkit != null) {
            Label label = toolkit.createLabel(parent, labelText);
            label.setToolTipText(tooltip);
            label.setLayoutData((Object)new TableWrapData(2, 32));
        }
        Combo combo = new Combo(parent, 12);
        TableWrapData twd = new TableWrapData(128, 32);
        combo.setLayoutData((Object)twd);
        combo.setItems(values);
        return combo;
    }

    public static void createSectionActions(Section section, Action action) {
        ToolBarManager manager = new ToolBarManager(0x800000);
        ToolBar toolbar = manager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        manager.add((IAction)action);
        manager.update(true);
    }
}

