/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.csviewer;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.ViewUtil;
import org.tizen.common.util.log.Logger;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecore.csviewer.view.CallStackView;
import org.tizen.sdblib.ICrashReportServiceListener;
import org.tizen.sdblib.IDevice;

public class CrashReportServiceListener
implements ICrashReportServiceListener {
    private static String CS_VIEW_ID = "org.tizen.nativecore.csviewer.view.CallStackView";

    public void fileCreated(IDevice device, String remoteCSPath) {
        if (device != null && remoteCSPath != null) {
            try {
                String strFilePath = ProjectUtil.pullCSFile((IDevice)device, (String)remoteCSPath);
                if (strFilePath != null) {
                    this.showView(CS_VIEW_ID, strFilePath);
                }
            }
            catch (Exception e) {
                Logger.error((Object)"Failed to pull cs file :", (Throwable)e);
            }
        }
    }

    private void showView(String viewId, String csPath) {
        ViewRunnable runnable = new ViewRunnable(viewId, csPath);
        SWTUtil.asyncExec((Runnable)runnable);
    }

    private static class ViewRunnable
    implements Runnable {
        String id;
        String csPath;

        public ViewRunnable(String id, String csPath) {
            this.id = id;
            this.csPath = csPath;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = ViewUtil.getWorkbenchWindow();
            if (window == null) {
                return;
            }
            try {
                CallStackView viewPart = (CallStackView)window.getActivePage().showView(this.id);
                if (viewPart != null) {
                    viewPart.startCallStackView(this.csPath);
                } else {
                    Logger.error((String)"Cannot find cs view", (Object[])new Object[0]);
                }
            }
            catch (PartInitException e) {
                Logger.error((Object)"Failed to show cs view :", (Throwable)e);
            }
        }
    }
}

