/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.csviewer.view;

import java.text.Collator;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import org.tizen.nativecore.csviewer.control.CSFileReader;
import org.tizen.nativecore.csviewer.log.LogUIMessages;
import org.tizen.nativecore.csviewer.model.CSVO;
import org.tizen.nativecore.csviewer.model.CallStackVO;
import org.tizen.nativecore.csviewer.model.DebugMessageVO;
import org.tizen.nativecore.csviewer.model.HeaderVO;
import org.tizen.nativecore.csviewer.model.MemoryMapVO;
import org.tizen.nativecore.csviewer.model.RegisterVO;

public class CallStackView
extends ViewPart {
    private static final int IDX_HEADER_LIST_SW_VERSION = 0;
    private static final int IDX_HEADER_LIST_EXTRA_INFORMATION = 1;
    private static final int IDX_HEADER_LIST_SIGNAL_INFORMATION = 2;
    private static final int IDX_HEADER_LIST_REGISTER_INFORMATION = 3;
    private static final int IDX_HEADER_LIST_MEMORY_INFORMATION = 4;
    private static final int IDX_HEADER_LIST_PACKAGE_INFORMATION = 5;
    private CSVO csInfoVO = null;
    private static final int IDX_TAB_HEADER = 0;
    private static final int IDX_TAB_CALL_STACK_INFORMATION = 1;
    private static final int IDX_TAB_DEBUG_MESSAGE = 2;
    private TabFolder tabFolder = null;
    private static final int WIDTH_LIST_HEADER = 180;
    private Composite compositeHeader = null;
    private List listHeader = null;
    private Table tableHeader = null;
    private static final int WIDTH_SASH_CALL_STACK = 25;
    private Composite compositeCallStack = null;
    private Table tableCallStack = null;
    private Table tableMemoryMap = null;
    private Sash sashCallStack = null;
    private static final int IDX_DM_TABLE_COLUMN_DATE = 0;
    private static final int IDX_DM_TABLE_COLUMN_TAG = 1;
    private static final int IDX_DM_TABLE_COLUMN_PID = 2;
    private static final int IDX_DM_TABLE_COLUMN_MESSAGE = 3;
    private Composite compositeDebugMessage = null;
    private Table tableDebugMessage = null;
    private TableColumn columnDate;
    private TableColumn columnTag;
    private TableColumn columnPID;
    private TableColumn columnMessage;
    private Combo comboFilterDebugMessage;
    private String[] comboItemsFilterDebugMessage = new String[]{LogUIMessages.LOG_COLUMN_02_DEBUG_MESSAGE, LogUIMessages.LOG_COLUMN_03_DEBUG_MESSAGE, LogUIMessages.LOG_COLUMN_04_DEBUG_MESSAGE};
    private Text textFilterDebugMessage;

    public void createPartControl(Composite parent) {
        this.initUIComponents(parent);
        this.initDragAndDrop(parent);
    }

    public void setFocus() {
    }

    public void startCallStackView(String strFilePath) {
        if (strFilePath.endsWith(".cs")) {
            CSFileReader csFileReader = new CSFileReader(strFilePath);
            csFileReader.demanglingFile();
            CSVO result = csFileReader.parse();
            if (result != null) {
                this.initCrashInformation(result);
            }
        }
    }

    private void setHeaderTableValue(int idxHeaderList, HeaderVO headerVO) {
        this.tableHeader.removeAll();
        switch (idxHeaderList) {
            case 0: {
                String[][] sWVersionItems = headerVO.getSWVersionItems();
                if (sWVersionItems == null) break;
                String[][] stringArray = sWVersionItems;
                int n = sWVersionItems.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] strSWVersion = stringArray[n2];
                    TableItem ti = new TableItem(this.tableHeader, 0);
                    ti.setText(strSWVersion);
                    ++n2;
                }
                break;
            }
            case 1: {
                String[][] extraInformationItems = headerVO.getCrashInformationItems();
                if (extraInformationItems == null) break;
                String[][] ti = extraInformationItems;
                int n = extraInformationItems.length;
                int n3 = 0;
                while (n3 < n) {
                    String[] strExtraInformation = ti[n3];
                    TableItem ti2 = new TableItem(this.tableHeader, 0);
                    ti2.setText(strExtraInformation);
                    ++n3;
                }
                break;
            }
            case 2: {
                String[][] signalInformationItems = headerVO.getSignalInformationItems();
                if (signalInformationItems == null) break;
                String[][] ti2 = signalInformationItems;
                int ti = signalInformationItems.length;
                int n = 0;
                while (n < ti) {
                    String[] strSignalInformation = ti2[n];
                    TableItem ti3 = new TableItem(this.tableHeader, 0);
                    ti3.setText(strSignalInformation);
                    ++n;
                }
                break;
            }
            case 3: {
                ArrayList<RegisterVO> registerVOList = headerVO.getRegisterList();
                if (registerVOList == null) break;
                for (RegisterVO registerVO : registerVOList) {
                    TableItem ti = new TableItem(this.tableHeader, 0);
                    ti.setText(new String[]{registerVO.getName(), registerVO.getValue()});
                }
                break;
            }
            case 4: {
                String[][] memoryInformationItems = headerVO.getMemoryInformationItems();
                if (memoryInformationItems == null) break;
                String[][] stringArray = memoryInformationItems;
                int n = memoryInformationItems.length;
                int ti = 0;
                while (ti < n) {
                    String[] strMemoryInformation = stringArray[ti];
                    TableItem ti4 = new TableItem(this.tableHeader, 0);
                    ti4.setText(strMemoryInformation);
                    ++ti;
                }
                break;
            }
            case 5: {
                String[][] packageInformationItems = headerVO.getPackageInformationItems();
                if (packageInformationItems == null) break;
                String[][] stringArray = packageInformationItems;
                int n = packageInformationItems.length;
                int n4 = 0;
                while (n4 < n) {
                    String[] strPackageInformation = stringArray[n4];
                    TableItem ti = new TableItem(this.tableHeader, 0);
                    ti.setText(strPackageInformation);
                    ++n4;
                }
                break;
            }
        }
        this.tableHeader.getColumn(0).pack();
        this.tableHeader.getColumn(1).pack();
    }

    public void initCrashInformation(CSVO csInfoVO) {
        this.csInfoVO = csInfoVO;
        this.tabFolder.setSelection(0);
        this.initHeaderTabItem(csInfoVO.getHeader());
        this.initCallStackTabItem(csInfoVO.getCallStackList(), csInfoVO.getMemoryMapList());
        this.initDebugMessageTabItem(csInfoVO.getDebugMessageList());
    }

    private void initHeaderTabItem(HeaderVO headerVO) {
        this.listHeader.setSelection(0);
        this.setHeaderTableValue(0, headerVO);
    }

    private void initCallStackTabItem(ArrayList<CallStackVO> listCallStackVO, ArrayList<MemoryMapVO> listMemoryMapVO) {
        TableColumn column;
        int n;
        TableColumn[] tableColumnArray;
        String[] buf;
        TableItem ti;
        this.tableCallStack.removeAll();
        this.tableMemoryMap.removeAll();
        if (listCallStackVO != null) {
            ti = null;
            buf = new String[3];
            for (CallStackVO callStackVO : listCallStackVO) {
                ti = new TableItem(this.tableCallStack, 0);
                buf[0] = String.valueOf(callStackVO.getSerialNumber());
                buf[1] = callStackVO.getAddressS();
                buf[2] = callStackVO.getPayload();
                ti.setText(buf);
            }
            tableColumnArray = this.tableCallStack.getColumns();
            n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                column = tableColumnArray[n2];
                column.pack();
                ++n2;
            }
        }
        if (listMemoryMapVO != null) {
            ti = null;
            buf = new String[4];
            for (MemoryMapVO memoryMapVO : listMemoryMapVO) {
                ti = new TableItem(this.tableMemoryMap, 0);
                buf[0] = memoryMapVO.getStartAddressS();
                buf[1] = memoryMapVO.getEndAddressS();
                buf[2] = memoryMapVO.getMod();
                buf[3] = memoryMapVO.getSoInfo();
                ti.setText(buf);
            }
            tableColumnArray = this.tableMemoryMap.getColumns();
            n = tableColumnArray.length;
            int n3 = 0;
            while (n3 < n) {
                column = tableColumnArray[n3];
                column.pack();
                ++n3;
            }
            this.tableMemoryMap.select(0);
            this.tableMemoryMap.deselect(0);
        }
    }

    private void initDebugMessageTabItem(ArrayList<DebugMessageVO> listDebugMessage) {
        this.tableDebugMessage.removeAll();
        if (listDebugMessage != null) {
            TableItem ti = null;
            String[] buf = null;
            for (DebugMessageVO debugMessageVO : listDebugMessage) {
                ti = new TableItem(this.tableDebugMessage, 0);
                buf = new String[]{debugMessageVO.getDate(), debugMessageVO.getTag(), debugMessageVO.getPID(), debugMessageVO.getMessage()};
                ti.setText(buf);
            }
            TableColumn[] tableColumnArray = this.tableDebugMessage.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.pack();
                ++n2;
            }
        }
        this.comboFilterDebugMessage.select(2);
        this.textFilterDebugMessage.setText("");
    }

    private void filterDebugMessageTabItem(ArrayList<DebugMessageVO> listDebugMessage, String strFilter, String strCriteria) {
        this.tableDebugMessage.removeAll();
        if (listDebugMessage != null) {
            boolean isFound = false;
            String strValue = null;
            String[] buf = null;
            TableItem ti = null;
            for (DebugMessageVO debugMessageVO : listDebugMessage) {
                isFound = false;
                if (strFilter.equals(LogUIMessages.LOG_COLUMN_02_DEBUG_MESSAGE)) {
                    strValue = debugMessageVO.getTag();
                    if (strValue != null && strValue.contains(strCriteria)) {
                        isFound = true;
                    }
                } else if (strFilter.equals(LogUIMessages.LOG_COLUMN_03_DEBUG_MESSAGE)) {
                    strValue = debugMessageVO.getPID();
                    if (strValue != null && strValue.contains(strCriteria)) {
                        isFound = true;
                    }
                } else if (strFilter.equals(LogUIMessages.LOG_COLUMN_04_DEBUG_MESSAGE) && (strValue = debugMessageVO.getMessage()) != null && strValue.contains(strCriteria)) {
                    isFound = true;
                }
                if (strCriteria != null && strCriteria.isEmpty()) {
                    isFound = true;
                }
                if (!isFound) continue;
                ti = new TableItem(this.tableDebugMessage, 0);
                buf = new String[]{debugMessageVO.getDate(), debugMessageVO.getTag(), debugMessageVO.getPID(), debugMessageVO.getMessage()};
                ti.setText(buf);
            }
        }
    }

    private void initUIComponents(Composite parent) {
        this.tabFolder = new TabFolder(parent, 2048);
        parent.setLayout((Layout)new FillLayout());
        ListSelectionListener listSelectionListener = new ListSelectionListener(parent);
        CopyKeyAdapter copyKeyListener = new CopyKeyAdapter();
        DebugMessageColumnSelectionListener columnSelectionListener = new DebugMessageColumnSelectionListener();
        GridData gd = null;
        String[] strsTabTitle = new String[]{LogUIMessages.LOG_TAB_TITLE_01, LogUIMessages.LOG_TAB_TITLE_02, LogUIMessages.LOG_TAB_TITLE_03};
        int i = 0;
        while (i < 3) {
            TabItem tabItem = new TabItem(this.tabFolder, 0);
            tabItem.setText(strsTabTitle[i]);
            switch (i) {
                case 0: {
                    this.compositeHeader = new Composite((Composite)this.tabFolder, 0);
                    tabItem.setControl((Control)this.compositeHeader);
                    this.compositeHeader.setLayout((Layout)new GridLayout(2, false));
                    Group groupHeaderList = new Group(this.compositeHeader, 16);
                    groupHeaderList.setLayout((Layout)new FillLayout());
                    gd = new GridData();
                    gd.horizontalSpan = 1;
                    gd.grabExcessVerticalSpace = true;
                    gd.verticalAlignment = 4;
                    gd.widthHint = 180;
                    groupHeaderList.setLayoutData((Object)gd);
                    this.listHeader = new List((Composite)groupHeaderList, 4);
                    this.listHeader.setItems(new String[]{LogUIMessages.LOG_LIST_ITEM_01_HEADER, LogUIMessages.LOG_LIST_ITEM_02_HEADER, LogUIMessages.LOG_LIST_ITEM_03_HEADER, LogUIMessages.LOG_LIST_ITEM_04_HEADER, LogUIMessages.LOG_LIST_ITEM_05_HEADER, LogUIMessages.LOG_LIST_ITEM_06_HEADER});
                    this.listHeader.addSelectionListener((SelectionListener)listSelectionListener);
                    this.tableHeader = new Table(this.compositeHeader, 67588);
                    this.tableHeader.setHeaderVisible(true);
                    this.tableHeader.setLinesVisible(true);
                    this.tableHeader.addKeyListener((KeyListener)copyKeyListener);
                    TableColumn columnItemName = new TableColumn(this.tableHeader, 0);
                    columnItemName.setText(LogUIMessages.LOG_COLUMN_01_HEADER);
                    columnItemName.pack();
                    TableColumn columnItemValue = new TableColumn(this.tableHeader, 0);
                    columnItemValue.setText(LogUIMessages.LOG_COLUMN_02_HEADER);
                    columnItemValue.pack();
                    gd = new GridData();
                    gd.horizontalSpan = 1;
                    gd.grabExcessHorizontalSpace = true;
                    gd.horizontalAlignment = 4;
                    gd.grabExcessVerticalSpace = true;
                    gd.verticalAlignment = 4;
                    this.tableHeader.setLayoutData((Object)gd);
                    break;
                }
                case 1: {
                    this.compositeCallStack = new Composite((Composite)this.tabFolder, 0);
                    tabItem.setControl((Control)this.compositeCallStack);
                    this.compositeCallStack.setLayout((Layout)new FormLayout());
                    this.sashCallStack = new Sash(this.compositeCallStack, 512);
                    FormData fd = new FormData();
                    fd.top = new FormAttachment(0, 0);
                    fd.bottom = new FormAttachment(100, 0);
                    fd.left = new FormAttachment(25, 0);
                    this.sashCallStack.setLayoutData((Object)fd);
                    this.tableCallStack = new Table(this.compositeCallStack, 67588);
                    this.tableCallStack.setHeaderVisible(true);
                    this.tableCallStack.setLinesVisible(true);
                    this.tableCallStack.addSelectionListener((SelectionListener)listSelectionListener);
                    this.tableCallStack.addKeyListener((KeyListener)copyKeyListener);
                    TableColumn columnSerialNumber = new TableColumn(this.tableCallStack, 0);
                    columnSerialNumber.setText(LogUIMessages.LOG_COLUMN_01_LEFT_CALL_STACK);
                    columnSerialNumber.pack();
                    TableColumn columnDestiAddress = new TableColumn(this.tableCallStack, 0);
                    columnDestiAddress.setText(LogUIMessages.LOG_COLUMN_02_LEFT_CALL_STACK);
                    columnDestiAddress.pack();
                    TableColumn columnCallStack = new TableColumn(this.tableCallStack, 0);
                    columnCallStack.setText(LogUIMessages.LOG_COLUMN_03_LEFT_CALL_STACK);
                    columnCallStack.pack();
                    fd = new FormData();
                    fd.top = new FormAttachment(0, 0);
                    fd.bottom = new FormAttachment(100, 0);
                    fd.left = new FormAttachment(0, 0);
                    fd.right = new FormAttachment((Control)this.sashCallStack, 0);
                    this.tableCallStack.setLayoutData((Object)fd);
                    this.tableMemoryMap = new Table(this.compositeCallStack, 67588);
                    this.tableMemoryMap.setHeaderVisible(true);
                    this.tableMemoryMap.setLinesVisible(true);
                    this.tableMemoryMap.addKeyListener((KeyListener)copyKeyListener);
                    TableColumn columnStartAddress = new TableColumn(this.tableMemoryMap, 0);
                    columnStartAddress.setText(LogUIMessages.LOG_COLUMN_01_RIGHT_CALL_STACK);
                    columnStartAddress.pack();
                    TableColumn columnEndAddress = new TableColumn(this.tableMemoryMap, 0);
                    columnEndAddress.setText(LogUIMessages.LOG_COLUMN_02_RIGHT_CALL_STACK);
                    columnEndAddress.pack();
                    TableColumn columnMod = new TableColumn(this.tableMemoryMap, 0);
                    columnMod.setText(LogUIMessages.LOG_COLUMN_03_RIGHT_CALL_STACK);
                    columnMod.pack();
                    TableColumn columnSO = new TableColumn(this.tableMemoryMap, 0);
                    columnSO.setText(LogUIMessages.LOG_COLUMN_04_RIGHT_CALL_STACK);
                    columnSO.pack();
                    fd = new FormData();
                    fd.top = new FormAttachment(0, 0);
                    fd.bottom = new FormAttachment(100, 0);
                    fd.left = new FormAttachment((Control)this.sashCallStack, 0);
                    fd.right = new FormAttachment(100, 0);
                    this.tableMemoryMap.setLayoutData((Object)fd);
                    this.sashCallStack.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ((FormData)((CallStackView)CallStackView.this).sashCallStack.getLayoutData()).left = new FormAttachment(0, e.x);
                            CallStackView.this.sashCallStack.getParent().layout();
                        }
                    });
                    break;
                }
                case 2: {
                    this.compositeDebugMessage = new Composite((Composite)this.tabFolder, 0);
                    tabItem.setControl((Control)this.compositeDebugMessage);
                    this.compositeDebugMessage.setLayoutData((Object)new GridData(1040));
                    this.compositeDebugMessage.setLayout((Layout)new GridLayout(1, false));
                    Composite compositeTableDebugMessage = new Composite(this.compositeDebugMessage, 0);
                    compositeTableDebugMessage.setLayoutData((Object)new GridData(1808));
                    compositeTableDebugMessage.setLayout((Layout)new FillLayout());
                    this.tableDebugMessage = new Table(compositeTableDebugMessage, 67842);
                    this.tableDebugMessage.setHeaderVisible(true);
                    this.tableDebugMessage.setLinesVisible(true);
                    this.tableDebugMessage.addKeyListener((KeyListener)copyKeyListener);
                    this.columnDate = new TableColumn(this.tableDebugMessage, 0);
                    this.columnDate.setText(LogUIMessages.LOG_COLUMN_01_DEBUG_MESSAGE);
                    this.columnDate.addSelectionListener((SelectionListener)columnSelectionListener);
                    this.columnDate.pack();
                    this.columnTag = new TableColumn(this.tableDebugMessage, 0);
                    this.columnTag.setText(LogUIMessages.LOG_COLUMN_02_DEBUG_MESSAGE);
                    this.columnTag.addSelectionListener((SelectionListener)columnSelectionListener);
                    this.columnTag.pack();
                    this.columnPID = new TableColumn(this.tableDebugMessage, 0);
                    this.columnPID.setText(LogUIMessages.LOG_COLUMN_03_DEBUG_MESSAGE);
                    this.columnPID.addSelectionListener((SelectionListener)columnSelectionListener);
                    this.columnPID.pack();
                    this.columnMessage = new TableColumn(this.tableDebugMessage, 0);
                    this.columnMessage.setText(LogUIMessages.LOG_COLUMN_04_DEBUG_MESSAGE);
                    this.columnMessage.addSelectionListener((SelectionListener)columnSelectionListener);
                    this.columnMessage.pack();
                    Composite compositeFilterDebugMessage = new Composite(this.compositeDebugMessage, 0);
                    compositeFilterDebugMessage.setLayoutData((Object)new GridData(768));
                    compositeFilterDebugMessage.setLayout((Layout)new GridLayout(3, false));
                    this.comboFilterDebugMessage = new Combo(compositeFilterDebugMessage, 8);
                    this.comboFilterDebugMessage.setItems(this.comboItemsFilterDebugMessage);
                    this.comboFilterDebugMessage.select(2);
                    this.comboFilterDebugMessage.setToolTipText(LogUIMessages.LOG_TOOLTIP_COMBO_DEBUG_MESSAGE);
                    this.textFilterDebugMessage = new Text(compositeFilterDebugMessage, 2052);
                    this.textFilterDebugMessage.setLayoutData((Object)new GridData(768));
                    this.textFilterDebugMessage.setMessage(LogUIMessages.LOG_MESSAGE_TEXT_DEBUG_MESSAGE);
                    this.textFilterDebugMessage.addModifyListener((ModifyListener)new DebugMessageTextModifyListener());
                }
            }
            ++i;
        }
    }

    private void initDragAndDrop(Composite parent) {
        int operation = 19;
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)parent, operation);
        OpenDropTargetAdapter openDropTargetAdapter = new OpenDropTargetAdapter();
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)openDropTargetAdapter);
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
    }

    static class CopyKeyAdapter
    extends KeyAdapter {
        CopyKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.stateMask == 262144 && e.keyCode == 99) {
                int idxSelectedRow = -1;
                Table tableOrigin = (Table)((Widget)e.getSource());
                idxSelectedRow = tableOrigin.getSelectionIndex();
                if (idxSelectedRow > -1) {
                    Clipboard cb = new Clipboard(Display.getCurrent());
                    TextTransfer transfer = TextTransfer.getInstance();
                    int cntColumn = tableOrigin.getColumnCount();
                    TableItem ti = tableOrigin.getItem(idxSelectedRow);
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (i < cntColumn) {
                        sb.append(ti.getText(i));
                        if (i < cntColumn - 1) {
                            sb.append('\t');
                        }
                        ++i;
                    }
                    cb.setContents(new Object[]{sb.toString()}, new Transfer[]{transfer});
                }
            }
        }
    }

    class DebugMessageColumnSelectionListener
    extends SelectionAdapter {
        private boolean isAscendingDate = true;
        private boolean isAscendingTag = true;
        private boolean isAscendingPID = true;
        private boolean isAscendingMessage = true;

        DebugMessageColumnSelectionListener() {
        }

        private void sortColumn(int index, TableColumn column) {
            TableItem[] items = CallStackView.this.tableDebugMessage.getItems();
            Collator collator = Collator.getInstance();
            boolean flag = false;
            switch (index) {
                case 0: {
                    flag = this.isAscendingDate;
                    this.isAscendingDate = !this.isAscendingDate;
                    break;
                }
                case 1: {
                    flag = this.isAscendingTag;
                    this.isAscendingTag = !this.isAscendingTag;
                    break;
                }
                case 2: {
                    flag = this.isAscendingPID;
                    this.isAscendingPID = !this.isAscendingPID;
                    break;
                }
                case 3: {
                    flag = this.isAscendingMessage;
                    this.isAscendingMessage = !this.isAscendingMessage;
                }
            }
            CallStackView.this.tableDebugMessage.setSortColumn(column);
            CallStackView.this.tableDebugMessage.setSortDirection(flag ? 128 : 1024);
            int i = 0;
            while (i < items.length) {
                String value1 = items[i].getText(index);
                int j = 0;
                while (j < i) {
                    String value2 = items[j].getText(index);
                    if (flag && collator.compare(value1, value2) < 0 || !flag && collator.compare(value1, value2) > 0) {
                        String[] values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3)};
                        items[i].dispose();
                        TableItem item = new TableItem(CallStackView.this.tableDebugMessage, 0, j);
                        item.setText(values);
                        items = CallStackView.this.tableDebugMessage.getItems();
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn columnEventSource = (TableColumn)e.getSource();
            if (columnEventSource == CallStackView.this.columnDate) {
                this.sortColumn(0, columnEventSource);
            } else if (e.getSource() == CallStackView.this.columnTag) {
                this.sortColumn(1, columnEventSource);
            } else if (e.getSource() == CallStackView.this.columnPID) {
                this.sortColumn(2, columnEventSource);
            } else if (e.getSource() == CallStackView.this.columnMessage) {
                this.sortColumn(3, columnEventSource);
            }
            CallStackView.this.tableDebugMessage.setSelection(0);
        }
    }

    class DebugMessageTextModifyListener
    implements ModifyListener {
        DebugMessageTextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.getSource();
            int idxFilter = CallStackView.this.comboFilterDebugMessage.getSelectionIndex();
            String strFilter = CallStackView.this.comboItemsFilterDebugMessage[idxFilter];
            if (CallStackView.this.csInfoVO != null) {
                CallStackView.this.filterDebugMessageTabItem(CallStackView.this.csInfoVO.getDebugMessageList(), strFilter, text.getText());
            }
        }
    }

    class ListSelectionListener
    extends SelectionAdapter {
        private int idxPreSelected = -1;
        private Color colorSelectedRow = null;

        public ListSelectionListener(Composite parent) {
            this.colorSelectedRow = new Color((Device)parent.getDisplay(), 255, 201, 14);
        }

        public void widgetSelected(SelectionEvent e) {
            int idxSelected;
            Widget selectedItem = (Widget)e.getSource();
            if (selectedItem == CallStackView.this.listHeader) {
                int idxSelected2 = CallStackView.this.listHeader.getSelectionIndex();
                if (CallStackView.this.csInfoVO != null) {
                    CallStackView.this.setHeaderTableValue(idxSelected2, CallStackView.this.csInfoVO.getHeader());
                }
            } else if (selectedItem == CallStackView.this.tableCallStack && (idxSelected = CallStackView.this.tableCallStack.getSelectionIndex()) > -1) {
                TableItem ti = CallStackView.this.tableCallStack.getItem(idxSelected);
                String str = ti.getText(1);
                if (str.startsWith("0x")) {
                    str = str.substring(2, str.length());
                }
                int idx = 0;
                long longStartAddress = 0L;
                long longEndAddress = 0L;
                long longDestiAddress = Long.valueOf(str, 16);
                TableItem[] tableItemArray = CallStackView.this.tableMemoryMap.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    longStartAddress = Long.valueOf(item.getText(0), 16);
                    longEndAddress = Long.valueOf(item.getText(1), 16);
                    if (longStartAddress <= longDestiAddress && longDestiAddress < longEndAddress) {
                        if (this.idxPreSelected > -1) {
                            CallStackView.this.tableMemoryMap.getItem(this.idxPreSelected).setBackground(null);
                        }
                        CallStackView.this.tableMemoryMap.setSelection(idx);
                        CallStackView.this.tableMemoryMap.getItem(idx).setBackground(this.colorSelectedRow);
                        CallStackView.this.tableMemoryMap.deselect(idx);
                        this.idxPreSelected = idx;
                        break;
                    }
                    ++idx;
                    ++n2;
                }
            }
        }
    }

    class OpenDropTargetAdapter
    extends DropTargetAdapter {
        OpenDropTargetAdapter() {
        }

        public void drop(DropTargetEvent event) {
            String[] strsData = (String[])event.data;
            int cntData = strsData.length;
            if (cntData == 1) {
                String strFilePath = strsData[0].trim();
                if (strFilePath.endsWith(".cs")) {
                    CSFileReader csFileReader = new CSFileReader(strFilePath);
                    csFileReader.demanglingFile();
                    CSVO result = csFileReader.parse();
                    if (result != null) {
                        CallStackView.this.initCrashInformation(result);
                    }
                } else {
                    CallStackView.this.showMessage(LogUIMessages.LOG_DIALOG_WARNING_TITLE, LogUIMessages.LOG_DIALOG_WARNING_MESSAGE_EXTENSION);
                }
            } else {
                CallStackView.this.showMessage(LogUIMessages.LOG_DIALOG_WARNING_TITLE, LogUIMessages.LOG_DIALOG_WARNING_MESSAGE_COUNT);
            }
        }
    }
}

