/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.apichecker;

import java.util.HashMap;
import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecore.apichecker.utility.CommonUtility;

public class ReporterThread
extends Thread {
    final long timeInterval = 1000L;
    IProject project;
    HashMap<String, Integer> hashMap;
    String outputStream;

    ReporterThread(IProject project, String stream) {
        this.project = project;
        this.hashMap = new HashMap();
        this.outputStream = stream;
    }

    public String getProjectPath(IProject project) {
        IPath projectLoc = project.getLocation();
        return projectLoc.toOSString();
    }

    int getLine(String privilege) {
        if (this.hashMap.containsKey(privilege)) {
            return this.hashMap.get(privilege);
        }
        return 0;
    }

    private void reportAPICheckerErrors(String inputStream) {
        String projectPath = this.getProjectPath(this.project);
        this.hashMap = CommonUtility.populateUnusedPrivileges(this.project.getFile("tizen-manifest.xml"), null);
        Scanner scanner = new Scanner(inputStream);
        try {
            IMarker[] markers = this.project.findMarkers("org.tizen.nativecore.apichecker.apicheckerproblems", true, 2);
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                marker.delete();
                ++i;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        while (scanner.hasNextLine()) {
            String[] result;
            int index;
            String line = scanner.nextLine();
            if (!line.contains("warning:") || (index = (result = line.split("warning:"))[0].lastIndexOf(":")) == -1) continue;
            result[0] = result[0].substring(0, index);
            index = result[0].lastIndexOf(":");
            if (index == -1) continue;
            result[0] = result[0].substring(0, index);
            int lineNumIndx = result[0].lastIndexOf(":");
            if (lineNumIndx == -1) continue;
            String lineNumber = result[0].substring(lineNumIndx + 1);
            String fileName = result[0].substring(0, lineNumIndx);
            int lineNum = 0;
            if (fileName.equals("../tizen-manifest.xml")) {
                fileName = String.valueOf(projectPath) + "/tizen-manifest.xml";
                String[] words = line.split(" ");
                int i = 0;
                while (i < words.length) {
                    if (words[i].startsWith("http:")) {
                        lineNum = this.getLine(words[i]);
                    }
                    ++i;
                }
                lineNumber = Integer.toString(lineNum);
            }
            Path filePath = new Path(fileName);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath);
            if (file == null) continue;
            try {
                IMarker marker = file.createMarker("org.tizen.nativecore.apichecker.apicheckerproblems");
                String message = line.substring(line.indexOf("warning:") + 8);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", 0);
                marker.setAttribute("lineNumber", Integer.parseInt(lineNumber));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        scanner.close();
    }

    @Override
    public void run() {
        while (this.outputStream.isEmpty() && CommonConfigurationManager.getOutputStream().isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.outputStream.isEmpty()) {
            this.outputStream = CommonConfigurationManager.getOutputStream();
            CommonConfigurationManager.setOutputStream((String)"");
        }
        this.reportAPICheckerErrors(this.outputStream);
    }
}

