/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.apichecker.utility;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecore.apichecker.quickfix.QuickFixer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonUtility {
    public static final String MANIFEST_FILE = "tizen-manifest.xml";
    public static final String MANIFEST_FILEPATH = "/tizen-manifest.xml";
    public static final String API_PROBLEMS = "org.tizen.nativecore.apichecker.apicheckerproblems";
    public static final String ADDITIONAL_PRIVILEGE = "needs additional privilege";
    public static final String DEPRECATED = "deprecated";
    public static final String PRIVILEGE = "Privilege";
    public static final String UNUSED_IN_PROJECT = "unused in project";
    public static final String ACCESS_PROBLEM = "Problem in accessing marker";
    public static final String AND = "and";
    public static final String AND_SPACE = " and ";
    public static final String COMMA = ", ";
    public static final String COMMA_SPACE = " , ";
    public static final String EMPTY_STRING = "";
    public static final String MARKER_NOT_EXISTS = "Marker does not exist";
    public static final String MANIFEST_EDITOR = ".ManifestEditor";
    public static final String NEED_PRIVILEGE = "needs additional privilege";
    public static final String PERIOD = " .";
    public static final String HTTP = "http:";
    public static final String PRIVILEGE_HTTP = "<privilege>http:";
    public static final String WHITESPACE = " ";
    public static final String CHECK_UNUSED_TRUE = "-check-unused=true";
    public static final String MANIFESTFILE_PROJECTPATH = "../tizen-manifest.xml";
    public static final String COLON = ":";
    public static final String WARNING = "warning:";
    public static final String APICHECKER_TOOL_PATH = "/llvm-3.6/bin/APIChecker";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String CPP_EXTENSION = ".cpp";
    public static final String EXIT_ERROR_CODE = "Exited with error code";
    public static final String FILE_PATH = " -file-path=";
    public static final String FLAG_PREFIX = " -- ";
    public static final String OSNAME = "os.name";
    public static final String RETAIN_COMMENTS = " -w -fretain-comments-from-system-headers ";
    public static final String TEMP_FILENAME = "temp-file-name";
    public static final String WINDOWS = "Windows";
    public static final String SEMI_COLON = ";";
    public static final String NEWLINE = "\n";
    private static String apiVersion;
    private static String profileName;
    private static String privilegeList;
    private static String option;
    private static Logger logger;

    static {
        option = EMPTY_STRING;
        logger = LoggerFactory.getLogger(CommonUtility.class);
    }

    public static void resetAPICheckerOptions() {
        apiVersion = null;
        profileName = null;
        privilegeList = null;
    }

    private static void parseXMLDoc(IFile ManifestFile) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(ManifestFile.getContents());
        if (doc != null) {
            NodeList Elements = doc.getElementsByTagName("manifest");
            Node node = Elements.item(0);
            Element e = (Element)node;
            apiVersion = e.getAttribute("api-version");
            Elements = doc.getElementsByTagName("profile");
            node = Elements.item(0);
            e = (Element)node;
            profileName = e.getAttribute("name");
            privilegeList = EMPTY_STRING;
            Elements = doc.getElementsByTagName("privilege");
            int i = 0;
            while (i < Elements.getLength()) {
                Element Privilege = (Element)Elements.item(i);
                privilegeList = String.valueOf(privilegeList) + Privilege.getTextContent();
                if (++i == Elements.getLength()) continue;
                privilegeList = String.valueOf(privilegeList) + ",";
            }
        }
    }

    public static boolean ParseManifestFile(IProject project) {
        if (project == null) {
            return false;
        }
        CommonUtility.resetAPICheckerOptions();
        IFile manifestFile = project.getFile(MANIFEST_FILE);
        try {
            CommonUtility.parseXMLDoc(manifestFile);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String getAPIVersion() {
        return apiVersion;
    }

    public static String getProfileName() {
        return profileName;
    }

    public static String getPrivilegeList() {
        return privilegeList;
    }

    public static String getAPICheckerOptions(IProject project) {
        if (project == null) {
            return EMPTY_STRING;
        }
        IFile manifestFile = project.getFile(MANIFEST_FILE);
        try {
            CommonUtility.parseXMLDoc(manifestFile);
        }
        catch (Exception exception) {
            return EMPTY_STRING;
        }
        if (apiVersion == null || profileName == null || privilegeList == null) {
            return EMPTY_STRING;
        }
        String options = "-api-version=" + apiVersion + " -current-profile=" + profileName + " -privilege-list=" + privilegeList;
        return options;
    }

    public static String getAPICheckerOptions(String apiVersion, String profileName, String privilegeList) {
        String options = "-api-version=" + apiVersion + " -current-profile=" + profileName + " -privilege-list=" + privilegeList;
        return options;
    }

    public static String getOptionSetByPlugin() {
        return option;
    }

    public static void setOptionSetByPlugin(String newOption) {
        option = newOption;
    }

    public static void creatUnusedPrivilegeMarkers(IProject project, HashMap<String, Integer> oldPrivilegeMap) {
        if (project == null) {
            return;
        }
        IFile file = project.getFile(MANIFEST_FILE);
        if (file == null) {
            return;
        }
        HashMap<String, Integer> unusedPrivileges = CommonUtility.populateUnusedPrivileges(file, oldPrivilegeMap);
        for (String key : unusedPrivileges.keySet()) {
            try {
                IMarker newMarker = file.createMarker(API_PROBLEMS);
                String message = PRIVILEGE + key + WHITESPACE + UNUSED_IN_PROJECT;
                newMarker.setAttribute("message", (Object)message);
                newMarker.setAttribute("severity", 0);
                newMarker.setAttribute("lineNumber", unusedPrivileges.get(key).intValue());
            }
            catch (CoreException coreException) {
                logger.error(ACCESS_PROBLEM);
            }
        }
    }

    public static HashMap<String, Integer> populateUnusedPrivileges(IFile file, HashMap<String, Integer> oldPrivilegeMap) {
        HashMap<String, Integer> newPrivilegeMap = new HashMap<String, Integer>();
        String filePath = file.getRawLocation().toOSString();
        BufferedReader br = null;
        try {
            String line;
            FileReader fileReader = new FileReader(filePath);
            br = new BufferedReader(fileReader);
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                ++lineNumber;
                if (!line.contains(PRIVILEGE_HTTP)) continue;
                StringTokenizer st = new StringTokenizer(line, "<>");
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    if (!str.startsWith(HTTP)) continue;
                    if (oldPrivilegeMap == null) {
                        newPrivilegeMap.put(str, lineNumber);
                        continue;
                    }
                    if (!oldPrivilegeMap.containsKey(str)) continue;
                    newPrivilegeMap.put(str, lineNumber);
                }
            }
            br.close();
        }
        catch (IOException iOException) {
            LoggerFactory.getLogger(QuickFixer.class).error(ACCESS_PROBLEM);
        }
        return newPrivilegeMap;
    }

    public static HashMap<String, Integer> populateUnusedPrivileges(IProject project) {
        HashMap<String, Integer> unusedPrivilegeMap = new HashMap<String, Integer>();
        IMarker[] markers = null;
        if (project == null) {
            return null;
        }
        try {
            markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (markers != null) {
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    String message;
                    IMarker testMarker = iMarkerArray[n2];
                    if (testMarker != null && (message = (String)testMarker.getAttribute("message")).contains(PRIVILEGE) && message.contains(UNUSED_IN_PROJECT)) {
                        int line = (Integer)testMarker.getAttribute("lineNumber");
                        String[] words = message.split(WHITESPACE);
                        int i = 0;
                        while (i < words.length) {
                            if (words[i].contains(HTTP)) {
                                unusedPrivilegeMap.put(words[i], line);
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {
            LoggerFactory.getLogger(QuickFixer.class).error("Problem in populating markers");
        }
        return unusedPrivilegeMap;
    }
}

