/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.core.IPrivilegeListChangeListener;
import org.tizen.nativecore.misc.core.PrivilegeManager;
import org.tizen.nativecore.misc.editor.Messages;
import org.tizen.nativecore.misc.editor.TizenFormPage;

public class PrivilegePage
extends TizenFormPage
implements SelectionListener {
    private TableViewer fViewer;
    private String imagePath;
    private FormToolkit toolkit;
    private PrivilegeManager privilegeManager;
    private ArrayList<IPrivilegeListChangeListener> fPrivilegeListeners = new ArrayList();
    private Button fBtnAdd;
    private Button feBtnEdit;
    private Button fBtnRemove;
    private String fBtnAddEnabled;
    private String fBtnEditEnabled;
    private String fBtnRemoveEnabled;

    public PrivilegePage(FormEditor editor) {
        super(editor, Messages.PrivilegePage_title, Messages.PrivilegePage_title);
        IProject project = null;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            project = file.getProject();
        }
        this.privilegeManager = new PrivilegeManager(project);
    }

    private Font getBoldFont(Control label, int fontSize) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit tk;
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        ScrolledForm scrolledForm = managedForm.getForm();
        this.toolkit = tk = managedForm.getToolkit();
        Composite body = scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout());
        GridData clientGD = new GridData(0x1000000, 0, true, true, 0, 0);
        clientGD.widthHint = 640;
        Composite client = tk.createComposite(body);
        client.setLayout((Layout)new GridLayout());
        client.setLayoutData((Object)clientGD);
        tk.decorateFormHeading(scrolledForm.getForm());
        GridData titleGridData = new GridData();
        titleGridData.horizontalAlignment = 1;
        titleGridData.grabExcessHorizontalSpace = true;
        Composite titleComposite = tk.createComposite(client);
        titleComposite.setLayout((Layout)new GridLayout(2, false));
        titleComposite.setLayoutData((Object)titleGridData);
        GridData iconImageGD = new GridData();
        iconImageGD.widthHint = 70;
        Label iconImage = new Label(titleComposite, 0x2000000);
        this.imagePath = IdePlugin.getDefault().getResourceLocationURL("icons/editor/title_privileges.png").getFile();
        iconImage.setImage(new Image(null, new ImageData(this.imagePath)));
        iconImage.setBackground(new Color(null, 255, 255, 255));
        iconImage.setLayoutData((Object)iconImageGD);
        Label titleText = new Label(titleComposite, 0x2000000);
        titleText.setText(Messages.PrivilegePage_title);
        titleText.setAlignment(0x1000000);
        titleText.setFont(this.getBoldFont((Control)titleText, 13));
        titleText.setBackground(new Color(null, 255, 255, 255));
        Label separator = new Label(client, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setBackground(new Color(null, 255, 255, 255));
        Label textLabel = new Label(client, 0);
        textLabel.setText(Messages.PrivilegePage_title);
        textLabel.setBackground(new Color(null, 255, 255, 255));
        textLabel.setFont(this.getBoldFont((Control)textLabel, 10));
        textLabel.setForeground(new Color(null, 0, 138, 238));
        GridData desGd = new GridData();
        desGd.heightHint = 50;
        Label desLabel = new Label(client, 0x1000000);
        desLabel.setText(Messages.PrivilegePage_sdesc);
        desLabel.setBackground(new Color(null, 255, 255, 255));
        desLabel.setFont(this.getBoldFont((Control)desLabel, 10));
        desLabel.setForeground(new Color(null, 51, 51, 51));
        desLabel.setLayoutData((Object)desGd);
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalAlignment = 3;
        buttonGridData.grabExcessHorizontalSpace = true;
        Composite buttonsComposite = tk.createComposite(client);
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        buttonsComposite.setLayoutData((Object)buttonGridData);
        this.fBtnAdd = new Button(buttonsComposite, 0x2000000);
        this.fBtnAddEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_add_over.png").getFile();
        this.fBtnAdd.setBackgroundImage(new Image(null, new ImageData(this.fBtnAddEnabled)));
        this.fBtnAdd.addSelectionListener((SelectionListener)this);
        this.feBtnEdit = new Button(buttonsComposite, 0x2000000);
        this.fBtnEditEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_edit_over.png").getFile();
        this.feBtnEdit.setBackgroundImage(new Image(null, new ImageData(this.fBtnEditEnabled)));
        this.feBtnEdit.addSelectionListener((SelectionListener)this);
        this.feBtnEdit.setEnabled(false);
        this.fBtnRemove = new Button(buttonsComposite, 0x2000000);
        this.fBtnRemoveEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_delete_over.png").getFile();
        this.fBtnRemove.setBackgroundImage(new Image(null, new ImageData(this.fBtnRemoveEnabled)));
        this.fBtnRemove.addSelectionListener((SelectionListener)this);
        this.fBtnRemove.setEnabled(false);
        Table table = new Table(client, 67586);
        table.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        gd.heightHint = 300;
        table.setLayoutData((Object)gd);
        this.fViewer = new TableViewer(table);
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Manifest) {
                    Manifest model = (Manifest)inputElement;
                    return model.getPrivilege_map().keySet().toArray();
                }
                return null;
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.fViewer.setInput((Object)this.getEditor().getCoreManifest());
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel != null) {
                    PrivilegePage.this.fBtnRemove.setEnabled(true);
                    PrivilegePage.this.feBtnEdit.setEnabled(true);
                } else {
                    PrivilegePage.this.fBtnRemove.setEnabled(false);
                    PrivilegePage.this.feBtnEdit.setEnabled(false);
                }
            }
        });
        this.update(this.getEditor().getCoreManifest());
        this.setDirty(false);
    }

    public void update(Manifest model) {
        if (this.fViewer != null) {
            this.fViewer.setInput((Object)model);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fBtnAdd) {
            String newPriv;
            AddCustomPrivilegeDialog dialog = new AddCustomPrivilegeDialog(this.toolkit, this);
            if (dialog.open() == 0 && (newPriv = dialog.getSelectedPrivilege()) != null) {
                this.getEditor().getCoreManifest().addPrivilege(newPriv);
                this.fViewer.add((Object)newPriv);
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)newPriv), true);
                this.setDirty(true);
            }
            return;
        }
        if (e.widget == this.fBtnRemove) {
            Object[] selected;
            IStructuredSelection sel = (IStructuredSelection)this.fViewer.getSelection();
            Object[] objectArray = selected = sel.toArray();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                String l = (String)object;
                this.getEditor().getCoreManifest().removePrivilege(l);
                this.fViewer.remove((Object)l);
                this.fBtnRemove.setEnabled(false);
                this.feBtnEdit.setEnabled(false);
                this.setDirty(true);
                ++n2;
            }
        }
        if (e.widget == this.feBtnEdit) {
            String newPriv = null;
            AddCustomPrivilegeDialog dialog = new AddCustomPrivilegeDialog(this.toolkit, this);
            IStructuredSelection sel = (IStructuredSelection)this.fViewer.getSelection();
            if (dialog.open() == 0 && (newPriv = dialog.getSelectedPrivilege()) != null) {
                Object[] selected;
                Object[] objectArray = selected = sel.toArray();
                int n = selected.length;
                int n3 = 0;
                while (n3 < n) {
                    Object object = objectArray[n3];
                    String l = (String)object;
                    this.getEditor().getCoreManifest().removePrivilege(l);
                    this.fViewer.remove((Object)l);
                    this.feBtnEdit.setEnabled(false);
                    this.fBtnRemove.setEnabled(false);
                    ++n3;
                }
                this.getEditor().getCoreManifest().addPrivilege(newPriv);
                this.fViewer.add((Object)newPriv);
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)newPriv), true);
                this.setDirty(true);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public PrivilegeManager getPrivilegeManager() {
        return this.privilegeManager;
    }

    public void addPrivilegeListChangeListener(IPrivilegeListChangeListener l) {
        this.fPrivilegeListeners.add(l);
    }

    public void firePrivilegeAdded(String privilegeName) {
        for (IPrivilegeListChangeListener listener : this.fPrivilegeListeners) {
            listener.privilegeAdded(privilegeName);
        }
    }

    public void removePrivilegeListChangeListener(IPrivilegeListChangeListener l) {
        this.fPrivilegeListeners.remove(l);
    }

    public void firePrivilegeRemoved(String privilegeName) {
        for (IPrivilegeListChangeListener listener : this.fPrivilegeListeners) {
            listener.privilegeRemoved(privilegeName);
        }
    }

    public class AddCustomPrivilegeDialog
    extends SelectionStatusDialog {
        protected FormToolkit toolkit;
        protected TizenFormPage fpage;
        protected String selectedPrivilege;
        private Text filterText;
        private List privilegeList;
        private String[] availablePrivileges;
        private int width;
        private int height;

        public AddCustomPrivilegeDialog(FormToolkit tk, TizenFormPage page) {
            super(Display.getDefault().getActiveShell());
            this.width = 50;
            this.height = 15;
            this.toolkit = tk;
            this.fpage = page;
            this.setTitle("Add Privilege");
        }

        public String getSelectedPrivilege() {
            return this.selectedPrivilege;
        }

        public void setSelectedPrivilege(String selectedPrivilege) {
            this.selectedPrivilege = selectedPrivilege;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginTop = 20;
            layout.marginBottom = 9;
            layout.marginLeft = 20;
            layout.marginRight = 20;
            layout.verticalSpacing = 10;
            composite.setLayout((Layout)layout);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 510;
            composite.setLayoutData((Object)gd);
            Label titleText = new Label(composite, 0);
            titleText.setLayoutData((Object)new GridData(256));
            titleText.setText("Add privileges to Manifest File");
            titleText.setFont(PrivilegePage.this.getBoldFont((Control)titleText, 0));
            this.filterText = new Text(composite, 2048);
            this.filterText.setLayoutData((Object)new GridData(256));
            this.privilegeList = new List(composite, 2562);
            GridData data = new GridData();
            data.widthHint = this.convertWidthInCharsToPixels(this.width);
            data.heightHint = this.convertHeightInCharsToPixels(this.height);
            data.grabExcessVerticalSpace = true;
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            this.privilegeList.setLayoutData((Object)data);
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddCustomPrivilegeDialog.this.privilegeList.removeAll();
                    String strfilter = AddCustomPrivilegeDialog.this.filterText.getText().trim();
                    if (strfilter.isEmpty()) {
                        AddCustomPrivilegeDialog.this.privilegeList.setItems(AddCustomPrivilegeDialog.this.availablePrivileges);
                        return;
                    }
                    String[] stringArray = AddCustomPrivilegeDialog.this.availablePrivileges;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String privilegeName = stringArray[n2];
                        if (privilegeName.contains(strfilter)) {
                            AddCustomPrivilegeDialog.this.privilegeList.add(privilegeName);
                        }
                        ++n2;
                    }
                }
            });
            String[] allPrivs = null;
            allPrivs = PrivilegePage.this.privilegeManager.getAvailablePrivileges();
            ArrayList<String> filtered = new ArrayList<String>(allPrivs.length);
            String[] stringArray = allPrivs;
            int n = allPrivs.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (!PrivilegePage.this.getEditor().getCoreManifest().hasPrivilege(p)) {
                    filtered.add(p);
                }
                ++n2;
            }
            if (!filtered.isEmpty()) {
                this.availablePrivileges = filtered.toArray(new String[filtered.size()]);
                Arrays.sort(this.availablePrivileges, 0, this.availablePrivileges.length, String.CASE_INSENSITIVE_ORDER);
                this.privilegeList.setItems(this.availablePrivileges);
                this.privilegeList.select(0);
            }
            return composite;
        }

        protected void computeResult() {
            this.selectedPrivilege = this.privilegeList.getItem(this.privilegeList.getSelectionIndex());
        }
    }
}

