/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.tizen.nativecore.ext.manifest.AppControl;

public class ComboEditingSupport
extends EditingSupport {
    private final TableViewer viewer;
    private final String[] list;
    private final String colString;
    private CellEditor editor;
    private String comboString;

    public ComboEditingSupport(TableViewer viewer, String[] list, String colString) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.list = list;
        this.colString = colString;
        if (viewer instanceof TableViewer) {
            this.editor = new ComboBoxCellEditor((Composite)viewer.getTable(), list, 4){

                protected Object doGetValue() {
                    String comboTempString = ((CCombo)this.getControl()).getText();
                    if (!comboTempString.isEmpty()) {
                        ComboEditingSupport.this.comboString = comboTempString;
                    }
                    return ComboEditingSupport.this.comboString;
                }
            };
        }
    }

    protected boolean canEdit(Object arg0) {
        return true;
    }

    protected CellEditor getCellEditor(Object arg0) {
        return this.editor;
    }

    protected Object getValue(Object element) {
        if (element instanceof AppControl) {
            AppControl appControl = (AppControl)element;
            if (appControl.getAppServiceItems().size() <= 0) {
                return -1;
            }
            int k = 0;
            while (k < appControl.getAppServiceItems().size()) {
                if (appControl.getAppServiceItems().get(k).getValue() != null) {
                    int i = 0;
                    while (i < this.list.length) {
                        if (appControl.getAppServiceItems().get(k).getValue().equals(this.list[i])) {
                            return i;
                        }
                        ++i;
                    }
                }
                ++k;
            }
        }
        return -1;
    }

    protected void setValue(Object element, Object value) {
        boolean updated = false;
        if (element instanceof AppControl) {
            AppControl appControl = (AppControl)element;
            if (appControl.getAppServiceItems().size() <= 0) {
                AppControl.AppControlItem item = new AppControl().new AppControl.AppControlItem();
                appControl.addAppServiceItems(item);
                appControl.getAppServiceItems().get(0).setValue((String)value);
                if (this.colString.equals("operation")) {
                    appControl.getAppServiceItems().get(0).setCategory(AppControl.CATEGORIES.operation);
                }
                if (this.colString.equals("mime")) {
                    appControl.getAppServiceItems().get(0).setCategory(AppControl.CATEGORIES.mime);
                }
            } else if (this.colString.equals("operation")) {
                int i = 0;
                while (i < appControl.getAppServiceItems().size()) {
                    if (appControl.getAppServiceItems().get(i).getCategory().equals((Object)AppControl.CATEGORIES.operation)) {
                        appControl.getAppServiceItems().get(i).setValue((String)value);
                        updated = true;
                    }
                    ++i;
                }
                if (!updated) {
                    AppControl.AppControlItem item = new AppControl().new AppControl.AppControlItem();
                    item.setCategory(AppControl.CATEGORIES.operation);
                    item.setValue((String)value);
                    appControl.addAppServiceItems(item);
                }
            } else if (this.colString.equals("mime")) {
                int i = 0;
                while (i < appControl.getAppServiceItems().size()) {
                    if (appControl.getAppServiceItems().get(i).getCategory().equals((Object)AppControl.CATEGORIES.mime)) {
                        appControl.getAppServiceItems().get(i).setValue((String)value);
                        updated = true;
                    }
                    ++i;
                }
                if (!updated) {
                    AppControl.AppControlItem item = new AppControl().new AppControl.AppControlItem();
                    item.setCategory(AppControl.CATEGORIES.mime);
                    item.setValue((String)value);
                    appControl.addAppServiceItems(item);
                }
            }
        }
        this.viewer.update(element, null);
    }
}

