/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.imagecompressor;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.ProjectUtil;

public class ImageCompressorTool {
    protected static Logger logger = LoggerFactory.getLogger(ImageCompressorTool.class);
    private static final String toolName = OSChecker.isWindows() ? "ecore_evas_convert.exe" : "ecore_evas_convert";
    private final String toolRootDir = "efl-tool";
    private final String toolDir = "efl-tools";
    private final String toolFormat = "%s && %s %s %s %s %s";
    private final String windowsToolFormat = "%s %s %s %s %s";
    private final String envFormat = "LD_LIBRARY_PATH=%s:$LD_LIBRARY_PATH";
    private final String[] encodingType = new String[]{"etc2", "etc1"};
    private final String qualityOptionFormat = "-q=%s";
    private final String encodingOptionFormat = "-e=%s";
    private IProject project;

    public ImageCompressorTool(IProject project) {
        this.project = project;
    }

    private String makeCommand(String srcFile, String destFile) {
        ProfileInfo info = ProjectUtil.getTizenProjectDescription((IProject)this.project).getPlatformInfo();
        String commonTools = InstallPathConfig.getPlatformToolsPath((String)info.getProfile(), (String)info.getLatestPlatformVersion());
        String fullpathOfEflTool = FileUtil.appendPath((String)commonTools, (String)"efl-tool");
        fullpathOfEflTool = FileUtil.appendPath((String)fullpathOfEflTool, (String)"efl-tools");
        String eflToolBin = FileUtil.appendPath((String)fullpathOfEflTool, (String)"bin");
        String eflToolLib = FileUtil.appendPath((String)fullpathOfEflTool, (String)"lib");
        String env = String.format("LD_LIBRARY_PATH=%s:$LD_LIBRARY_PATH", eflToolLib);
        String tool = FileUtil.appendPath((String)eflToolBin, (String)toolName);
        String qualityOption = String.format("-q=%s", "100");
        String encodingOption = String.format("-e=%s", this.encodingType[0]);
        if (OSChecker.isWindows()) {
            return String.format("%s %s %s %s %s", tool, qualityOption, encodingOption, srcFile, destFile);
        }
        return String.format("%s && %s %s %s %s %s", env, tool, qualityOption, encodingOption, srcFile, destFile);
    }

    private String makeToolPath() {
        ProfileInfo info = ProjectUtil.getTizenProjectDescription((IProject)this.project).getPlatformInfo();
        String commonTools = InstallPathConfig.getPlatformToolsPath((String)info.getProfile(), (String)info.getLatestPlatformVersion());
        String fullpathOfEflTool = FileUtil.appendPath((String)commonTools, (String)"efl-tool");
        fullpathOfEflTool = FileUtil.appendPath((String)fullpathOfEflTool, (String)"efl-tools");
        String eflToolBin = FileUtil.appendPath((String)fullpathOfEflTool, (String)"bin");
        return FileUtil.appendPath((String)eflToolBin, (String)toolName);
    }

    public boolean execute(String srcFile, String destFile) {
        String errorCheck = OSChecker.isWindows() ? " 1> NUL" : " 1> /dev/null";
        String result = HostUtil.returnExecute((String)(String.valueOf(this.makeCommand(srcFile, destFile)) + errorCheck), null, (boolean)true);
        if (!result.isEmpty()) {
            logger.error(String.valueOf(toolName) + "'s result: " + result);
            return false;
        }
        return true;
    }

    public boolean exists() {
        File toolFile = new File(this.makeToolPath());
        return toolFile.exists();
    }
}

