/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.csviewer.action;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.tizen.nativecore.csviewer.control.CSFileReader;
import org.tizen.nativecore.csviewer.model.CSVO;
import org.tizen.nativecore.csviewer.view.CallStackView;

public class OpenCSFileActionDelegate
implements IViewActionDelegate {
    private static final String ID_ACTION_OPEN = "org.tizen.nativecore.csviewer.action.OpenCSFile";
    private CallStackView csView;

    public void run(IAction action) {
        String strID = action.getId();
        if (strID.equals(ID_ACTION_OPEN)) {
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
            dialog.setText("Select Call Stack File");
            File file = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            dialog.setFilterPath(file.getAbsolutePath());
            dialog.setFilterExtensions(new String[]{"*.cs"});
            dialog.setFilterIndex(0);
            String csFilePath = dialog.open();
            if (csFilePath != null) {
                CSFileReader csFileReader = new CSFileReader(csFilePath);
                csFileReader.demanglingFile();
                CSVO result = csFileReader.parse();
                if (result != null) {
                    this.csView.initCrashInformation(result);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        this.csView = (CallStackView)view;
    }
}

