/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.editor.CoreProjectInfoSection;
import org.tizen.nativecore.misc.editor.LinkSection;
import org.tizen.nativecore.misc.editor.Messages;
import org.tizen.nativecore.misc.editor.SectionHelper;
import org.tizen.nativecore.misc.editor.TizenFormPage;

public class CoreOverviewPage
extends TizenFormPage {
    public CoreProjectInfoSection projInfo;
    public LinkSection linkSection;
    public String imagePath;
    public boolean IsValidAppId = true;
    public boolean IsValidPackage = true;
    public boolean IsValidVersion = true;
    public boolean IsValidAPIVersion = true;
    public boolean IsValidExe = true;

    public CoreOverviewPage(FormEditor editor) {
        super(editor, "Overview", "Overview");
    }

    private Font getBoldFont(Control label, int fontSize) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm scrolledForm = managedForm.getForm();
        FormToolkit tk = managedForm.getToolkit();
        Composite body = scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout());
        this.imagePath = IdePlugin.getDefault().getResourceLocationURL("icons/editor/title_overview.png").getFile();
        Composite client = SectionHelper.createHeaderSection(tk, body, Messages.CoreOverviewPage_title, this.imagePath, Messages.CoreOverviewPage_title_info, Messages.CoreOverviewPage_title_description);
        this.create_GeneralControl(client, tk);
        this.update(this.getEditor().getCoreManifest());
        this.setDirty(false);
    }

    String createFormTextContent(IMessage[] messages) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<form>");
        int i = 0;
        while (i < messages.length) {
            IMessage message = messages[i];
            pw.print("<li vspace=\"false\" style=\"image\" indent=\"16\" value=\"");
            switch (message.getMessageType()) {
                case 3: {
                    pw.print("error");
                    break;
                }
                case 2: {
                    pw.print("warning");
                    break;
                }
                case 1: {
                    pw.print("info");
                    break;
                }
            }
            pw.print("\"> <a href=\"");
            pw.print(String.valueOf(i));
            pw.print("\">");
            pw.print(message.getKey());
            pw.println("</a></li>");
            ++i;
        }
        pw.println("</form>");
        pw.flush();
        return sw.toString();
    }

    private Image getImage(int type) {
        switch (type) {
            case 3: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            case 2: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            case 1: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }

    protected void create_GeneralControl(Composite parent, FormToolkit tk) {
        this.create_GeneralControl_Left(tk, parent);
    }

    private void create_GeneralControl_Left(FormToolkit tk, Composite body) {
        this.projInfo = new CoreProjectInfoSection(tk, body, this);
    }

    public static boolean checkLegal(String str, String illegalStr) {
        int i = 0;
        while (i < str.length()) {
            int j = 0;
            while (j < illegalStr.length()) {
                if (str.charAt(i) == illegalStr.charAt(j)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void update(Manifest coreManifest) {
        this.projInfo.update(coreManifest);
    }
}

